/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.TimeMapper;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.SingleCoord;
import uk.ac.starlink.ttools.plot2.data.StorageType;
import uk.ac.starlink.ttools.plot2.data.Tuple;

public class FloatingCoord
extends SingleCoord {
    private final Number nan_;
    public static FloatingCoord WEIGHT_COORD = FloatingCoord.createCoord(new InputMeta("weight", "Weight").setShortDescription("Non-unit weighting of data points").setXmlDescription(new String[]{"<p>Weighting of data points.", "If supplied, each point contributes a value", "to the histogram equal to the data value", "multiplied by this coordinate.", "If not supplied, the effect is the same as", "supplying a fixed value of one.", "</p>"}), false);

    private FloatingCoord(InputMeta meta, boolean isRequired, boolean isDouble, Class inputClass, Class<? extends DomainMapper> domain) {
        super(meta, isRequired, inputClass, isDouble ? StorageType.DOUBLE : StorageType.FLOAT, domain);
        this.nan_ = isDouble ? new Double(Double.NaN) : (double)new Float(Float.NaN).floatValue();
    }

    @Override
    public Object inputToStorage(Object[] userValues, DomainMapper[] mappers) {
        Object c = userValues[0];
        return c instanceof Number ? (Number)((Number)c) : (Number)this.nan_;
    }

    public double readDoubleCoord(Tuple tuple, int icol) {
        return tuple.getDoubleValue(icol);
    }

    public static FloatingCoord createCoord(InputMeta meta, boolean isRequired) {
        return new FloatingCoord(meta, isRequired, PlotUtil.storeFullPrecision(), Number.class, null);
    }

    public static FloatingCoord createTimeCoord(InputMeta meta, boolean isRequired) {
        final Double nan = new Double(Double.NaN);
        return new FloatingCoord(meta, isRequired, true, Object.class, TimeMapper.class){

            @Override
            public Object inputToStorage(Object[] userValues, DomainMapper[] mappers) {
                DomainMapper mapper = mappers[0];
                Object userValue = userValues[0];
                if (mapper instanceof TimeMapper) {
                    return ((TimeMapper)mapper).toUnixSeconds(userValue);
                }
                return userValue instanceof Number ? (Number)((Number)userValue) : (Number)nan;
            }
        };
    }
}

