/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.SingleCoord;
import uk.ac.starlink.ttools.plot2.data.StorageType;
import uk.ac.starlink.ttools.plot2.data.Tuple;

public class IntegerCoord
extends SingleCoord {
    private final Number badval_;

    public IntegerCoord(InputMeta meta, boolean isRequired, IntType itype) {
        super(meta, isRequired, Number.class, itype.stype_, null);
        this.badval_ = itype.badval_;
    }

    @Override
    public Object inputToStorage(Object[] userValues, DomainMapper[] mappers) {
        Object c = userValues[0];
        return c instanceof Number ? (Number)((Number)c) : (Number)this.badval_;
    }

    public int readIntCoord(Tuple tuple, int icol) {
        return tuple.getIntValue(icol);
    }

    public static enum IntType {
        BYTE(StorageType.BYTE, new Byte(-128)),
        SHORT(StorageType.SHORT, new Short(Short.MIN_VALUE)),
        INT(StorageType.INT, new Integer(Integer.MIN_VALUE));

        private final StorageType stype_;
        private final Number badval_;

        private IntType(StorageType stype, Number badval) {
            this.stype_ = stype;
            this.badval_ = badval;
        }
    }
}

