/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.DataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.Input;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.data.UserDataReader;

public class SimpleDataStoreFactory
implements DataStoreFactory,
DataStore {
    private static Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2");

    @Override
    public boolean hasData(DataSpec spec) {
        return true;
    }

    @Override
    public DataStore readDataStore(DataSpec[] specs, DataStore prevStore) {
        return this;
    }

    @Override
    public TupleSequence getTupleSequence(DataSpec spec) {
        try {
            RowSequence rseq = spec.getSourceTable().getRowSequence();
            return new SimpleTupleSequence(spec, rseq);
        }
        catch (IOException e) {
            logger_.log(Level.WARNING, "Error reading plot data", e);
            return PlotUtil.EMPTY_TUPLE_SEQUENCE;
        }
    }

    public static DomainMapper[] getUserCoordMappers(DataSpec dataSpec, int icoord) {
        ValueInfo[] userInfos = dataSpec.getUserCoordInfos(icoord);
        Input[] inputs = dataSpec.getCoord(icoord).getInputs();
        int nu = inputs.length;
        DomainMapper[] mappers = new DomainMapper[nu];
        for (int iu = 0; iu < nu; ++iu) {
            Class<? extends DomainMapper> reqClazz = inputs[iu].getDomain();
            if (reqClazz == null) continue;
            DomainMapper[] infoMappers = userInfos[iu].getDomainMappers();
            for (int im = 0; im < infoMappers.length && mappers[iu] == null; ++im) {
                if (!reqClazz.isInstance(infoMappers[im])) continue;
                mappers[iu] = infoMappers[im];
            }
        }
        return mappers;
    }

    private static class SimpleTupleSequence
    implements TupleSequence {
        private final DataSpec spec_;
        private final UserDataReader reader_;
        private final RowSequence baseSeq_;
        private final DomainMapper[][] mappers_;
        private long irow_ = -1L;
        private boolean failed_;

        SimpleTupleSequence(DataSpec spec, RowSequence rseq) {
            this.spec_ = spec;
            this.reader_ = spec.createUserDataReader();
            this.baseSeq_ = rseq;
            int nc = spec.getCoordCount();
            this.mappers_ = new DomainMapper[nc][];
            for (int ic = 0; ic < nc; ++ic) {
                this.mappers_[ic] = SimpleDataStoreFactory.getUserCoordMappers(spec, ic);
            }
        }

        @Override
        public boolean next() {
            try {
                while (!this.failed_ && this.baseSeq_.next()) {
                    if (!this.reader_.getMaskFlag(this.baseSeq_, ++this.irow_)) continue;
                    return true;
                }
            }
            catch (IOException e) {
                this.logError(e);
            }
            try {
                this.baseSeq_.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public long getRowIndex() {
            return this.irow_;
        }

        @Override
        public Object getObjectValue(int icol) {
            try {
                Object[] userCoords = this.reader_.getUserCoordValues(this.baseSeq_, this.irow_, icol);
                Object value = this.spec_.getCoord(icol).inputToStorage(userCoords, this.mappers_[icol]);
                assert (value != null);
                return value;
            }
            catch (IOException e) {
                this.logError(e);
                return null;
            }
        }

        @Override
        public double getDoubleValue(int icol) {
            Object obj = this.getObjectValue(icol);
            return obj instanceof Number ? ((Number)obj).doubleValue() : Double.NaN;
        }

        @Override
        public int getIntValue(int icol) {
            Object obj = this.getObjectValue(icol);
            return obj instanceof Number ? ((Number)obj).intValue() : Integer.MIN_VALUE;
        }

        @Override
        public boolean getBooleanValue(int icol) {
            return Boolean.TRUE.equals(this.getObjectValue(icol));
        }

        private void logError(IOException err) {
            this.failed_ = true;
            logger_.log(Level.WARNING, "Error reading plot data - truncating sequence", err);
        }
    }
}

