/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.Input;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.StorageType;
import uk.ac.starlink.ttools.plot2.data.Tuple;

public abstract class SkyCoord
implements Coord {
    private final SkyVariant skyVariant_;
    private final StorageType storageType_;
    private final boolean isRequired_;
    private static final double[] NO_SKY = new double[]{Double.NaN, Double.NaN, Double.NaN};
    private static final int[] ZERO3 = new int[3];

    private SkyCoord(SkyVariant skyVariant, StorageType storageType, boolean isRequired) {
        this.skyVariant_ = skyVariant;
        this.storageType_ = storageType;
        this.isRequired_ = isRequired;
    }

    @Override
    public Input[] getInputs() {
        return this.skyVariant_.getInputs();
    }

    @Override
    public StorageType getStorageType() {
        return this.storageType_;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired_;
    }

    public abstract boolean readSkyCoord(Tuple var1, int var2, double[] var3);

    public static SkyCoord createCoord(SkyVariant variant, boolean isRequired) {
        if (PlotUtil.storeFullPrecision()) {
            return new DoubleSkyCoord(variant, isRequired);
        }
        if (variant.hasRadius()) {
            return new FloatSkyCoord(variant, isRequired);
        }
        return new IntegerSkyCoord(variant, isRequired);
    }

    public static double[] lonLatDegreesToDouble3(double lonDeg, double latDeg) {
        if (latDeg >= -90.0 && latDeg <= 90.0) {
            double theta = Math.toRadians(90.0 - latDeg);
            double phi = Math.toRadians(lonDeg % 360.0);
            double z = Math.cos(theta);
            double sd = Math.sin(theta);
            double x = Math.cos(phi) * sd;
            double y = Math.sin(phi) * sd;
            return new double[]{x, y, z};
        }
        return NO_SKY;
    }

    private static SkyVariant createSurfaceSkyVariant() {
        return new SkyVariant(false){

            @Override
            public Input[] getInputs() {
                return new Input[]{this.lonInput_, this.latInput_};
            }

            @Override
            public double[] inputToDouble3(Object[] values) {
                return 1.getUnitVector(values[0], values[1]);
            }
        };
    }

    private static SkyVariant createVolumeSkyVariant(boolean nullRadiusPermitted) {
        return nullRadiusPermitted ? new VolumeSkyVariant(){

            @Override
            public double[] getNoRadiusVector(Object lonObj, Object latObj) {
                return 2.getUnitVector(lonObj, latObj);
            }
        } : new VolumeSkyVariant(){

            @Override
            public double[] getNoRadiusVector(Object lonObj, Object latObj) {
                return new double[]{Double.NaN, Double.NaN, Double.NaN};
            }
        };
    }

    static /* synthetic */ SkyVariant access$300() {
        return SkyCoord.createSurfaceSkyVariant();
    }

    static /* synthetic */ SkyVariant access$400(boolean x0) {
        return SkyCoord.createVolumeSkyVariant(x0);
    }

    private static abstract class VolumeSkyVariant
    extends SkyVariant {
        private final Input radiusInput_;

        VolumeSkyVariant() {
            super(true);
            InputMeta meta = new InputMeta("r", "Radius").setShortDescription("Radial distance");
            this.radiusInput_ = new Input(meta, Number.class, null);
        }

        @Override
        public Input[] getInputs() {
            return new Input[]{this.lonInput_, this.latInput_, this.radiusInput_};
        }

        @Override
        public double[] inputToDouble3(Object[] inputValues) {
            double radius;
            Object radObj = inputValues[2];
            if (radObj instanceof Number && !Double.isNaN(radius = ((Number)radObj).doubleValue())) {
                double[] vec3 = VolumeSkyVariant.getUnitVector(inputValues[0], inputValues[1]);
                vec3[0] = vec3[0] * radius;
                vec3[1] = vec3[1] * radius;
                vec3[2] = vec3[2] * radius;
                return vec3;
            }
            return this.getNoRadiusVector(inputValues[0], inputValues[1]);
        }

        abstract double[] getNoRadiusVector(Object var1, Object var2);
    }

    public static abstract class SkyVariant {
        private final boolean hasRadius_;
        final Input lonInput_;
        final Input latInput_;
        public static SkyVariant SURFACE = SkyCoord.access$300();
        public static SkyVariant VOLUME_OR_NULL = SkyCoord.access$400(false);
        public static SkyVariant VOLUME_OR_UNIT = SkyCoord.access$400(true);

        private SkyVariant(boolean hasRadius) {
            this.hasRadius_ = hasRadius;
            InputMeta lonMeta = new InputMeta("lon", "Lon").setShortDescription("Longitude in decimal degrees").setValueUsage("deg");
            InputMeta latMeta = new InputMeta("lat", "Lat").setShortDescription("Latitude in decimal degrees").setValueUsage("deg");
            this.lonInput_ = new Input(lonMeta, Number.class, null);
            this.latInput_ = new Input(latMeta, Number.class, null);
        }

        abstract Input[] getInputs();

        abstract double[] inputToDouble3(Object[] var1);

        boolean hasRadius() {
            return this.hasRadius_;
        }

        private static double toDouble(Object val) {
            return val instanceof Number ? ((Number)val).doubleValue() : Double.NaN;
        }

        static double[] getUnitVector(Object lonObj, Object latObj) {
            return SkyCoord.lonLatDegreesToDouble3(SkyVariant.toDouble(lonObj), SkyVariant.toDouble(latObj));
        }
    }

    private static class IntegerSkyCoord
    extends SkyCoord {
        private final SkyVariant variant_;
        private static final double SCALE = 2.147483648E9;
        private static final double SCALE1 = 4.656612873077393E-10;

        IntegerSkyCoord(SkyVariant variant, boolean isRequired) {
            super(variant, StorageType.INT3, isRequired);
            this.variant_ = variant;
        }

        @Override
        public Object inputToStorage(Object[] values, DomainMapper[] mappers) {
            double[] v3 = this.variant_.inputToDouble3(values);
            if (v3 == NO_SKY) {
                return ZERO3;
            }
            return new int[]{(int)(2.147483648E9 * v3[0]), (int)(2.147483648E9 * v3[1]), (int)(2.147483648E9 * v3[2])};
        }

        @Override
        public boolean readSkyCoord(Tuple tuple, int icol, double[] v3) {
            int[] ival = (int[])tuple.getObjectValue(icol);
            int ix = ival[0];
            int iy = ival[1];
            int iz = ival[2];
            if (ix == 0 && iy == 0 && iz == 0) {
                return false;
            }
            v3[0] = (double)ix * 4.656612873077393E-10;
            v3[1] = (double)iy * 4.656612873077393E-10;
            v3[2] = (double)iz * 4.656612873077393E-10;
            return true;
        }
    }

    private static class FloatSkyCoord
    extends SkyCoord {
        private final SkyVariant variant_;

        FloatSkyCoord(SkyVariant variant, boolean isRequired) {
            super(variant, StorageType.FLOAT3, isRequired);
            this.variant_ = variant;
        }

        @Override
        public Object inputToStorage(Object[] values, DomainMapper[] mappers) {
            double[] d3 = this.variant_.inputToDouble3(values);
            return new float[]{(float)d3[0], (float)d3[1], (float)d3[2]};
        }

        @Override
        public boolean readSkyCoord(Tuple tuple, int icol, double[] v3) {
            float[] fval = (float[])tuple.getObjectValue(icol);
            if (Float.isNaN(fval[0])) {
                return false;
            }
            v3[0] = fval[0];
            v3[1] = fval[1];
            v3[2] = fval[2];
            return true;
        }
    }

    private static class DoubleSkyCoord
    extends SkyCoord {
        private final SkyVariant variant_;

        DoubleSkyCoord(SkyVariant variant, boolean isRequired) {
            super(variant, StorageType.DOUBLE3, isRequired);
            this.variant_ = variant;
        }

        @Override
        public Object inputToStorage(Object[] values, DomainMapper[] mappers) {
            return this.variant_.inputToDouble3(values);
        }

        @Override
        public boolean readSkyCoord(Tuple tuple, int icol, double[] v3) {
            double[] dval = (double[])tuple.getObjectValue(icol);
            if (Double.isNaN(dval[0])) {
                return false;
            }
            v3[0] = dval[0];
            v3[1] = dval[1];
            v3[2] = dval[2];
            return true;
        }
    }
}

