/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.ac.starlink.ttools.plot2.Decoration;
import uk.ac.starlink.ttools.plot2.Gesture;
import uk.ac.starlink.ttools.plot2.NavAction;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.CombinationConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.geom.CubeAspect;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.geom.NavDecorations3D;

public class CubeNavigator
implements Navigator<CubeAspect> {
    private final double zoomFactor_;
    private final boolean[] axisFlags_;
    private static final char[] XYZ = new char[]{'X', 'Y', 'Z'};
    public static final ConfigKey<boolean[]> ZOOMAXES_KEY = new CombinationConfigKey(new ConfigMeta("zoomaxes", "Zoom Axes").setShortDescription("Axes affected by zooming").setXmlDescription(new String[]{"<p>Determines which axes are affected by zoom navigation", "actions.", "</p>", "<p>If no value is supplied (the default),", "the mouse wheel zooms around the center of the cube,", "and right-button (or CTRL-) drag zooms in the two dimensions", "most closely aligned with the plane of the screen,", "with the reference position set by the initial position", "of the mouse.", "</p>", "<p>If this value is set", "(legal values are", "<code>x</code>, <code>y</code>, <code>z</code>,", "<code>xy</code>, <code>yz</code>, <code>xz</code>", "and <code>xyz</code>)", "then all zoom operations are around the cube center", "and affect the axes named.", "</p>"}).setStringUsage("[[x][y][z]]"), null, new String[]{"X", "Y", "Z"}, "Auto");

    public CubeNavigator(double zoomFactor, boolean[] axisFlags) {
        this.zoomFactor_ = zoomFactor;
        this.axisFlags_ = axisFlags;
    }

    @Override
    public NavAction<CubeAspect> drag(Surface surface, Point pos, int ibutt, Point origin) {
        CubeSurface csurf = (CubeSurface)surface;
        if (ibutt == 1) {
            CubeAspect aspect = csurf.pan(origin, pos);
            return new NavAction<CubeAspect>(aspect, null);
        }
        if (ibutt == 2) {
            CubeAspect aspect = csurf.pointPan(origin, pos);
            Decoration dec = NavDecorations3D.create2dPanDecoration(csurf, pos);
            return new NavAction<CubeAspect>(aspect, dec);
        }
        if (ibutt == 3) {
            if (this.axisFlags_ == null) {
                double xf = PlotUtil.toZoom(this.zoomFactor_, origin, pos, false);
                double yf = PlotUtil.toZoom(this.zoomFactor_, origin, pos, true);
                CubeAspect aspect = csurf.pointZoom(origin, xf, yf);
                Decoration dec = NavDecorations3D.create2dZoomDecoration(csurf, origin, xf, yf);
                return new NavAction<CubeAspect>(aspect, dec);
            }
            double fact = PlotUtil.toZoom(this.zoomFactor_, origin, pos, null);
            CubeAspect aspect = csurf.centerZoom(fact, this.axisFlags_);
            Decoration dec = NavDecorations3D.createCenterDragDecoration(csurf, fact, this.axisFlags_);
            return new NavAction<CubeAspect>(aspect, dec);
        }
        assert (false);
        return null;
    }

    @Override
    public NavAction<CubeAspect> endDrag(Surface surface, Point pos, int ibutt, Point origin) {
        return null;
    }

    @Override
    public NavAction<CubeAspect> wheel(Surface surface, Point pos, int wheelrot) {
        boolean[] blArray;
        if (this.axisFlags_ == null) {
            boolean[] blArray2 = new boolean[3];
            blArray2[0] = true;
            blArray2[1] = true;
            blArray = blArray2;
            blArray2[2] = true;
        } else {
            blArray = this.axisFlags_;
        }
        boolean[] useFlags = blArray;
        CubeSurface csurf = (CubeSurface)surface;
        double fact = PlotUtil.toZoom(this.zoomFactor_, wheelrot);
        CubeAspect aspect = csurf.centerZoom(fact, useFlags);
        Decoration dec = NavDecorations3D.createCenterWheelDecoration(csurf, fact, useFlags);
        return new NavAction<CubeAspect>(aspect, dec);
    }

    @Override
    public NavAction<CubeAspect> click(Surface surface, Point pos, int ibutt, Iterable<double[]> dposIt) {
        CubeSurface csurf = (CubeSurface)surface;
        double[] dpos = surface.graphicsToData(pos, dposIt);
        if (dpos == null) {
            return null;
        }
        CubeAspect aspect = ((CubeSurface)surface).center(dpos);
        Decoration dec = NavDecorations3D.createRecenterDecoration(csurf, pos);
        return new NavAction<CubeAspect>(aspect, dec);
    }

    @Override
    public Map<Gesture, String> getNavOptions(Surface surface, Point pos) {
        String wzoomTxt;
        int[] dirs = ((CubeSurface)surface).getScreenDirections();
        String planeTxt = new String(new char[]{XYZ[dirs[0]], '/', XYZ[dirs[1]]});
        if (this.axisFlags_ == null || this.axisFlags_[0] && this.axisFlags_[1] && this.axisFlags_[2]) {
            wzoomTxt = " Iso";
        } else {
            int leng = 4;
            StringBuffer wzBuf = new StringBuffer(leng);
            for (int idim = 0; idim < 3; ++idim) {
                if (!this.axisFlags_[idim]) continue;
                if (wzBuf.length() > 0) {
                    wzBuf.append('/');
                }
                wzBuf.append(XYZ[idim]);
            }
            wzBuf.insert(0, ' ');
            while (wzBuf.length() < leng) {
                wzBuf.append(' ');
            }
            wzoomTxt = wzBuf.toString();
            assert (wzoomTxt.length() == leng);
        }
        LinkedHashMap<Gesture, String> map = new LinkedHashMap<Gesture, String>();
        map.put(Gesture.DRAG_1, "Rotate");
        map.put(Gesture.WHEEL, "Zoom Center" + wzoomTxt);
        map.put(Gesture.CLICK_3, "Re-center");
        map.put(Gesture.DRAG_2, "Pan " + planeTxt);
        map.put(Gesture.DRAG_3, this.axisFlags_ == null ? "Zoom " + planeTxt : "Zoom Center" + wzoomTxt);
        return map;
    }

    public static ConfigKey[] getConfigKeys(boolean isIso) {
        ArrayList<ConfigKey<Object>> list = new ArrayList<ConfigKey<Object>>();
        if (!isIso) {
            list.add(ZOOMAXES_KEY);
        }
        list.add(StyleKeys.ZOOM_FACTOR);
        return list.toArray(new ConfigKey[0]);
    }

    public static CubeNavigator createNavigator(boolean isIso, ConfigMap config) {
        boolean[] blArray;
        double zoom = config.get(StyleKeys.ZOOM_FACTOR);
        if (isIso) {
            boolean[] blArray2 = new boolean[3];
            blArray2[0] = true;
            blArray2[1] = true;
            blArray = blArray2;
            blArray2[2] = true;
        } else {
            blArray = config.get(ZOOMAXES_KEY);
        }
        boolean[] zoomFlags = blArray;
        return new CubeNavigator(zoom, zoomFlags);
    }
}

