/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotType;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.geom.CubeDataGeom;
import uk.ac.starlink.ttools.plot2.geom.CubeSurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.SphereDataGeom;
import uk.ac.starlink.ttools.plot2.layer.CartesianErrorCoordSet;
import uk.ac.starlink.ttools.plot2.layer.CartesianVectorCoordSet;
import uk.ac.starlink.ttools.plot2.layer.ContourPlotter;
import uk.ac.starlink.ttools.plot2.layer.LabelPlotter;
import uk.ac.starlink.ttools.plot2.layer.MarkForm;
import uk.ac.starlink.ttools.plot2.layer.MultiPointForm;
import uk.ac.starlink.ttools.plot2.layer.PairLinkForm;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapeMode;
import uk.ac.starlink.ttools.plot2.layer.ShapePlotter;
import uk.ac.starlink.ttools.plot2.layer.SizeForm;
import uk.ac.starlink.ttools.plot2.layer.SizeXyForm;
import uk.ac.starlink.ttools.plot2.paper.PaperTypeSelector;

public class CubePlotType
implements PlotType {
    private static final SurfaceFactory SURFACE_FACTORY = new CubeSurfaceFactory(false);
    private final DataGeom[] dataGeoms_ = new DataGeom[]{CubeDataGeom.INSTANCE, SphereDataGeom.INSTANCE};
    private final String[] axisNames_;
    private static final CubePlotType INSTANCE = new CubePlotType();

    private CubePlotType() {
        Coord[] coords = this.dataGeoms_[0].getPosCoords();
        this.axisNames_ = new String[coords.length];
        for (int i = 0; i < coords.length; ++i) {
            this.axisNames_[i] = ((FloatingCoord)coords[i]).getInput().getMeta().getLongName();
        }
    }

    @Override
    public DataGeom[] getPointDataGeoms() {
        return this.dataGeoms_;
    }

    @Override
    public Plotter[] getPlotters() {
        ArrayList<Plotter> list = new ArrayList<Plotter>();
        ShapeForm[] forms = new ShapeForm[]{MarkForm.SINGLE, SizeForm.getInstance(), SizeXyForm.getInstance(), MultiPointForm.createVectorForm("XYZVector", new CartesianVectorCoordSet(this.axisNames_), true), MultiPointForm.createErrorForm("XYZError", CartesianErrorCoordSet.createAllAxesErrorCoordSet(this.axisNames_), StyleKeys.ERROR_SHAPE_3D), PairLinkForm.getInstance(), MarkForm.PAIR};
        ShapePlotter.ShapeModePlotter[] shapePlotters = ShapePlotter.createShapePlotters(forms, ShapeMode.MODES_3D);
        list.addAll(Arrays.asList(shapePlotters));
        list.addAll(Arrays.asList(new LabelPlotter(), new ContourPlotter()));
        return list.toArray(new Plotter[0]);
    }

    @Override
    public SurfaceFactory getSurfaceFactory() {
        return SURFACE_FACTORY;
    }

    @Override
    public PaperTypeSelector getPaperTypeSelector() {
        return PaperTypeSelector.SELECTOR_3D;
    }

    public String toString() {
        return "cube";
    }

    public static CubePlotType getInstance() {
        return INSTANCE;
    }
}

