/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;
import uk.ac.starlink.ttools.plot.Corner;
import uk.ac.starlink.ttools.plot.Matrices;
import uk.ac.starlink.ttools.plot.Plot3D;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.BasicTicker;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Orientation;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.Tick;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.geom.CubeAspect;
import uk.ac.starlink.ttools.plot2.geom.CubeSurfaceFactory;

public class CubeSurface
implements Surface {
    private final int gxlo_;
    private final int gxhi_;
    private final int gylo_;
    private final int gyhi_;
    private final double[] dlos_;
    private final double[] dhis_;
    private final boolean[] logFlags_;
    private final boolean[] flipFlags_;
    private final double[] rotmat_;
    private final double zoom_;
    private final double xoff_;
    private final double yoff_;
    private final Tick[][] ticks_;
    private final String[] labels_;
    private final Captioner captioner_;
    private final boolean frame_;
    private final boolean antialias_;
    private final double[] dummyZ_;
    private final double gScale_;
    private final double gZoom_;
    private final int gXoff_;
    private final int gYoff_;
    private final double[] dScales_;
    private final double[] dOffs_;
    private static final Orientation ORIENTATION = Orientation.X;

    public CubeSurface(int gxlo, int gxhi, int gylo, int gyhi, double[] dlos, double[] dhis, boolean[] logFlags, boolean[] flipFlags, double[] rotmat, double zoom, double xoff, double yoff, Tick[][] ticks, String[] labels, Captioner captioner, boolean frame, boolean antialias) {
        this.gxlo_ = gxlo;
        this.gxhi_ = gxhi;
        this.gylo_ = gylo;
        this.gyhi_ = gyhi;
        this.dlos_ = (double[])dlos.clone();
        this.dhis_ = (double[])dhis.clone();
        this.logFlags_ = (boolean[])logFlags.clone();
        this.flipFlags_ = (boolean[])flipFlags.clone();
        this.rotmat_ = (double[])rotmat.clone();
        this.zoom_ = zoom;
        this.xoff_ = xoff;
        this.yoff_ = yoff;
        this.ticks_ = (Tick[][])ticks.clone();
        this.labels_ = (String[])labels.clone();
        this.captioner_ = captioner;
        this.frame_ = frame;
        this.antialias_ = antialias;
        this.gScale_ = CubeSurface.getPixelScale(gxhi - gxlo, gyhi - gylo);
        this.gZoom_ = this.zoom_ * this.gScale_ / 2.0;
        this.gXoff_ = this.gxlo_ + (int)(this.xoff_ * this.gScale_) + (this.gxhi_ - this.gxlo_) / 2;
        this.gYoff_ = this.gylo_ + (int)(this.yoff_ * this.gScale_) + (this.gyhi_ - this.gylo_) / 2;
        this.dOffs_ = new double[3];
        this.dScales_ = new double[3];
        for (int id = 0; id < 3; ++id) {
            boolean logFlag = this.logFlags_[id];
            double flipMult = this.flipFlags_[id] ? -1.0 : 1.0;
            boolean flipFlag = this.flipFlags_[id];
            double dlo = logFlag ? Math.log(this.dlos_[id]) : this.dlos_[id];
            double dhi = logFlag ? Math.log(this.dhis_[id]) : this.dhis_[id];
            this.dOffs_[id] = -(dlo + dhi) / 2.0;
            this.dScales_[id] = flipMult / (dhi - dlo) * 2.0;
            assert (PlotUtil.approxEquals(-flipMult, this.normalise(this.dlos_, id)));
            assert (PlotUtil.approxEquals(flipMult, this.normalise(this.dhis_, id)));
        }
        this.dummyZ_ = new double[1];
    }

    @Override
    public int getDataDimCount() {
        return 3;
    }

    @Override
    public Rectangle getPlotBounds() {
        return new Rectangle(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
    }

    @Override
    public Insets getPlotInsets(boolean withScroll) {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public Captioner getCaptioner() {
        return this.captioner_;
    }

    @Override
    public boolean dataToGraphics(double[] dataPos, boolean visibleOnly, Point2D.Double gPos) {
        return this.dataToGraphicZ(dataPos, visibleOnly, gPos, this.dummyZ_);
    }

    @Override
    public boolean dataToGraphicsOffset(double[] dataPos0, Point2D.Double gPos0, double[] dataPos1, boolean visibleOnly, Point2D.Double gpos1) {
        return this.dataToGraphics(dataPos1, visibleOnly, gpos1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dataToGraphicZ(double[] dataPos, boolean visibleOnly, Point2D.Double gPos, double[] zloc) {
        boolean knownInCube;
        if (visibleOnly) {
            if (!this.inRange(dataPos)) return false;
            knownInCube = true;
        } else {
            knownInCube = false;
        }
        double sx = this.normalise(dataPos, 0);
        double sy = this.normalise(dataPos, 1);
        double sz = this.normalise(dataPos, 2);
        assert (!knownInCube || this.isNormal(sx) && this.isNormal(sy) && this.isNormal(sz)) : "(" + sx + ", " + sy + ", " + sz + ")";
        double[] rot = this.rotmat_;
        double rx = rot[0] * sx + rot[1] * sy + rot[2] * sz;
        double ry = rot[3] * sx + rot[4] * sy + rot[5] * sz;
        double rz = rot[6] * sx + rot[7] * sy + rot[8] * sz;
        double gx = (double)this.gXoff_ + rx * this.gZoom_;
        double gy = (double)this.gYoff_ - rz * this.gZoom_;
        if (visibleOnly && (!(gx >= (double)this.gxlo_) || !(gx < (double)this.gxhi_) || !(gy >= (double)this.gylo_) || !(gy < (double)this.gyhi_))) return false;
        gPos.x = gx;
        gPos.y = gy;
        zloc[0] = ry;
        return true;
    }

    public boolean inRange(double[] dataPos) {
        for (int i = 0; i < 3; ++i) {
            double d = dataPos[i];
            if (this.dlos_[i] <= d && d <= this.dhis_[i]) continue;
            return false;
        }
        return true;
    }

    private double normalise(double[] dataPos, int idim) {
        return this.dScales_[idim] * (this.dOffs_[idim] + (this.logFlags_[idim] ? Math.log(dataPos[idim]) : dataPos[idim]));
    }

    private double unNormalise(double[] normPos, int idim) {
        double x = normPos[idim] / this.dScales_[idim] - this.dOffs_[idim];
        return this.logFlags_[idim] ? Math.exp(x) : x;
    }

    private boolean isNormal(double d) {
        return d >= -1.0001 && d <= 1.0001;
    }

    public Point2D.Double projectNormalisedPos(double[] nPos) {
        double[] r = Matrices.mvMult(this.rotmat_, nPos);
        return new Point2D.Double((double)this.gXoff_ + r[0] * this.gZoom_, (double)this.gYoff_ - r[2] * this.gZoom_);
    }

    @Override
    public String formatPosition(double[] dataPos) {
        return null;
    }

    @Override
    public double[] graphicsToData(Point2D gpos0, Iterable<double[]> dposIt) {
        int idim;
        if (dposIt == null) {
            return null;
        }
        int[] thresh1s = new int[]{2, 4, 8, 16};
        Arrays.sort(thresh1s);
        int nth = thresh1s.length;
        double[] thresh2s = new double[nth];
        double[][] dposTots = new double[nth][3];
        long[] counts = new long[nth];
        double[] dp0 = new double[3];
        for (int ith = 0; ith < nth; ++ith) {
            thresh2s[ith] = thresh1s[ith] * thresh1s[ith];
        }
        double maxThresh2 = thresh2s[nth - 1];
        Point2D.Double gp = new Point2D.Double();
        for (double[] dpos : dposIt) {
            double d2;
            if (!this.dataToGraphics(dpos, true, gp) || !((d2 = gpos0.distanceSq(gp)) <= maxThresh2)) continue;
            for (idim = 0; idim < 3; ++idim) {
                double d = dpos[idim];
                dp0[idim] = this.logFlags_[idim] ? Math.log(d) : d;
            }
            for (int ith = 0; ith < nth; ++ith) {
                if (!(d2 <= thresh2s[ith])) continue;
                for (int idim2 = 0; idim2 < 3; ++idim2) {
                    double[] dArray = dposTots[ith];
                    int n = idim2;
                    dArray[n] = dArray[n] + dp0[idim2];
                }
                int n = ith;
                counts[n] = counts[n] + 1L;
            }
        }
        for (int ith = 0; ith < nth; ++ith) {
            if (counts[ith] <= 0L) continue;
            double c1 = 1.0 / (double)counts[ith];
            double[] dposMean = new double[3];
            for (idim = 0; idim < 3; ++idim) {
                double d = c1 * dposTots[ith][idim];
                dposMean[idim] = this.logFlags_[idim] ? Math.exp(d) : d;
            }
            return dposMean;
        }
        return null;
    }

    @Override
    public void paintBackground(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Color color0 = g2.getColor();
        g2.setColor(Color.WHITE);
        g2.fillRect(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
        g2.setColor(color0);
        if (this.frame_) {
            Shape clip0 = g2.getClip();
            g2.clipRect(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
            Object aa0 = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialias_ ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            this.plotFrame(g2, false);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa0);
            g2.setClip(clip0);
        }
    }

    @Override
    public void paintForeground(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.frame_) {
            Shape clip0 = g2.getClip();
            g2.clipRect(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
            Object aa0 = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialias_ ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            this.plotFrame(g2, true);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa0);
            g2.setClip(clip0);
        }
    }

    ConfigMap getAspectConfig(boolean isIso) {
        int npix = Math.max(this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
        ConfigMap config = new ConfigMap();
        double xlo = this.dlos_[0];
        double ylo = this.dlos_[1];
        double zlo = this.dlos_[2];
        double xhi = this.dhis_[0];
        double yhi = this.dhis_[1];
        double zhi = this.dhis_[2];
        if (isIso) {
            double xr = xhi - xlo;
            double yr = yhi - ylo;
            double zr = zhi - zlo;
            config.put(CubeSurfaceFactory.XC_KEY, PlotUtil.roundNumber(0.5 * (xlo + xhi), xr / (double)npix));
            config.put(CubeSurfaceFactory.YC_KEY, PlotUtil.roundNumber(0.5 * (ylo + yhi), yr / (double)npix));
            config.put(CubeSurfaceFactory.ZC_KEY, PlotUtil.roundNumber(0.5 * (zlo + zhi), zr / (double)npix));
            config.put(CubeSurfaceFactory.SCALE_KEY, (xr + yr + zr) / 3.0);
        } else {
            config.putAll(PlotUtil.configLimits(CubeSurfaceFactory.XMIN_KEY, CubeSurfaceFactory.XMAX_KEY, xlo, xhi, npix));
            config.putAll(PlotUtil.configLimits(CubeSurfaceFactory.YMIN_KEY, CubeSurfaceFactory.YMAX_KEY, ylo, yhi, npix));
            config.putAll(PlotUtil.configLimits(CubeSurfaceFactory.ZMIN_KEY, CubeSurfaceFactory.ZMAX_KEY, zlo, zhi, npix));
        }
        config.put(CubeSurfaceFactory.ZOOM_KEY, new Double(this.zoom_));
        config.put(CubeSurfaceFactory.XOFF_KEY, new Double(this.xoff_));
        config.put(CubeSurfaceFactory.YOFF_KEY, new Double(this.yoff_));
        double[] eulers = CubeSurfaceFactory.rotationToEulerDegrees(this.rotmat_);
        double degEpsilon = 0.01;
        config.put(CubeSurfaceFactory.PHI_KEY, PlotUtil.roundNumber(eulers[0], degEpsilon));
        config.put(CubeSurfaceFactory.THETA_KEY, PlotUtil.roundNumber(eulers[1], degEpsilon));
        config.put(CubeSurfaceFactory.PSI_KEY, PlotUtil.roundNumber(eulers[2], degEpsilon));
        return config;
    }

    CubeAspect pan(Point2D pos0, Point2D pos1) {
        double xf = (pos0.getX() - pos1.getX()) / this.gScale_ / this.zoom_;
        double yf = (pos0.getY() - pos1.getY()) / this.gScale_ / this.zoom_;
        double phi = xf * Math.PI / 2.0;
        double psi = yf * Math.PI / 2.0;
        double[] rot = CubeSurface.rotateXZ(this.rotmat_, phi, psi);
        return this.adjustAspect(rot, this.zoom_, this.xoff_, this.yoff_);
    }

    CubeAspect centerZoom(double factor, boolean[] useFlags) {
        double[] midPos = new double[3];
        for (int i = 0; i < 3; ++i) {
            midPos[i] = this.logFlags_[i] ? Math.sqrt(this.dlos_[i] * this.dhis_[i]) : (this.dlos_[i] + this.dhis_[i]) / 2.0;
        }
        return this.zoomData(midPos, useFlags[0] ? factor : 1.0, useFlags[1] ? factor : 1.0, useFlags[2] ? factor : 1.0);
    }

    CubeAspect pointZoom(Point2D gpos, double xZoom, double yZoom) {
        int[] dirs = this.getScreenDirections();
        double[] factors = new double[]{1.0, 1.0, 1.0};
        factors[dirs[0]] = xZoom;
        factors[dirs[1]] = yZoom;
        return this.zoomData(this.graphicsToData(gpos), factors[0], factors[1], factors[2]);
    }

    CubeAspect pointPan(Point2D gpos0, Point gpos1) {
        double[] dp0 = this.graphicsToData(gpos0);
        double[] dp1 = this.graphicsToData(gpos1);
        double[][] limits = new double[3][];
        for (int i = 0; i < 3; ++i) {
            limits[i] = Axis.pan(this.dlos_[i], this.dhis_[i], dp0[i], dp1[i], this.logFlags_[i]);
        }
        return new CubeAspect(limits[0], limits[1], limits[2], this.rotmat_, this.zoom_, this.xoff_, this.yoff_);
    }

    public int[] getScreenDirections() {
        double[] screenXs = new double[3];
        double[] screenYs = new double[3];
        double[] screenNs = new double[3];
        for (int i = 0; i < 3; ++i) {
            double[] r = Matrices.mvMult(this.rotmat_, Matrices.unit(i));
            screenXs[i] = r[0];
            screenYs[i] = r[2];
            screenNs[i] = r[1];
        }
        double maxX = 0.0;
        int imaxX = -1;
        for (int i = 0; i < 3; ++i) {
            if (!(Math.abs(screenXs[i]) > Math.abs(maxX))) continue;
            maxX = screenXs[i];
            imaxX = i;
        }
        int iaxX = imaxX;
        double maxY = 0.0;
        int imaxY = -1;
        for (int i = 0; i < 3; ++i) {
            if (!(Math.abs(screenYs[i]) > Math.abs(maxY)) || i == iaxX) continue;
            maxY = screenYs[i];
            imaxY = i;
        }
        int iaxY = imaxY;
        double maxN = 0.0;
        int imaxN = -1;
        for (int i = 0; i < 3; ++i) {
            if (i == iaxX || i == iaxY) continue;
            maxN = screenNs[i];
            imaxN = i;
        }
        int iaxN = imaxN;
        return new int[]{iaxX, iaxY, iaxN};
    }

    private double[] graphicsToData(Point2D gpos) {
        int[] dirs = this.getScreenDirections();
        int iscreenX = dirs[0];
        int iscreenY = dirs[1];
        int iscreenN = dirs[2];
        double[] normOrigin = new double[3];
        double[] normX1 = (double[])normOrigin.clone();
        double[] normY1 = (double[])normOrigin.clone();
        normX1[iscreenX] = 1.0;
        normY1[iscreenY] = 1.0;
        Point2D.Double g0 = this.projectNormalisedPos(normOrigin);
        Point2D.Double gX = this.projectNormalisedPos(normX1);
        Point2D.Double gY = this.projectNormalisedPos(normY1);
        double[] normPos = new double[3];
        normPos[iscreenN] = 0.0;
        normPos[iscreenX] = this.projectGraphicsToNormalised(g0, gX, gpos);
        normPos[iscreenY] = this.projectGraphicsToNormalised(g0, gY, gpos);
        return new double[]{this.unNormalise(normPos, 0), this.unNormalise(normPos, 1), this.unNormalise(normPos, 2)};
    }

    private double projectGraphicsToNormalised(Point2D origin, Point2D unit, Point2D point) {
        double dux = unit.getX() - origin.getX();
        double duy = unit.getY() - origin.getY();
        double dpx = point.getX() - origin.getX();
        double dpy = point.getY() - origin.getY();
        return (dpx * dux + dpy * duy) / (dux * dux + duy * duy);
    }

    CubeAspect center(double[] dpos) {
        double[][] limits = new double[3][];
        for (int i = 0; i < 3; ++i) {
            double max;
            double min;
            double offset;
            double dmid;
            double dp = dpos[i];
            double dlo = this.dlos_[i];
            double dhi = this.dhis_[i];
            if (this.logFlags_[i]) {
                dmid = Math.sqrt(dlo * dhi);
                offset = dp / dmid;
                min = dlo * offset;
                max = dhi * offset;
            } else {
                dmid = 0.5 * (dlo + dhi);
                offset = dp - dmid;
                min = dlo + offset;
                max = dhi + offset;
            }
            limits[i] = new double[]{min, max};
        }
        return new CubeAspect(limits[0], limits[1], limits[2], this.rotmat_, this.zoom_, this.xoff_, this.yoff_);
    }

    private CubeAspect zoomData(double[] dpos0, double xFactor, double yFactor, double zFactor) {
        double[] factors = new double[]{xFactor, yFactor, zFactor};
        double[][] limits = new double[3][];
        for (int i = 0; i < 3; ++i) {
            limits[i] = Axis.zoom(this.dlos_[i], this.dhis_[i], dpos0[i], factors[i], this.logFlags_[i]);
        }
        return new CubeAspect(limits[0], limits[1], limits[2], this.rotmat_, this.zoom_, this.xoff_, this.yoff_);
    }

    public boolean equals(Object o) {
        if (o instanceof CubeSurface) {
            CubeSurface other = (CubeSurface)o;
            return this.gxlo_ == other.gxlo_ && this.gxhi_ == other.gxhi_ && this.gylo_ == other.gylo_ && this.gyhi_ == other.gyhi_ && Arrays.equals(this.dlos_, other.dlos_) && Arrays.equals(this.dhis_, other.dhis_) && Arrays.equals(this.logFlags_, other.logFlags_) && Arrays.equals(this.flipFlags_, other.flipFlags_) && this.zoom_ == other.zoom_ && this.xoff_ == other.xoff_ && this.yoff_ == other.yoff_ && Arrays.equals(this.rotmat_, other.rotmat_) && Arrays.deepEquals((Object[])this.ticks_, (Object[])other.ticks_) && Arrays.equals(this.labels_, other.labels_) && this.captioner_.equals(other.captioner_) && this.frame_ == other.frame_ && this.antialias_ == other.antialias_;
        }
        return false;
    }

    public int hashCode() {
        int code = 7701;
        code = 23 * code + this.gxlo_;
        code = 23 * code + this.gxhi_;
        code = 23 * code + this.gylo_;
        code = 23 * code + this.gyhi_;
        code = 23 * code + Arrays.hashCode(this.dlos_);
        code = 23 * code + Arrays.hashCode(this.dhis_);
        code = 23 * code + Arrays.hashCode(this.logFlags_);
        code = 23 * code + Arrays.hashCode(this.flipFlags_);
        code = 23 * code + Float.floatToIntBits((float)this.zoom_);
        code = 23 * code + Float.floatToIntBits((float)this.xoff_);
        code = 23 * code + Float.floatToIntBits((float)this.yoff_);
        code = 23 * code + Arrays.hashCode(this.rotmat_);
        code = 23 * code + Arrays.deepHashCode((Object[])this.ticks_);
        code = 23 * code + Arrays.hashCode(this.labels_);
        code = 23 * code + this.captioner_.hashCode();
        code = 23 * code + (this.frame_ ? 1 : 3);
        code = 23 * code + (this.antialias_ ? 5 : 7);
        return code;
    }

    private CubeAspect adjustAspect(double[] rotmat, double zoom, double xoff, double yoff) {
        return new CubeAspect(new double[]{this.dlos_[0], this.dhis_[0]}, new double[]{this.dlos_[1], this.dhis_[1]}, new double[]{this.dlos_[2], this.dhis_[2]}, rotmat, zoom, xoff, yoff);
    }

    private void plotFrame(Graphics g, boolean front) {
        Point2D.Double gp0 = new Point2D.Double();
        Point2D.Double gp1 = new Point2D.Double();
        double[] gz0 = new double[1];
        double[] gz1 = new double[1];
        Corner backCorner = null;
        double zmax = 0.0;
        for (int ic = 0; ic < 8; ++ic) {
            Corner corner = Corner.getCorner(ic);
            double[] dpos0 = this.getCornerDataPos(corner);
            this.dataToGraphicZ(dpos0, false, gp0, gz0);
            if (!(gz0[0] > zmax)) continue;
            zmax = gz0[0];
            backCorner = corner;
        }
        Graphics2D g2 = (Graphics2D)g;
        Stroke stroke0 = g2.getStroke();
        Color color0 = g2.getColor();
        float sWidth = stroke0 instanceof BasicStroke ? ((BasicStroke)stroke0).getLineWidth() : 1.0f;
        g2.setStroke(new BasicStroke(sWidth, 1, 1));
        g.setColor(front ? Color.BLACK : Color.LIGHT_GRAY);
        for (int i0 = 0; i0 < 8; ++i0) {
            Corner c0 = Corner.getCorner(i0);
            double[] dpos0 = this.getCornerDataPos(c0);
            this.dataToGraphicZ(dpos0, false, gp0, gz0);
            Corner[] friends = c0.getAdjacent();
            for (int i1 = 0; i1 < friends.length; ++i1) {
                boolean isHidden;
                Corner c1 = friends[i1];
                if (c1.compareTo(c0) <= 0) continue;
                double[] dpos1 = this.getCornerDataPos(c1);
                boolean bl = isHidden = c0 == backCorner || c1 == backCorner;
                if (!(isHidden ^ front)) continue;
                assert (c1 != Corner.ORIGIN);
                if (c0 == Corner.ORIGIN) {
                    this.drawFrameAxis(g2, dpos0, dpos1);
                    continue;
                }
                this.drawFrameLine(g2, dpos0, dpos1);
            }
        }
        g2.setColor(color0);
        g2.setStroke(stroke0);
    }

    private double[] getCornerDataPos(Corner corner) {
        boolean[] cflags = corner.getFlags();
        double[] dpos = new double[3];
        for (int i = 0; i < 3; ++i) {
            dpos[i] = cflags[i] ^ this.flipFlags_[i] ? this.dhis_[i] : this.dlos_[i];
        }
        return dpos;
    }

    private void drawFrameAxis(Graphics g, double[] dpos0, double[] dpos1) {
        int iaxis = -1;
        for (int i = 0; i < 3; ++i) {
            if (dpos0[i] == dpos1[i]) continue;
            assert (iaxis == -1);
            iaxis = i;
        }
        assert (iaxis >= 0 && iaxis < 3);
        double[] up = Matrices.normalise(Matrices.cross(this.getDepthVector(), Matrices.unit(iaxis)));
        boolean forward = true;
        int sx = (int)this.gScale_;
        int sy = g.getFontMetrics().getHeight();
        Point2D.Double sp00 = new Point2D.Double(0.0, 0.0);
        Point2D.Double sp10 = new Point2D.Double(sx, 0.0);
        Point2D.Double sp01 = new Point2D.Double(0.0, sy);
        AffineTransform atf = null;
        int itry = 0;
        while (atf == null) {
            boolean stopFiddling = itry > 5;
            double[] n00 = new double[3];
            double[] n10 = new double[3];
            double[] n01 = new double[3];
            for (int i = 0; i < 3; ++i) {
                n00[i] = this.normalise(forward ? dpos0 : dpos1, i);
                n10[i] = this.normalise(forward ? dpos1 : dpos0, i);
            }
            double uscale = (n10[iaxis] - n00[iaxis]) * (double)sy / (double)sx;
            for (int i = 0; i < 3; ++i) {
                n01[i] = n00[i] + uscale * up[i];
            }
            Point2D.Double tp00 = this.projectNormalisedPos(n00);
            Point2D.Double tp10 = this.projectNormalisedPos(n10);
            Point2D.Double tp01 = this.projectNormalisedPos(n01);
            if (tp01.y < tp00.y && !stopFiddling) {
                up = Matrices.mult(up, -1.0);
            } else {
                double[] sm = new double[]{sp00.x, sp10.x, sp01.x, sp00.y, sp10.y, sp01.y, 1.0, 1.0, 1.0};
                double[] tm = new double[]{tp00.x, tp10.x, tp01.x, tp00.y, tp10.y, tp01.y, 1.0, 1.0, 1.0};
                double[] m = Matrices.mmMult(tm, Matrices.invert(sm));
                double m00 = m[0];
                double m01 = m[1];
                double m02 = m[2];
                double m10 = m[3];
                double m11 = m[4];
                double m12 = m[5];
                assert (PlotUtil.approxEquals(m[6], 0.0)) : m[6];
                assert (PlotUtil.approxEquals(m[7], 0.0)) : m[7];
                assert (PlotUtil.approxEquals(m[8], 1.0)) : m[8];
                if (m00 * m11 - m01 * m10 < 0.0 && !stopFiddling) {
                    forward = !forward;
                } else {
                    atf = new AffineTransform(m00, m10, m01, m11, m02, m12);
                }
            }
            ++itry;
        }
        double det = atf.getDeterminant();
        if (det == 0.0 || Double.isNaN(det)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform atf0 = g2.getTransform();
        g2.transform(atf);
        g2.drawLine(0, 0, sx, 0);
        Axis ax = Axis.createAxis(0, sx, this.dlos_[iaxis], this.dhis_[iaxis], this.logFlags_[iaxis], !forward ^ this.flipFlags_[iaxis]);
        ax.drawLabels(this.ticks_[iaxis], this.labels_[iaxis], this.captioner_, ORIENTATION, false, g2);
        g2.setTransform(atf0);
    }

    private void drawFrameLine(Graphics g, double[] dpos0, double[] dpos1) {
        Point2D.Double gp0 = new Point2D.Double();
        Point2D.Double gp1 = new Point2D.Double();
        double[] dz0 = new double[1];
        double[] dz1 = new double[1];
        this.dataToGraphicZ(dpos0, false, gp0, dz0);
        this.dataToGraphicZ(dpos1, false, gp1, dz1);
        g.drawLine(PlotUtil.ifloor(gp0.x), PlotUtil.ifloor(gp0.y), PlotUtil.ifloor(gp1.x), PlotUtil.ifloor(gp1.y));
    }

    private double[] getDepthVector() {
        return Matrices.mvMult(Matrices.invert(this.rotmat_), new double[]{0.0, 1.0, 0.0});
    }

    public static CubeSurface createSurface(Rectangle plotBounds, CubeAspect aspect, boolean[] logFlags, boolean[] flipFlags, String[] labels, double[] crowdFactors, Captioner captioner, boolean frame, boolean minor, boolean antialias) {
        int gxlo = plotBounds.x;
        int gxhi = plotBounds.x + plotBounds.width;
        int gylo = plotBounds.y;
        int gyhi = plotBounds.y + plotBounds.height;
        double[] dlos = new double[3];
        double[] dhis = new double[3];
        double[][] limits = aspect.getLimits();
        Tick[][] ticks = new Tick[3][];
        int npix = CubeSurface.getPixelScale(plotBounds.width, plotBounds.height);
        for (int i = 0; i < 3; ++i) {
            dlos[i] = limits[i][0];
            dhis[i] = limits[i][1];
            ticks[i] = (logFlags[i] ? BasicTicker.LOG : BasicTicker.LINEAR).getTicks(dlos[i], dhis[i], minor, captioner, ORIENTATION, npix, crowdFactors[i]);
        }
        double[] rotmat = aspect.getRotation();
        double zoom = aspect.getZoom();
        double xoff = aspect.getOffsetX();
        double yoff = aspect.getOffsetY();
        return new CubeSurface(gxlo, gxhi, gylo, gyhi, dlos, dhis, logFlags, flipFlags, rotmat, zoom, xoff, yoff, ticks, labels, captioner, frame, antialias);
    }

    private static int getPixelScale(int xpix, int ypix) {
        return (int)((double)Math.min(xpix, ypix) / Math.sqrt(3.0));
    }

    private static double[] rotateXZ(double[] base, double phi, double psi) {
        double[] rotA = Plot3D.rotate(base, new double[]{0.0, 0.0, 1.0}, phi);
        double[] rotB = Plot3D.rotate(base, new double[]{1.0, 0.0, 0.0}, psi);
        return Matrices.mmMult(Matrices.mmMult(base, rotB), rotA);
    }
}

