/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Corner;
import uk.ac.starlink.ttools.plot2.Decoration;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.geom.NavDecorations;

public class NavDecorations3D {
    private NavDecorations3D() {
    }

    public static Decoration createCenterDragDecoration(CubeSurface csurf, double zoomFactor, boolean[] useFlags) {
        double[] factors = new double[3];
        for (int i = 0; i < 3; ++i) {
            factors[i] = useFlags[i] ? zoomFactor : 1.0;
        }
        return NavDecorations.center(new DragIcon3D(csurf, factors), NavDecorations3D.projectNorm(csurf, new double[3]));
    }

    public static Decoration createCenterWheelDecoration(CubeSurface csurf, double zoomFactor, boolean[] useFlags) {
        return NavDecorations.center(new WheelIcon3D(csurf, zoomFactor, useFlags), NavDecorations3D.projectNorm(csurf, new double[3]));
    }

    public static Decoration create2dZoomDecoration(CubeSurface csurf, Point pos, double xf, double yf) {
        return NavDecorations.center(new DragIcon2D(csurf, xf, yf), pos);
    }

    public static Decoration create2dPanDecoration(CubeSurface csurf, Point pos) {
        return NavDecorations.center(new GrabIcon2D(csurf), pos);
    }

    public static Decoration createRecenterDecoration(CubeSurface csurf, Point pos) {
        RecenterIcon icon = new RecenterIcon(csurf, pos);
        return new Decoration(icon, icon.xoff_, icon.yoff_);
    }

    private static Graphics2D prepareGraphics(Graphics g) {
        return NavDecorations.prepareGraphics(g);
    }

    private static void markPoint(Graphics g, int x, int y) {
        int r = 3;
        g.drawOval(x - 3, y - 3, 6, 6);
    }

    private static Point projectNorm(CubeSurface csurf, double[] normPos) {
        Point2D.Double p = csurf.projectNormalisedPos(normPos);
        return new Point((int)Math.round(p.getX()), (int)Math.round(p.getY()));
    }

    @Equality
    private static class Parallelepiped {
        final Point[] xyz_;

        Parallelepiped(Point[] xyz) {
            this.xyz_ = xyz;
        }

        public int hashCode() {
            return Arrays.hashCode(this.xyz_);
        }

        public boolean equals(Object o) {
            return o instanceof Parallelepiped && Arrays.equals(this.xyz_, ((Parallelepiped)o).xyz_);
        }
    }

    @Equality
    private static class Parallelogram {
        final Point xv_;
        final Point yv_;

        Parallelogram(Point xv, Point yv) {
            this.xv_ = xv;
            this.yv_ = yv;
        }

        public int hashCode() {
            int code = 567;
            code = 23 * code + this.xv_.hashCode();
            code = 23 * code + this.yv_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof Parallelogram) {
                Parallelogram other = (Parallelogram)o;
                return this.xv_.equals(other.xv_) && this.yv_.equals(other.yv_);
            }
            return false;
        }
    }

    @Equality
    private static class Line {
        final Point p0_;
        final Point p1_;

        Line(Point p0, Point p1) {
            this.p0_ = p0;
            this.p1_ = p1;
        }

        public String toString() {
            return this.p0_ + " -> " + this.p1_;
        }

        public int hashCode() {
            int code = 234;
            code = 23 * code + this.p0_.hashCode();
            code = 23 * code + this.p1_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof Line) {
                Line other = (Line)o;
                return this.p0_.equals(other.p0_) && this.p1_.equals(other.p1_);
            }
            return false;
        }
    }

    @Equality
    private static class DragIcon3D
    implements Icon {
        private final Parallelepiped pped0_;
        private final Parallelepiped pped1_;

        public DragIcon3D(CubeSurface csurf, double[] factors) {
            double baseNormSize = 0.2;
            Point c = NavDecorations3D.projectNorm(csurf, new double[3]);
            Point[] xyz0 = new Point[3];
            Point[] xyz1 = new Point[3];
            for (int i = 0; i < 3; ++i) {
                double[] pn0 = new double[3];
                double[] pn1 = new double[3];
                pn0[i] = baseNormSize;
                pn1[i] = baseNormSize * factors[i];
                Point p0 = NavDecorations3D.projectNorm(csurf, pn0);
                Point p1 = NavDecorations3D.projectNorm(csurf, pn1);
                xyz0[i] = new Point(p0.x - c.x, p0.y - c.y);
                xyz1[i] = new Point(p1.x - c.x, p1.y - c.y);
            }
            this.pped0_ = new Parallelepiped(xyz0);
            this.pped1_ = new Parallelepiped(xyz1);
        }

        @Override
        public int getIconWidth() {
            int w = 0;
            for (int ic = 0; ic < 8; ++ic) {
                Corner corner = Corner.getCorner(ic);
                w = Math.max(w, Math.abs(DragIcon3D.getVertex((Parallelepiped)this.pped0_, (Corner)corner).x));
                w = Math.max(w, Math.abs(DragIcon3D.getVertex((Parallelepiped)this.pped1_, (Corner)corner).x));
            }
            return 2 * w;
        }

        @Override
        public int getIconHeight() {
            int h = 0;
            for (int ic = 0; ic < 8; ++ic) {
                Corner corner = Corner.getCorner(ic);
                h = Math.max(h, Math.abs(DragIcon3D.getVertex((Parallelepiped)this.pped0_, (Corner)corner).y));
                h = Math.max(h, Math.abs(DragIcon3D.getVertex((Parallelepiped)this.pped1_, (Corner)corner).y));
            }
            return 2 * h;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g = NavDecorations3D.prepareGraphics(g);
            int x0 = x + this.getIconWidth() / 2;
            int y0 = y + this.getIconHeight() / 2;
            g.translate(x0, y0);
            NavDecorations3D.markPoint(g, 0, 0);
            DragIcon3D.drawParallelepiped(g, this.pped0_);
            DragIcon3D.drawParallelepiped(g, this.pped1_);
            g.translate(-x0, -y0);
            g.dispose();
        }

        public int hashCode() {
            int code = 245;
            code = 23 * code + this.pped0_.hashCode();
            code = 23 * code + this.pped1_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof DragIcon3D) {
                DragIcon3D other = (DragIcon3D)o;
                return this.pped0_.equals(other.pped0_) && this.pped1_.equals(other.pped1_);
            }
            return false;
        }

        private static void drawParallelepiped(Graphics g, Parallelepiped pped) {
            for (int ic = 0; ic < 8; ++ic) {
                Corner c0 = Corner.getCorner(ic);
                Corner[] others = c0.getAdjacent();
                for (int jc = 0; jc < others.length; ++jc) {
                    Corner c1 = others[jc];
                    if (c1.compareTo(c0) <= 0) continue;
                    Point p0 = DragIcon3D.getVertex(pped, c0);
                    Point p1 = DragIcon3D.getVertex(pped, c1);
                    g.drawLine(p0.x, p0.y, p1.x, p1.y);
                }
            }
        }

        private static Point getVertex(Parallelepiped pped, Corner corner) {
            boolean[] flags = corner.getFlags();
            int dx = 0;
            int dy = 0;
            for (int i = 0; i < 3; ++i) {
                int f = flags[i] ? 1 : -1;
                Point p = pped.xyz_[i];
                dx += f * p.x;
                dy += f * p.y;
            }
            return new Point(dx, dy);
        }
    }

    @Equality
    private static class DragIcon2D
    implements Icon {
        private final Parallelogram pgram0_;
        private final Parallelogram pgram1_;

        public DragIcon2D(CubeSurface csurf, double xf, double yf) {
            double baseNormSize = 0.2;
            Point c = NavDecorations3D.projectNorm(csurf, new double[3]);
            int[] dirs = csurf.getScreenDirections();
            int jd0 = dirs[0];
            int jd1 = dirs[1];
            double[] xv = new double[3];
            xv[jd0] = baseNormSize;
            Point x0 = NavDecorations3D.projectNorm(csurf, xv);
            int n = jd0;
            xv[n] = xv[n] * xf;
            Point x1 = NavDecorations3D.projectNorm(csurf, xv);
            double[] yv = new double[3];
            yv[jd1] = baseNormSize;
            Point y0 = NavDecorations3D.projectNorm(csurf, yv);
            int n2 = jd1;
            yv[n2] = yv[n2] * yf;
            Point y1 = NavDecorations3D.projectNorm(csurf, yv);
            this.pgram0_ = new Parallelogram(new Point(x0.x - c.x, x0.y - c.y), new Point(y0.x - c.x, y0.y - c.y));
            this.pgram1_ = new Parallelogram(new Point(x1.x - c.x, x1.y - c.y), new Point(y1.x - c.x, y1.y - c.y));
        }

        @Override
        public int getIconWidth() {
            return 2 * Math.max(this.pgram0_.xv_.x + this.pgram0_.yv_.x, this.pgram1_.xv_.x + this.pgram1_.yv_.x);
        }

        @Override
        public int getIconHeight() {
            return 2 * Math.max(this.pgram0_.xv_.y + this.pgram0_.yv_.y, this.pgram1_.xv_.y + this.pgram1_.yv_.y);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g = NavDecorations3D.prepareGraphics(g);
            int x0 = x + this.getIconWidth() / 2;
            int y0 = y + this.getIconHeight() / 2;
            g.translate(x0, y0);
            DragIcon2D.drawCross(g, this.pgram0_, 0.25);
            DragIcon2D.drawParallelogram(g, this.pgram0_);
            DragIcon2D.drawParallelogram(g, this.pgram1_);
            g.translate(-x0, -y0);
            g.dispose();
        }

        public int hashCode() {
            int code = 324;
            code = 23 * code + this.pgram0_.hashCode();
            code = 23 * code + this.pgram1_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof DragIcon2D) {
                DragIcon2D other = (DragIcon2D)o;
                return this.pgram0_.equals(other.pgram0_) && this.pgram1_.equals(other.pgram1_);
            }
            return false;
        }

        private static void drawParallelogram(Graphics g, Parallelogram pg) {
            Point xv = pg.xv_;
            Point yv = pg.yv_;
            int[] xs = new int[]{xv.x + yv.x, xv.x - yv.x, -xv.x - yv.x, -xv.x + yv.x};
            int[] ys = new int[]{xv.y + yv.y, xv.y - yv.y, -xv.y - yv.y, -xv.y + yv.y};
            g.drawPolygon(xs, ys, 4);
        }

        private static void drawCross(Graphics g, Parallelogram pg, double frac) {
            int x0 = (int)Math.round((double)pg.xv_.x * frac);
            int y0 = (int)Math.round((double)pg.xv_.y * frac);
            int x1 = (int)Math.round((double)pg.yv_.x * frac);
            int y1 = (int)Math.round((double)pg.yv_.y * frac);
            g.drawLine(-x0, -y0, x0, y0);
            g.drawLine(-x1, -y1, x1, y1);
        }
    }

    @Equality
    private static class WheelIcon3D
    implements Icon {
        private final Point center_;
        private final Line[] lines_;

        public WheelIcon3D(CubeSurface csurf, double zoomFactor, boolean[] useFlags) {
            Point center;
            double baseNormSize = 0.25;
            double lineFactor = Math.pow(zoomFactor, 3.0);
            this.center_ = center = NavDecorations3D.projectNorm(csurf, new double[3]);
            ArrayList<Line> lineList = new ArrayList<Line>();
            for (int i = 0; i < 3; ++i) {
                if (!useFlags[i]) continue;
                double[] npos = new double[3];
                npos[i] = baseNormSize;
                Point p0 = NavDecorations3D.projectNorm(csurf, npos);
                int n = i;
                npos[n] = npos[n] * lineFactor;
                Point p1 = NavDecorations3D.projectNorm(csurf, npos);
                if (p0.equals(p1)) continue;
                p0.x -= center.x;
                p0.y -= center.y;
                p1.x -= center.x;
                p1.y -= center.y;
                lineList.add(new Line(p0, p1));
            }
            this.lines_ = lineList.toArray(new Line[0]);
        }

        @Override
        public int getIconWidth() {
            int w2 = 0;
            for (int i = 0; i < this.lines_.length; ++i) {
                Line line = this.lines_[i];
                w2 = Math.max(w2, Math.abs(line.p0_.x));
                w2 = Math.max(w2, Math.abs(line.p1_.x));
            }
            return 2 * w2;
        }

        @Override
        public int getIconHeight() {
            int h2 = 0;
            for (int i = 0; i < this.lines_.length; ++i) {
                Line line = this.lines_[i];
                h2 = Math.max(h2, Math.abs(line.p0_.y));
                h2 = Math.max(h2, Math.abs(line.p1_.y));
            }
            return 2 * h2;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g = NavDecorations3D.prepareGraphics(g);
            int x0 = x + this.getIconWidth() / 2;
            int y0 = y + this.getIconHeight() / 2;
            NavDecorations3D.markPoint(g, this.center_.x, this.center_.y);
            for (int i = 0; i < this.lines_.length; ++i) {
                Line line = this.lines_[i];
                WheelIcon3D.drawArrow(g, x0 + line.p0_.x, y0 + line.p0_.y, x0 + line.p1_.x, y0 + line.p1_.y);
                WheelIcon3D.drawArrow(g, x0 - line.p0_.x, y0 - line.p0_.y, x0 - line.p1_.x, y0 - line.p1_.y);
            }
            g.dispose();
        }

        public int hashCode() {
            int code = 248482;
            code = 23 * code + this.center_.hashCode();
            code = 23 * code + Arrays.hashCode(this.lines_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof WheelIcon3D) {
                WheelIcon3D other = (WheelIcon3D)o;
                return this.center_.equals(other.center_) && Arrays.equals(this.lines_, other.lines_);
            }
            return false;
        }

        private static void drawArrow(Graphics g, int x0, int y0, int x1, int y1) {
            if (x0 != x1 || y0 != y1) {
                Graphics2D g2 = (Graphics2D)g;
                AffineTransform trans0 = g2.getTransform();
                g2.translate(x0, y0);
                g2.rotate(Math.atan2(y1 - y0, x1 - x0));
                int leng = (int)Math.round(Math.sqrt((x1 - x0) * (x1 - x0) + (y1 - y0) * (y1 - y0)));
                Polygon poly = new Polygon(new int[]{0, 0, leng}, new int[]{-5, 5, 0}, 3);
                g2.drawPolygon(poly);
                g2.drawLine(0, 0, leng, 0);
                g2.setTransform(trans0);
            }
        }
    }

    @Equality
    private static class RecenterIcon
    implements Icon {
        private final Point p0_;
        private final Point p1_;
        private final int xoff_;
        private final int yoff_;

        RecenterIcon(CubeSurface csurf, Point pos) {
            int y1;
            int y0;
            int x1;
            int x0;
            Point center = NavDecorations3D.projectNorm(csurf, new double[3]);
            if (pos.x < center.x) {
                this.xoff_ = pos.x;
                x0 = 0;
                x1 = center.x - pos.x;
            } else {
                this.xoff_ = center.x;
                x0 = pos.x - center.x;
                x1 = 0;
            }
            if (pos.y < center.y) {
                this.yoff_ = pos.y;
                y0 = 0;
                y1 = center.y - pos.y;
            } else {
                this.yoff_ = center.y;
                y0 = pos.y - center.y;
                y1 = 0;
            }
            this.p0_ = new Point(x0, y0);
            this.p1_ = new Point(x1, y1);
        }

        @Override
        public int getIconWidth() {
            return Math.abs(this.p1_.x - this.p0_.x);
        }

        @Override
        public int getIconHeight() {
            return Math.abs(this.p1_.y - this.p0_.y);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g = NavDecorations3D.prepareGraphics(g);
            NavDecorations3D.markPoint(g, x + this.p0_.x, y + this.p0_.y);
            NavDecorations.drawArrow(g, x + this.p0_.x, y + this.p0_.y, x + this.p1_.x, y + this.p1_.y);
            g.dispose();
        }

        public int hashCode() {
            int code = 55821;
            code = 23 * code + this.p0_.hashCode();
            code = 23 * code + this.p1_.hashCode();
            code = 23 * code + this.xoff_;
            code = 23 * code + this.yoff_;
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof RecenterIcon) {
                RecenterIcon other = (RecenterIcon)o;
                return this.p0_.equals(other.p0_) && this.p1_.equals(other.p1_) && this.xoff_ == other.xoff_ && this.yoff_ == other.yoff_;
            }
            return false;
        }
    }

    @Equality
    private static class GrabIcon2D
    implements Icon {
        private final Parallelogram pgram_;

        GrabIcon2D(CubeSurface csurf) {
            Point c = NavDecorations3D.projectNorm(csurf, new double[3]);
            int[] dirs = csurf.getScreenDirections();
            double baseNormSize = 0.1;
            double[] xv = new double[3];
            xv[dirs[0]] = baseNormSize;
            Point px = NavDecorations3D.projectNorm(csurf, xv);
            double[] yv = new double[3];
            yv[dirs[1]] = baseNormSize;
            Point py = NavDecorations3D.projectNorm(csurf, yv);
            this.pgram_ = new Parallelogram(new Point(px.x - c.x, px.y - c.y), new Point(py.x - c.x, py.y - c.y));
        }

        @Override
        public int getIconWidth() {
            return 2 * (this.pgram_.xv_.x + this.pgram_.yv_.x);
        }

        @Override
        public int getIconHeight() {
            return 2 * (this.pgram_.xv_.y + this.pgram_.yv_.y);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g = NavDecorations3D.prepareGraphics(g);
            int x0 = x + this.getIconWidth() / 2;
            int y0 = y + this.getIconHeight() / 2;
            Point xv = this.pgram_.xv_;
            Point yv = this.pgram_.yv_;
            g.translate(x0, y0);
            g.drawLine(-xv.x, -xv.y, xv.x, xv.y);
            g.drawLine(-yv.x, -yv.y, yv.x, yv.y);
            g.translate(-x0, -y0);
            g.dispose();
        }

        public int hashCode() {
            return this.pgram_.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof GrabIcon2D && this.pgram_.equals(((GrabIcon2D)o).pgram_);
        }
    }
}

