/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.NullCaptioner;
import uk.ac.starlink.ttools.plot2.Orientation;
import uk.ac.starlink.ttools.plot2.Tick;
import uk.ac.starlink.ttools.plot2.geom.AxisAnnotation;

public class PlaneAxisAnnotation
implements AxisAnnotation {
    private final int gxlo_;
    private final int gxhi_;
    private final int gylo_;
    private final int gyhi_;
    private final Axis xaxis_;
    private final Axis yaxis_;
    private final Tick[] xticks_;
    private final Tick[] yticks_;
    private final String xlabel_;
    private final String ylabel_;
    private final Captioner captioner_;
    private final boolean xAnnotate_;
    private final boolean yAnnotate_;
    private final int xoff_;
    private final int yoff_;
    public static final boolean INVERT_Y = true;
    public static final Orientation X_ORIENT = Orientation.X;
    public static final Orientation Y_ORIENT = Orientation.Y;

    public PlaneAxisAnnotation(int gxlo, int gxhi, int gylo, int gyhi, Axis xaxis, Axis yaxis, Tick[] xticks, Tick[] yticks, String xlabel, String ylabel, Captioner captioner, boolean xAnnotate, boolean yAnnotate) {
        this.gxlo_ = gxlo;
        this.gxhi_ = gxhi;
        this.gylo_ = gylo;
        this.gyhi_ = gyhi;
        this.xaxis_ = xaxis;
        this.yaxis_ = yaxis;
        this.xticks_ = xticks;
        this.yticks_ = yticks;
        this.xlabel_ = xlabel;
        this.ylabel_ = ylabel;
        this.captioner_ = captioner;
        this.xAnnotate_ = xAnnotate;
        this.yAnnotate_ = yAnnotate;
        this.xoff_ = gxlo;
        this.yoff_ = gyhi;
    }

    @Override
    public void drawLabels(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform trans0 = g2.getTransform();
        AffineTransform transX = new AffineTransform(trans0);
        transX.concatenate(this.axisTransform(this.xoff_, this.yoff_, false));
        AffineTransform transY = new AffineTransform(trans0);
        transY.concatenate(this.axisTransform(this.xoff_, this.yoff_, true));
        g2.setTransform(transX);
        this.xaxis_.drawLabels(this.xticks_, this.xlabel_, this.xAnnotate_ ? this.captioner_ : NullCaptioner.INSTANCE, X_ORIENT, false, g2);
        g2.setTransform(transY);
        this.yaxis_.drawLabels(this.yticks_, this.ylabel_, this.yAnnotate_ ? this.captioner_ : NullCaptioner.INSTANCE, Y_ORIENT, true, g2);
        g2.setTransform(trans0);
    }

    @Override
    public Insets getPadding(boolean withScroll) {
        Rectangle bounds = new Rectangle(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
        Rectangle labelRect = new Rectangle(bounds);
        Rectangle xrect = this.xaxis_.getLabelBounds(this.xticks_, this.xlabel_, this.xAnnotate_ ? this.captioner_ : NullCaptioner.INSTANCE, X_ORIENT, false);
        labelRect.add(this.axisTransform(this.xoff_, this.yoff_, false).createTransformedShape(xrect).getBounds());
        Rectangle yrect = this.yaxis_.getLabelBounds(this.yticks_, this.ylabel_, this.yAnnotate_ ? this.captioner_ : NullCaptioner.INSTANCE, Y_ORIENT, true);
        labelRect.add(this.axisTransform(this.xoff_, this.yoff_, true).createTransformedShape(yrect).getBounds());
        int top = bounds.y - labelRect.y;
        int left = bounds.x - labelRect.x;
        int bottom = labelRect.y + labelRect.height - bounds.y - bounds.height;
        int right = labelRect.x + labelRect.width - bounds.x - bounds.width;
        Insets insets = new Insets(top, left, bottom, right);
        if (withScroll) {
            Insets scrollInsets = this.getScrollTickPadding();
            insets.top = Math.max(insets.top, scrollInsets.top);
            insets.left = Math.max(insets.left, scrollInsets.left);
            insets.bottom = Math.max(insets.bottom, scrollInsets.bottom);
            insets.right = Math.max(insets.right, scrollInsets.right);
        }
        return insets;
    }

    private Insets getScrollTickPadding() {
        Rectangle tickPad = new Rectangle(0, 0, 0, 0);
        if (this.xAnnotate_) {
            tickPad.add(this.getMaxTickSizeBounds(this.xticks_, false));
        }
        if (this.yAnnotate_) {
            tickPad.add(this.getMaxTickSizeBounds(this.yticks_, true));
        }
        int left = -tickPad.x;
        int right = tickPad.width + tickPad.x;
        int top = -tickPad.y;
        int bottom = tickPad.height + tickPad.y;
        return new Insets(top, left, bottom, right);
    }

    private Rectangle getMaxTickSizeBounds(Tick[] ticks, boolean isY) {
        Orientation orient = isY ? Y_ORIENT : X_ORIENT;
        AffineTransform axisTrans = this.axisTransform(0, 0, isY);
        int cpad = this.captioner_.getPad();
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        for (int it = 0; it < ticks.length; ++it) {
            Tick tick = ticks[it];
            String label = tick.getLabel();
            if (label == null) continue;
            Rectangle b0 = this.captioner_.getCaptionBounds(tick.getLabel());
            AffineTransform trans = new AffineTransform(axisTrans);
            trans.concatenate(orient.captionTransform(b0, cpad));
            bounds.add(trans.createTransformedShape(b0).getBounds());
        }
        return bounds;
    }

    private AffineTransform axisTransform(int x0, int y0, boolean isY) {
        AffineTransform trans = new AffineTransform();
        trans.translate(x0, y0);
        if (isY) {
            trans.rotate(-1.5707963267948966);
        }
        return trans;
    }
}

