/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.Tuple;

public class PlaneDataGeom
implements DataGeom {
    public static final FloatingCoord X_COORD = FloatingCoord.createCoord(new InputMeta("x", "X").setShortDescription("Horizontal coordinate"), true);
    public static final FloatingCoord Y_COORD = FloatingCoord.createCoord(new InputMeta("y", "Y").setShortDescription("Vertical coordinate"), true);
    public static PlaneDataGeom INSTANCE = new PlaneDataGeom();

    private PlaneDataGeom() {
    }

    @Override
    public int getDataDimCount() {
        return 2;
    }

    @Override
    public boolean hasPosition() {
        return true;
    }

    @Override
    public String getVariantName() {
        return "Cartesian";
    }

    @Override
    public Coord[] getPosCoords() {
        return new Coord[]{X_COORD, Y_COORD};
    }

    @Override
    public boolean readDataPos(Tuple tuple, int ic, double[] dpos) {
        double x = X_COORD.readDoubleCoord(tuple, ic++);
        double y = Y_COORD.readDoubleCoord(tuple, ic++);
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return false;
        }
        dpos[0] = x;
        dpos[1] = y;
        return true;
    }
}

