/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Arrays;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.BasicTicker;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.Tick;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.geom.AxisAnnotation;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.geom.PlaneAspect;
import uk.ac.starlink.ttools.plot2.geom.PlaneAxisAnnotation;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurfaceFactory;

public class PlaneSurface
implements Surface,
PlanarSurface {
    private final double dxlo_;
    private final double dxhi_;
    private final double dylo_;
    private final double dyhi_;
    private final boolean xlog_;
    private final boolean ylog_;
    private final boolean xflip_;
    private final boolean yflip_;
    private final int gxlo_;
    private final int gxhi_;
    private final int gylo_;
    private final int gyhi_;
    private final Tick[] xticks_;
    private final Tick[] yticks_;
    private final String xlabel_;
    private final String ylabel_;
    private final Captioner captioner_;
    private final Color gridcolor_;
    private final Color axlabelcolor_;
    private final Axis xAxis_;
    private final Axis yAxis_;

    public PlaneSurface(int gxlo, int gxhi, int gylo, int gyhi, double dxlo, double dxhi, double dylo, double dyhi, boolean xlog, boolean ylog, boolean xflip, boolean yflip, Tick[] xticks, Tick[] yticks, String xlabel, String ylabel, Captioner captioner, Color gridcolor, Color axlabelcolor) {
        this.gxlo_ = gxlo;
        this.gxhi_ = gxhi;
        this.gylo_ = gylo;
        this.gyhi_ = gyhi;
        this.dxlo_ = dxlo;
        this.dxhi_ = dxhi;
        this.dylo_ = dylo;
        this.dyhi_ = dyhi;
        this.xlog_ = xlog;
        this.ylog_ = ylog;
        this.xflip_ = xflip;
        this.yflip_ = yflip;
        this.xticks_ = xticks;
        this.yticks_ = yticks;
        this.xlabel_ = xlabel;
        this.ylabel_ = ylabel;
        this.captioner_ = captioner;
        this.gridcolor_ = gridcolor;
        this.axlabelcolor_ = axlabelcolor;
        this.xAxis_ = Axis.createAxis(this.gxlo_, this.gxhi_, this.dxlo_, this.dxhi_, this.xlog_, this.xflip_);
        this.yAxis_ = Axis.createAxis(this.gylo_, this.gyhi_, this.dylo_, this.dyhi_, this.ylog_, this.yflip_ ^ true);
        assert (this.equals(this));
    }

    @Override
    public Rectangle getPlotBounds() {
        return new Rectangle(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
    }

    @Override
    public Insets getPlotInsets(boolean withScroll) {
        return this.createAxisAnnotation().getPadding(withScroll);
    }

    @Override
    public int getDataDimCount() {
        return 2;
    }

    @Override
    public boolean dataToGraphics(double[] dpos, boolean visibleOnly, Point2D.Double gp) {
        double gx = this.xAxis_.dataToGraphics(dpos[0]);
        double gy = this.yAxis_.dataToGraphics(dpos[1]);
        if (!visibleOnly || gx >= (double)this.gxlo_ && gx < (double)this.gxhi_ && gy >= (double)this.gylo_ && gy < (double)this.gyhi_) {
            gp.x = gx;
            gp.y = gy;
            return true;
        }
        return false;
    }

    @Override
    public boolean dataToGraphicsOffset(double[] dpos0, Point2D.Double gpos0, double[] dpos1, boolean visibleOnly, Point2D.Double gpos1) {
        return this.dataToGraphics(dpos1, visibleOnly, gpos1);
    }

    @Override
    public double[] graphicsToData(Point2D gp, Iterable<double[]> dposIt) {
        return new double[]{this.xAxis_.graphicsToData(gp.getX()), this.yAxis_.graphicsToData(gp.getY())};
    }

    @Override
    public String formatPosition(double[] dpos) {
        return PlaneSurface.formatPosition(this.xAxis_, dpos[0]) + ", " + PlaneSurface.formatPosition(this.yAxis_, dpos[1]);
    }

    @Override
    public Captioner getCaptioner() {
        return this.captioner_;
    }

    @Override
    public void paintBackground(Graphics g) {
        Color color0 = g.getColor();
        g.setColor(Color.WHITE);
        g.fillRect(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
        if (this.gridcolor_ != null) {
            Tick tick;
            int it;
            g.setColor(this.gridcolor_);
            for (it = 0; it < this.xticks_.length; ++it) {
                tick = this.xticks_[it];
                if (tick.getLabel() == null) continue;
                int gx = (int)this.xAxis_.dataToGraphics(tick.getValue());
                g.drawLine(gx, this.gylo_, gx, this.gyhi_);
            }
            for (it = 0; it < this.yticks_.length; ++it) {
                tick = this.yticks_[it];
                if (tick.getLabel() == null) continue;
                int gy = (int)this.yAxis_.dataToGraphics(tick.getValue());
                g.drawLine(this.gxlo_, gy, this.gxhi_, gy);
            }
        }
        g.setColor(color0);
    }

    @Override
    public void paintForeground(Graphics g) {
        if (this.axlabelcolor_ != null) {
            Graphics2D g2 = (Graphics2D)g;
            Color color0 = g2.getColor();
            g2.setColor(this.axlabelcolor_);
            this.createAxisAnnotation().drawLabels(g);
            g2.drawRect(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
            g2.setColor(color0);
        }
    }

    ConfigMap getAspectConfig() {
        ConfigMap config = new ConfigMap();
        config.putAll(PlotUtil.configLimits(PlaneSurfaceFactory.XMIN_KEY, PlaneSurfaceFactory.XMAX_KEY, this.dxlo_, this.dxhi_, this.gxhi_ - this.gxlo_));
        config.putAll(PlotUtil.configLimits(PlaneSurfaceFactory.YMIN_KEY, PlaneSurfaceFactory.YMAX_KEY, this.dylo_, this.dyhi_, this.gyhi_ - this.gylo_));
        return config;
    }

    @Override
    public double[][] getDataLimits() {
        return new double[][]{{this.dxlo_, this.dxhi_}, {this.dylo_, this.dyhi_}};
    }

    @Override
    public boolean[] getLogFlags() {
        return new boolean[]{this.xlog_, this.ylog_};
    }

    @Override
    public boolean[] getFlipFlags() {
        return new boolean[]{this.xflip_, this.yflip_};
    }

    @Override
    public boolean[] getTimeFlags() {
        return new boolean[]{false, false};
    }

    @Override
    public Axis[] getAxes() {
        return new Axis[]{this.xAxis_, this.yAxis_};
    }

    PlaneAspect zoom(Point2D pos, double xZoom, double yZoom) {
        return new PlaneAspect(this.xAxis_.dataZoom(this.xAxis_.graphicsToData(pos.getX()), xZoom), this.yAxis_.dataZoom(this.yAxis_.graphicsToData(pos.getY()), yZoom));
    }

    PlaneAspect pan(Point2D pos0, Point2D pos1, boolean xFlag, boolean yFlag) {
        if (xFlag || yFlag) {
            double[] dArray;
            double[] dArray2;
            if (xFlag) {
                dArray2 = this.xAxis_.dataPan(this.xAxis_.graphicsToData(pos0.getX()), this.xAxis_.graphicsToData(pos1.getX()));
            } else {
                double[] dArray3 = new double[2];
                dArray3[0] = this.dxlo_;
                dArray2 = dArray3;
                dArray3[1] = this.dxhi_;
            }
            if (yFlag) {
                dArray = this.yAxis_.dataPan(this.yAxis_.graphicsToData(pos0.getY()), this.yAxis_.graphicsToData(pos1.getY()));
            } else {
                double[] dArray4 = new double[2];
                dArray4[0] = this.dylo_;
                dArray = dArray4;
                dArray4[1] = this.dyhi_;
            }
            return new PlaneAspect(dArray2, dArray);
        }
        return null;
    }

    PlaneAspect center(double[] dpos, boolean xFlag, boolean yFlag) {
        Point2D.Double gp = new Point2D.Double();
        return this.dataToGraphics(dpos, false, gp) && PlotUtil.isPointFinite(gp) ? this.pan(gp, new Point2D.Double((double)(this.gxlo_ + this.gxhi_) * 0.5, (double)(this.gylo_ + this.gyhi_) * 0.5), xFlag, yFlag) : null;
    }

    PlaneAspect reframe(Rectangle frame) {
        Point gp1 = new Point(frame.x, frame.y);
        Point gp2 = new Point(frame.x + frame.width, frame.y + frame.height);
        double[] dpos1 = this.graphicsToData(gp1, null);
        double[] dpos2 = this.graphicsToData(gp2, null);
        return new PlaneAspect(PlotUtil.orderPair(dpos1[0], dpos2[0]), PlotUtil.orderPair(dpos1[1], dpos2[1]));
    }

    private AxisAnnotation createAxisAnnotation() {
        return new PlaneAxisAnnotation(this.gxlo_, this.gxhi_, this.gylo_, this.gyhi_, this.xAxis_, this.yAxis_, this.xticks_, this.yticks_, this.xlabel_, this.ylabel_, this.captioner_, true, true);
    }

    public boolean equals(Object o) {
        if (o instanceof PlaneSurface) {
            PlaneSurface other = (PlaneSurface)o;
            return this.xlog_ == other.xlog_ && this.ylog_ == other.ylog_ && this.xflip_ == other.xflip_ && this.yflip_ == other.yflip_ && this.dxlo_ == other.dxlo_ && this.dxhi_ == other.dxhi_ && this.dylo_ == other.dylo_ && this.dyhi_ == other.dyhi_ && this.gxlo_ == other.gxlo_ && this.gxhi_ == other.gxhi_ && this.gylo_ == other.gylo_ && this.gyhi_ == other.gyhi_ && Arrays.equals(this.xticks_, other.xticks_) && Arrays.equals(this.yticks_, other.yticks_) && PlotUtil.equals(this.xlabel_, other.xlabel_) && PlotUtil.equals(this.ylabel_, other.ylabel_) && this.captioner_.equals(other.captioner_) && PlotUtil.equals(this.gridcolor_, other.gridcolor_) && PlotUtil.equals(this.axlabelcolor_, other.axlabelcolor_);
        }
        return false;
    }

    public int hashCode() {
        int code = 23023;
        code = 23 * code + (this.xlog_ ? 1 : 0) + (this.ylog_ ? 2 : 0) + (this.xflip_ ? 4 : 0) + (this.yflip_ ? 8 : 0);
        code = 23 * code + Float.floatToIntBits((float)this.dxlo_);
        code = 23 * code + Float.floatToIntBits((float)this.dxhi_);
        code = 23 * code + Float.floatToIntBits((float)this.dylo_);
        code = 23 * code + Float.floatToIntBits((float)this.dyhi_);
        code = 23 * code + this.gxlo_;
        code = 23 * code + this.gxhi_;
        code = 23 * code + this.gylo_;
        code = 23 * code + this.gyhi_;
        code = 23 * code + Arrays.hashCode(this.xticks_);
        code = 23 * code + Arrays.hashCode(this.yticks_);
        code = 23 * code + PlotUtil.hashCode(this.xlabel_);
        code = 23 * code + PlotUtil.hashCode(this.ylabel_);
        code = 23 * code + this.captioner_.hashCode();
        code = 23 * code + PlotUtil.hashCode(this.gridcolor_);
        code = 23 * code + PlotUtil.hashCode(this.axlabelcolor_);
        return code;
    }

    public static PlaneSurface createSurface(Rectangle plotBounds, PlaneAspect aspect, boolean xlog, boolean ylog, boolean xflip, boolean yflip, String xlabel, String ylabel, Captioner captioner, double xyfactor, boolean grid, double xcrowd, double ycrowd, boolean minor, Color gridcolor, Color axlabelcolor) {
        int gxlo = plotBounds.x;
        int gxhi = plotBounds.x + plotBounds.width;
        int gylo = plotBounds.y;
        int gyhi = plotBounds.y + plotBounds.height;
        double dxlo = aspect.getXMin();
        double dxhi = aspect.getXMax();
        double dylo = aspect.getYMin();
        double dyhi = aspect.getYMax();
        BasicTicker xTicker = xlog ? BasicTicker.LOG : BasicTicker.LINEAR;
        BasicTicker yTicker = ylog ? BasicTicker.LOG : BasicTicker.LINEAR;
        Tick[] xticks = xTicker.getTicks(dxlo, dxhi, minor, captioner, PlaneAxisAnnotation.X_ORIENT, plotBounds.width, xcrowd);
        Tick[] yticks = yTicker.getTicks(dylo, dyhi, minor, captioner, PlaneAxisAnnotation.Y_ORIENT, plotBounds.height, ycrowd);
        Color color = gridcolor = grid ? gridcolor : null;
        if (xyfactor > 0.0 && xlog == ylog) {
            double dx;
            double gx;
            double gy = gyhi - gylo;
            boolean log = xlog;
            double dy = log ? Math.log(dyhi / dylo) : dyhi - dylo;
            double fadj = xyfactor * (gy / dy) / ((gx = (double)(gxhi - gxlo)) / (dx = log ? Math.log(dxhi / dxlo) : dxhi - dxlo));
            if (fadj > 1.0) {
                double dyadj = dy * (1.0 * fadj - 1.0);
                if (log) {
                    dylo *= Math.exp(-0.5 * dyadj);
                    dyhi *= Math.exp(0.5 * dyadj);
                } else {
                    dylo += -0.5 * dyadj;
                    dyhi += 0.5 * dyadj;
                }
            } else {
                double dxadj = dx * (1.0 / fadj - 1.0);
                if (log) {
                    dxlo *= Math.exp(-0.5 * dxadj);
                    dxhi *= Math.exp(0.5 * dxadj);
                } else {
                    dxlo += -0.5 * dxadj;
                    dxhi += 0.5 * dxadj;
                }
            }
            dx = log ? Math.log(dxhi / dxlo) : dxhi - dxlo;
            double d = dy = log ? Math.log(dyhi / dylo) : dyhi - dylo;
            assert (Math.abs(xyfactor * (gy / dy) / (gx / dx) - 1.0) < 1.0E-6);
            xticks = xTicker.getTicks(dxlo, dxhi, minor, captioner, PlaneAxisAnnotation.X_ORIENT, plotBounds.width, 1.0);
            yticks = yTicker.getTicks(dylo, dyhi, minor, captioner, PlaneAxisAnnotation.Y_ORIENT, plotBounds.height, 1.0);
        }
        return new PlaneSurface(gxlo, gxhi, gylo, gyhi, dxlo, dxhi, dylo, dyhi, xlog, ylog, xflip, yflip, xticks, yticks, xlabel, ylabel, captioner, gridcolor, axlabelcolor);
    }

    public static String formatPosition(Axis axis, double dpos) {
        double dp2 = axis.graphicsToData(axis.dataToGraphics(dpos) + 2.0);
        return PlotUtil.formatNumber(dpos, Math.abs(dp2 - dpos) / 2.0);
    }
}

