/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.config.BooleanConfigKey;
import uk.ac.starlink.ttools.plot2.config.CombinationConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.DoubleConfigKey;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.config.SubrangeConfigKey;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.geom.PlaneAspect;
import uk.ac.starlink.ttools.plot2.geom.PlaneNavigator;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurface;

public class PlaneSurfaceFactory
implements SurfaceFactory<Profile, PlaneAspect> {
    public static final ConfigKey<Double> XMIN_KEY = PlaneSurfaceFactory.createAxisLimitKey("X", false);
    public static final ConfigKey<Double> XMAX_KEY = PlaneSurfaceFactory.createAxisLimitKey("X", true);
    public static final ConfigKey<Subrange> XSUBRANGE_KEY = PlaneSurfaceFactory.createAxisSubrangeKey("X");
    public static final ConfigKey<Double> YMIN_KEY = PlaneSurfaceFactory.createAxisLimitKey("Y", false);
    public static final ConfigKey<Double> YMAX_KEY = PlaneSurfaceFactory.createAxisLimitKey("Y", true);
    public static final ConfigKey<Subrange> YSUBRANGE_KEY = PlaneSurfaceFactory.createAxisSubrangeKey("Y");
    public static final ConfigKey<Boolean> XLOG_KEY = PlaneSurfaceFactory.createAxisLogKey("X");
    public static final ConfigKey<Boolean> YLOG_KEY = PlaneSurfaceFactory.createAxisLogKey("Y");
    public static final ConfigKey<Boolean> XFLIP_KEY = PlaneSurfaceFactory.createAxisFlipKey("X");
    public static final ConfigKey<Boolean> YFLIP_KEY = PlaneSurfaceFactory.createAxisFlipKey("Y");
    public static final ConfigKey<String> XLABEL_KEY = StyleKeys.createAxisLabelKey("X");
    public static final ConfigKey<String> YLABEL_KEY = StyleKeys.createAxisLabelKey("Y");
    public static final ConfigKey<Double> XYFACTOR_KEY = DoubleConfigKey.createToggleKey(new ConfigMeta("aspect", "Aspect Lock").setShortDescription("X/Y axis unit ratio").setXmlDescription(new String[]{"<p>Ratio of the unit length on the X axis to the unit", "length on the Y axis.", "If set to 1, the space will be isotropic.", "If not set (the default)", "the ratio will be determined by the given or calculated", "data bounds on both axes and the shape of the plotting", "region.", "</p>"}), Double.NaN, 1.0);
    public static final ConfigKey<Boolean> GRID_KEY = new BooleanConfigKey(new ConfigMeta("grid", "Draw Grid").setShortDescription("Draw grid lines?").setXmlDescription(new String[]{"<p>If true, grid lines are drawn on the plot", "at positions determined by the major tick marks.", "If false, they are absent.", "</p>"}), false);
    public static final ConfigKey<Double> XCROWD_KEY = PlaneSurfaceFactory.createAxisCrowdKey("X");
    public static final ConfigKey<Double> YCROWD_KEY = PlaneSurfaceFactory.createAxisCrowdKey("Y");
    public static final ConfigKey<boolean[]> NAVAXES_KEY = new CombinationConfigKey(new ConfigMeta("navaxes", "Pan/Zoom Axes").setStringUsage("xy|x|y").setShortDescription("Axes affected by pan/zoom").setXmlDescription(new String[]{"<p>Determines the axes which are affected by", "the interactive navigation actions (pan and zoom).", "The default is <code>xy</code>, which means that", "the various mouse gestures will provide panning and zooming", "in both X and Y directions.", "However, if it is set to (for instance) <code>x</code>", "then the mouse will only allow panning and", "zooming in the horizontal direction,", "with the vertical extent fixed.", "</p>"}), new String[]{"X", "Y"});
    public static final ConfigKey<Boolean> XANCHOR_KEY = PlaneSurfaceFactory.createAxisAnchorKey("X", false);
    public static final ConfigKey<Boolean> YANCHOR_KEY = PlaneSurfaceFactory.createAxisAnchorKey("Y", false);

    @Override
    public Surface createSurface(Rectangle plotBounds, Profile profile, PlaneAspect aspect) {
        Profile p = profile;
        return PlaneSurface.createSurface(plotBounds, aspect, p.xlog_, p.ylog_, p.xflip_, p.yflip_, p.xlabel_, p.ylabel_, p.captioner_, p.xyfactor_, p.grid_, p.xcrowd_, p.ycrowd_, p.minor_, p.gridcolor_, p.axlabelcolor_);
    }

    @Override
    public ConfigKey[] getProfileKeys() {
        ArrayList<ConfigKey> list = new ArrayList<ConfigKey>();
        list.addAll(Arrays.asList(XLOG_KEY, YLOG_KEY, XFLIP_KEY, YFLIP_KEY, XLABEL_KEY, YLABEL_KEY, XYFACTOR_KEY, GRID_KEY, XCROWD_KEY, YCROWD_KEY, StyleKeys.MINOR_TICKS, StyleKeys.GRID_COLOR, StyleKeys.AXLABEL_COLOR));
        list.addAll(Arrays.asList(StyleKeys.CAPTIONER.getKeys()));
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public Profile createProfile(ConfigMap config) {
        boolean xlog = config.get(XLOG_KEY);
        boolean ylog = config.get(YLOG_KEY);
        boolean xflip = config.get(XFLIP_KEY);
        boolean yflip = config.get(YFLIP_KEY);
        String xlabel = config.get(XLABEL_KEY);
        String ylabel = config.get(YLABEL_KEY);
        double xyfactor = config.get(XYFACTOR_KEY);
        boolean grid = config.get(GRID_KEY);
        double xcrowd = config.get(XCROWD_KEY);
        double ycrowd = config.get(YCROWD_KEY);
        boolean minor = config.get(StyleKeys.MINOR_TICKS);
        Color gridcolor = config.get(StyleKeys.GRID_COLOR);
        Color axlabelcolor = config.get(StyleKeys.AXLABEL_COLOR);
        Captioner captioner = StyleKeys.CAPTIONER.createValue(config);
        return new Profile(xlog, ylog, xflip, yflip, xlabel, ylabel, captioner, xyfactor, grid, xcrowd, ycrowd, minor, gridcolor, axlabelcolor);
    }

    @Override
    public ConfigKey[] getAspectKeys() {
        return new ConfigKey[]{XMIN_KEY, XMAX_KEY, XSUBRANGE_KEY, YMIN_KEY, YMAX_KEY, YSUBRANGE_KEY};
    }

    @Override
    public boolean useRanges(Profile profile, ConfigMap config) {
        return PlaneSurfaceFactory.createUnrangedAspect(profile, config) == null;
    }

    @Override
    public PlaneAspect createAspect(Profile profile, ConfigMap config, Range[] ranges) {
        PlaneAspect unrangedAspect = PlaneSurfaceFactory.createUnrangedAspect(profile, config);
        if (unrangedAspect != null) {
            return unrangedAspect;
        }
        Range xrange = ranges == null ? new Range() : ranges[0];
        Range yrange = ranges == null ? new Range() : ranges[1];
        double[] xlimits = PlaneSurfaceFactory.getLimits(config, XMIN_KEY, XMAX_KEY, XSUBRANGE_KEY, profile.xlog_, xrange);
        double[] ylimits = PlaneSurfaceFactory.getLimits(config, YMIN_KEY, YMAX_KEY, YSUBRANGE_KEY, profile.ylog_, yrange);
        return new PlaneAspect(xlimits, ylimits);
    }

    @Override
    public ConfigMap getAspectConfig(Surface surf) {
        return surf instanceof PlaneSurface ? ((PlaneSurface)surf).getAspectConfig() : new ConfigMap();
    }

    @Override
    public Range[] readRanges(Profile profile, PlotLayer[] layers, DataStore dataStore) {
        boolean[] logFlags = profile.getLogFlags();
        assert (logFlags.length == 2);
        return PlotUtil.readCoordinateRanges(layers, 2, logFlags, dataStore);
    }

    @Override
    public ConfigKey[] getNavigatorKeys() {
        return new ConfigKey[]{NAVAXES_KEY, XANCHOR_KEY, YANCHOR_KEY, StyleKeys.ZOOM_FACTOR};
    }

    @Override
    public Navigator<PlaneAspect> createNavigator(ConfigMap navConfig) {
        double zoom = navConfig.get(StyleKeys.ZOOM_FACTOR);
        boolean[] navFlags = navConfig.get(NAVAXES_KEY);
        boolean xnav = navFlags[0];
        boolean ynav = navFlags[1];
        double xAnchor = navConfig.get(YANCHOR_KEY) != false ? 0.0 : Double.NaN;
        double yAnchor = navConfig.get(XANCHOR_KEY) != false ? 0.0 : Double.NaN;
        return new PlaneNavigator(zoom, xnav, ynav, xnav, ynav, xAnchor, yAnchor);
    }

    public static ConfigKey<Boolean> createAxisAnchorKey(String axname, boolean dflt) {
        String axl = axname.toLowerCase();
        String axL = ConfigMeta.capitalise(axname);
        ConfigMeta meta = new ConfigMeta(axl + "anchor", "Anchor " + axL + " axis");
        meta.setShortDescription("Fix " + axL + " zero point?");
        meta.setXmlDescription(new String[]{"<p>If true, then zoom actions", "will work in such a way that the zero point", "on the " + axL + " axis stays in the same position on the plot.", "</p>"});
        return new BooleanConfigKey(meta, dflt);
    }

    public static ConfigKey<Double> createAxisLimitKey(String axname, boolean isMax) {
        String axl = axname.toLowerCase();
        String axL = ConfigMeta.capitalise(axname);
        String lim = isMax ? "max" : "min";
        String limit = isMax ? "Maximum" : "Minimum";
        String shortName = axl + lim;
        String longName = limit + " " + axL;
        ConfigMeta meta = new ConfigMeta(shortName, longName);
        meta.setShortDescription(limit + " " + axL + " data value");
        meta.setXmlDescription(new String[]{"<p>" + limit + " value of the data coordinate", "on the " + axL + " axis.", "This sets the value before any subranging is applied.", "If not supplied, the value is determined from the plotted data.", "</p>"});
        return DoubleConfigKey.createTextKey(meta);
    }

    public static ConfigKey<Boolean> createAxisLogKey(String axname) {
        String axl = axname.toLowerCase();
        String axL = ConfigMeta.capitalise(axname);
        ConfigMeta meta = new ConfigMeta(axl + "log", axL + " Log");
        meta.setShortDescription("Logarithmic scale on " + axL + " axis?");
        meta.setXmlDescription(new String[]{"<p>If false (the default), the scale on the " + axL + " axis", "is linear,", "if true it is logarithmic.", "</p>"});
        return new BooleanConfigKey(meta);
    }

    public static ConfigKey<Boolean> createAxisFlipKey(String axname) {
        String axl = axname.toLowerCase();
        String axL = ConfigMeta.capitalise(axname);
        ConfigMeta meta = new ConfigMeta(axl + "flip", axL + " Flip");
        meta.setShortDescription("Flip scale on " + axL + " axis?");
        meta.setXmlDescription(new String[]{"<p>If true, the scale on the " + axL + " axis", "will increase in the opposite sense from usual", "(e.g. right to left rather than left to right).", "</p>"});
        return new BooleanConfigKey(meta);
    }

    public static ConfigKey<Subrange> createAxisSubrangeKey(String axname) {
        ConfigMeta meta = SubrangeConfigKey.createAxisSubMeta(axname.toLowerCase(), ConfigMeta.capitalise(axname));
        return new SubrangeConfigKey(meta);
    }

    public static ConfigKey<Double> createAxisCrowdKey(String axname) {
        String axl = axname.substring(0, 1).toLowerCase();
        String axL = ConfigMeta.capitalise(axname);
        ConfigMeta meta = new ConfigMeta(axl + "crowd", axL + " Tick Crowding");
        meta.setShortDescription("Tick crowding on " + axL + " axis");
        meta.setXmlDescription(new String[]{"<p>Determines how closely the tick marks are spaced", "on the " + axL + " axis.", "The default value is 1, meaning normal crowding.", "Larger values result in more ticks,", "and smaller values fewer ticks.", "Tick marks will not however be spaced so closely that", "the labels overlap each other,", "so to get very closely spaced marks you may need to", "reduce the font size as well.", "</p>"});
        return StyleKeys.createCrowdKey(meta);
    }

    public static double[] getLimits(ConfigMap config, ConfigKey<Double> minKey, ConfigKey<Double> maxKey, ConfigKey<Subrange> subrangeKey, boolean isLog, Range range) {
        return PlaneSurfaceFactory.getLimits(config.get(minKey), config.get(maxKey), config.get(subrangeKey), isLog, range);
    }

    public static double[] getLimits(double lo, double hi, Subrange subrange, boolean isLog, Range range) {
        boolean isFinite;
        boolean bl = isFinite = lo < hi && !Double.isInfinite(lo) && !Double.isInfinite(hi) && (!isLog || !(lo <= 0.0));
        if (isFinite) {
            return PlotUtil.scaleRange(lo, hi, subrange, isLog);
        }
        if (range != null) {
            Range r1 = new Range(range);
            r1.limit(lo, hi);
            double[] b1 = r1.getFiniteBounds(isLog);
            return PlotUtil.scaleRange(b1[0], b1[1], subrange, isLog);
        }
        return null;
    }

    private static PlaneAspect createUnrangedAspect(Profile profile, ConfigMap config) {
        double[] xlimits = PlaneSurfaceFactory.getLimits(config, XMIN_KEY, XMAX_KEY, XSUBRANGE_KEY, profile.xlog_, null);
        double[] ylimits = PlaneSurfaceFactory.getLimits(config, YMIN_KEY, YMAX_KEY, YSUBRANGE_KEY, profile.ylog_, null);
        return xlimits == null || ylimits == null ? null : new PlaneAspect(xlimits, ylimits);
    }

    public static class Profile {
        private final boolean xlog_;
        private final boolean ylog_;
        private final boolean xflip_;
        private final boolean yflip_;
        private final String xlabel_;
        private final String ylabel_;
        private final Captioner captioner_;
        private final double xyfactor_;
        private final boolean grid_;
        private final double xcrowd_;
        private final double ycrowd_;
        private final boolean minor_;
        private final Color gridcolor_;
        private final Color axlabelcolor_;

        public Profile(boolean xlog, boolean ylog, boolean xflip, boolean yflip, String xlabel, String ylabel, Captioner captioner, double xyfactor, boolean grid, double xcrowd, double ycrowd, boolean minor, Color gridcolor, Color axlabelcolor) {
            this.xlog_ = xlog;
            this.ylog_ = ylog;
            this.xflip_ = xflip;
            this.yflip_ = yflip;
            this.xlabel_ = xlabel;
            this.ylabel_ = ylabel;
            this.captioner_ = captioner;
            this.xyfactor_ = xyfactor;
            this.grid_ = grid;
            this.xcrowd_ = xcrowd;
            this.ycrowd_ = ycrowd;
            this.minor_ = minor;
            this.gridcolor_ = gridcolor;
            this.axlabelcolor_ = axlabelcolor;
        }

        public boolean[] getLogFlags() {
            return new boolean[]{this.xlog_, this.ylog_};
        }
    }
}

