/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.util.Arrays;

public class SkyAspect {
    private final double[] rotmat_;
    private final double zoom_;
    private final double xoff_;
    private final double yoff_;

    public SkyAspect(double[] rotmat, double zoom, double xoff, double yoff) {
        this.rotmat_ = (double[])rotmat.clone();
        this.zoom_ = zoom;
        this.xoff_ = xoff;
        this.yoff_ = yoff;
    }

    public double[] getRotation() {
        return (double[])this.rotmat_.clone();
    }

    public double getZoom() {
        return this.zoom_;
    }

    public double getOffsetX() {
        return this.xoff_;
    }

    public double getOffsetY() {
        return this.yoff_;
    }

    public boolean equals(Object o) {
        if (o instanceof SkyAspect) {
            SkyAspect other = (SkyAspect)o;
            return Arrays.equals(this.rotmat_, other.rotmat_) && this.zoom_ == other.zoom_ && this.xoff_ == other.xoff_ && this.yoff_ == other.yoff_;
        }
        return false;
    }

    public int hashCode() {
        int code = 21123;
        code = 23 * code + Arrays.hashCode(this.rotmat_);
        code = 23 * code + Float.floatToIntBits((float)this.zoom_);
        code = 23 * code + Float.floatToIntBits((float)this.xoff_);
        code = 23 * code + Float.floatToIntBits((float)this.yoff_);
        return code;
    }

    public static double[] unitMatrix(boolean reflect) {
        double r = reflect ? -1.0 : 1.0;
        return new double[]{1.0, 0.0, 0.0, 0.0, r, 0.0, 0.0, 0.0, 1.0};
    }
}

