/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.geom.AxisAnnotation;
import uk.ac.starlink.ttools.plot2.geom.GridLiner;
import uk.ac.starlink.ttools.plot2.geom.SkyAxisLabeller;
import uk.ac.starlink.ttools.plot2.geom.TickSkyAxisLabeller;

public class SkyAxisLabellers {
    public static SkyAxisLabeller NONE = new SkyAxisLabeller(){

        @Override
        public String getLabellerName() {
            return "None";
        }

        @Override
        public String getLabellerDescription() {
            return "Axes are not labelled";
        }

        @Override
        public AxisAnnotation createAxisAnnotation(GridLiner gridLiner, Captioner captioner) {
            return new AxisAnnotation(){

                @Override
                public Insets getPadding(boolean withScroll) {
                    return new Insets(0, 0, 0, 0);
                }

                @Override
                public void drawLabels(Graphics g) {
                }
            };
        }
    };
    public static SkyAxisLabeller LAME = new SkyAxisLabeller(){

        @Override
        public String getLabellerName() {
            return "Basic";
        }

        @Override
        public String getLabellerDescription() {
            return "Labels are drawn somewhere near the grid line";
        }

        @Override
        public AxisAnnotation createAxisAnnotation(final GridLiner gridLiner, final Captioner captioner) {
            return new AxisAnnotation(){

                @Override
                public Insets getPadding(boolean withScroll) {
                    return new Insets(0, 0, 0, 0);
                }

                @Override
                public void drawLabels(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g;
                    double[][][] lines = gridLiner.getLines();
                    String[] labels = gridLiner.getLabels();
                    int nl = labels.length;
                    for (int il = 0; il < nl; ++il) {
                        double[][] line = lines[il];
                        String label = labels[il];
                        double[] seg0 = line[0];
                        double[] segN = line[line.length - 1];
                        double px = seg0[0];
                        double py = seg0[1];
                        g2.translate(px, py);
                        captioner.drawCaption(label, g2);
                        g2.translate(-px, -py);
                    }
                }
            };
        }
    };
    public static SkyAxisLabeller EXTERNAL = new TickSkyAxisLabeller("External", "Labels are drawn outside the plot bounds"){

        @Override
        protected TickSkyAxisLabeller.SkyTick[] calculateTicks(double[][][] lines, String[] labels, Rectangle plotBounds) {
            ArrayList<TickSkyAxisLabeller.SkyTick> tickList = new ArrayList<TickSkyAxisLabeller.SkyTick>();
            int nl = labels.length;
            for (int il = 0; il < nl; ++il) {
                TickSkyAxisLabeller.SkyTick tick = 3.createExternalTick(labels[il], lines[il], plotBounds);
                if (tick == null) continue;
                tickList.add(tick);
            }
            return tickList.toArray(new TickSkyAxisLabeller.SkyTick[0]);
        }
    };
    public static SkyAxisLabeller INTERNAL = new TickSkyAxisLabeller("Internal", "Labels are drawn inside the plot bounds"){

        @Override
        protected TickSkyAxisLabeller.SkyTick[] calculateTicks(double[][][] lines, String[] labels, Rectangle plotBounds) {
            ArrayList<TickSkyAxisLabeller.SkyTick> tickList = new ArrayList<TickSkyAxisLabeller.SkyTick>();
            int nl = labels.length;
            for (int il = 0; il < nl; ++il) {
                TickSkyAxisLabeller.SkyTick tick = 4.createInternalTick(labels[il], lines[il]);
                if (tick == null) continue;
                tickList.add(tick);
            }
            return tickList.toArray(new TickSkyAxisLabeller.SkyTick[0]);
        }
    };
    public static SkyAxisLabeller HYBRID = new TickSkyAxisLabeller("Hybrid", "Grid lines are labelled outside the plot bounds where possible, but inside if they would otherwise be invisible"){

        @Override
        protected TickSkyAxisLabeller.SkyTick[] calculateTicks(double[][][] lines, String[] labels, Rectangle plotBounds) {
            ArrayList<TickSkyAxisLabeller.SkyTick> tickList = new ArrayList<TickSkyAxisLabeller.SkyTick>();
            int nl = labels.length;
            for (int il = 0; il < nl; ++il) {
                String label = labels[il];
                double[][] line = lines[il];
                TickSkyAxisLabeller.SkyTick tick = 5.createExternalTick(label, line, plotBounds);
                if (tick == null) {
                    tick = 5.createInternalTick(label, line);
                }
                if (tick == null) continue;
                tickList.add(tick);
            }
            return tickList.toArray(new TickSkyAxisLabeller.SkyTick[0]);
        }
    };

    private SkyAxisLabellers() {
    }

    public static SkyAxisLabeller[] getKnownLabellers() {
        return new SkyAxisLabeller[]{null, EXTERNAL, INTERNAL, LAME, HYBRID, NONE};
    }

    public static SkyAxisLabeller getAutoLabeller(boolean skyFillsBounds) {
        return skyFillsBounds ? EXTERNAL : INTERNAL;
    }
}

