/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.logging.Logger;
import skyview.geometry.Projecter;
import skyview.geometry.Rotater;
import skyview.geometry.Scaler;
import skyview.geometry.TransformationException;
import uk.ac.starlink.ttools.func.CoordsRadians;
import uk.ac.starlink.ttools.plot.Matrices;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.geom.GridLiner;
import uk.ac.starlink.ttools.plot2.geom.Projection;
import uk.ac.starlink.ttools.plot2.geom.Rotation;
import uk.ac.starlink.ttools.plot2.geom.SkyAspect;
import uk.ac.starlink.ttools.plot2.geom.SkyAxisLabeller;
import uk.ac.starlink.ttools.plot2.geom.SkyAxisLabellers;
import uk.ac.starlink.ttools.plot2.geom.SkySys;
import uk.ac.starlink.ttools.plot2.geom.SkyviewProjection;

public class SkySurface
implements Surface {
    private final int gxlo_;
    private final int gxhi_;
    private final int gylo_;
    private final int gyhi_;
    private final SkySys viewSystem_;
    private final SkyAxisLabeller axLabeller_;
    private final Color gridColor_;
    private final Color axlabelColor_;
    private final boolean sexagesimal_;
    private final double crowd_;
    private final Captioner captioner_;
    private final boolean antialias_;
    private final double[] unrotmat_;
    private final Projection projection_;
    private final double[] rotmat_;
    private final double zoom_;
    private final double xoff_;
    private final double yoff_;
    private final double gScale_;
    private final int gXoff_;
    private final int gYoff_;
    private final double gZoom_;
    private final boolean skyFillsBounds_;
    private final boolean isContinuous_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2");

    public SkySurface(Rectangle plotBounds, Projection projection, double[] rotmat, double zoom, double xoff, double yoff, SkySys viewSystem, SkyAxisLabeller axLabeller, Color gridColor, Color axlabelColor, boolean sexagesimal, double crowd, Captioner captioner, boolean antialias) {
        this.gxlo_ = plotBounds.x;
        this.gxhi_ = plotBounds.x + plotBounds.width;
        this.gylo_ = plotBounds.y;
        this.gyhi_ = plotBounds.y + plotBounds.height;
        this.viewSystem_ = viewSystem;
        this.gridColor_ = gridColor;
        this.axlabelColor_ = axlabelColor;
        this.sexagesimal_ = sexagesimal;
        this.crowd_ = crowd;
        this.captioner_ = captioner;
        this.antialias_ = antialias;
        this.projection_ = projection;
        this.rotmat_ = rotmat;
        this.zoom_ = zoom;
        this.xoff_ = xoff;
        this.yoff_ = yoff;
        this.isContinuous_ = projection.isContinuous();
        this.unrotmat_ = Matrices.invert(this.rotmat_);
        Shape projShape = this.projection_.getProjectionShape();
        Rectangle2D pBounds = projShape.getBounds2D();
        int xpix = this.gxhi_ - this.gxlo_;
        int ypix = this.gyhi_ - this.gylo_;
        this.gScale_ = Math.min((double)xpix / pBounds.getWidth(), (double)ypix / pBounds.getHeight());
        this.gXoff_ = this.gxlo_ + (int)(this.xoff_ * this.gScale_ + (double)(xpix / 2));
        this.gYoff_ = this.gylo_ + (int)(this.yoff_ * this.gScale_ + (double)(ypix / 2));
        this.gZoom_ = this.zoom_ * this.gScale_;
        Rectangle2D.Double projBounds = new Rectangle2D.Double((double)(-this.gXoff_) / this.gZoom_, (double)(-this.gYoff_) / this.gZoom_, (double)(this.gxhi_ - this.gxlo_) / this.gZoom_, (double)(this.gyhi_ - this.gylo_) / this.gZoom_);
        this.skyFillsBounds_ = projShape.contains(projBounds);
        this.axLabeller_ = this.axlabelColor_ == null ? SkyAxisLabellers.NONE : (axLabeller == null ? SkyAxisLabellers.getAutoLabeller(this.skyFillsBounds_) : axLabeller);
        assert (this.equals(this));
    }

    @Override
    public int getDataDimCount() {
        return 3;
    }

    @Override
    public Rectangle getPlotBounds() {
        return new Rectangle(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
    }

    @Override
    public Insets getPlotInsets(boolean withScroll) {
        GridLiner gl = this.gridColor_ == null ? null : this.createGridder();
        return gl == null ? new Insets(0, 0, 0, 0) : this.axLabeller_.createAxisAnnotation(gl, this.captioner_).getPadding(withScroll);
    }

    @Override
    public void paintBackground(Graphics g) {
        Shape gShape;
        Graphics2D g2 = (Graphics2D)g.create();
        if (this.skyFillsBounds_) {
            gShape = new Rectangle(this.getPlotBounds());
        } else {
            g2.clip(new Rectangle(this.getPlotBounds()));
            g2.translate(this.gXoff_, this.gYoff_);
            g2.scale(this.gZoom_, -this.gZoom_);
            g2.setStroke(new BasicStroke((float)(1.0 / this.gZoom_)));
            gShape = this.projection_.getProjectionShape();
        }
        g2.setColor(Color.WHITE);
        g2.fill(gShape);
        g2.dispose();
    }

    @Override
    public void paintForeground(Graphics g) {
        GridLiner gl;
        GridLiner gridLiner = gl = this.gridColor_ != null || this.axlabelColor_ != null ? this.createGridder() : null;
        if (gl == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Color color0 = g.getColor();
        Object aa0 = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.antialias_ ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.gridColor_ != null) {
            g2.setColor(this.gridColor_);
            double[][][] lines = gl.getLines();
            String[] labels = gl.getLabels();
            int nl = labels.length;
            for (int il = 0; il < nl; ++il) {
                double[][] line = lines[il];
                int nseg = line.length;
                GeneralPath path = new GeneralPath(1, nseg);
                double[] seg0 = line[0];
                path.moveTo((float)seg0[0], (float)seg0[1]);
                for (int is = 1; is < nseg; ++is) {
                    double[] seg = line[is];
                    path.lineTo((float)seg[0], (float)seg[1]);
                }
                g2.draw(path);
            }
        }
        if (this.skyFillsBounds_) {
            g2.draw(this.getPlotBounds());
        } else {
            Graphics2D g2a = (Graphics2D)g.create();
            g2a.clip(new Rectangle(this.getPlotBounds()));
            g2a.translate(this.gXoff_, this.gYoff_);
            g2a.scale(this.gZoom_, -this.gZoom_);
            g2a.setStroke(new BasicStroke((float)(1.0 / this.gZoom_)));
            g2a.draw(this.projection_.getProjectionShape());
            g2a.dispose();
        }
        if (this.axlabelColor_ != null) {
            g2.setColor(this.axlabelColor_);
            this.axLabeller_.createAxisAnnotation(gl, this.captioner_).drawLabels(g2);
        }
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa0);
        g2.setColor(color0);
    }

    @Override
    public Captioner getCaptioner() {
        return this.captioner_;
    }

    public Projection getProjection() {
        return this.projection_;
    }

    public double[] getRotation() {
        return this.rotmat_;
    }

    public double getZoom() {
        return this.zoom_;
    }

    public double getOffsetX() {
        return this.xoff_;
    }

    public double getOffsetY() {
        return this.yoff_;
    }

    private GridLiner createGridder() {
        return this.createGridder(null, this.sexagesimal_, this.crowd_);
    }

    public GridLiner createGridder(Rotation rotation, boolean sexagesimal, double crowd) {
        double[] rotmat;
        double[] dArray = rotmat = rotation == null ? this.rotmat_ : Matrices.mmMult(this.rotmat_, rotation.getMatrix());
        if (this.projection_ instanceof SkyviewProjection) {
            Rotater rotater;
            Projecter projecter = ((SkyviewProjection)this.projection_).getSkyviewProjecter();
            Scaler scaler = new Scaler((double)(this.gXoff_ - this.gxlo_), (double)(this.gYoff_ - this.gylo_), this.gZoom_, 0.0, 0.0, -this.gZoom_);
            try {
                rotater = new Rotater(Matrices.toPal(rotmat));
            }
            catch (TransformationException e) {
                assert (false);
                return null;
            }
            Rectangle plotBounds = this.getPlotBounds();
            if (plotBounds.width < 32 || plotBounds.height < 32) {
                return null;
            }
            GridLiner gl = new GridLiner(plotBounds, rotater, projecter, scaler, sexagesimal, crowd, crowd);
            try {
                gl.grid();
                return gl;
            }
            catch (Exception e) {
                logger_.warning("Grid error: " + e);
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean dataToGraphics(double[] dpos, boolean visibleOnly, Point2D.Double gpos) {
        double[] rot = this.rotmat_;
        double sx = dpos[0];
        double sy = dpos[1];
        double sz = dpos[2];
        double rx = rot[0] * sx + rot[1] * sy + rot[2] * sz;
        double ry = rot[3] * sx + rot[4] * sy + rot[5] * sz;
        double rz = rot[6] * sx + rot[7] * sy + rot[8] * sz;
        Point2D.Double proj = new Point2D.Double();
        if (this.projection_.project(rx, ry, rz, proj)) {
            double xp = (double)this.gXoff_ + proj.x * this.gZoom_;
            double yp = (double)this.gYoff_ - proj.y * this.gZoom_;
            if (!visibleOnly || xp >= (double)this.gxlo_ && xp < (double)this.gxhi_ && yp >= (double)this.gylo_ && yp < (double)this.gyhi_) {
                gpos.x = xp;
                gpos.y = yp;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean dataToGraphicsOffset(double[] dpos0, Point2D.Double gpos0, double[] dpos1, boolean visibleOnly, Point2D.Double gpos1) {
        boolean forward;
        boolean aStatus = this.dataToGraphics(dpos1, visibleOnly, gpos1);
        if (this.isContinuous_) {
            return aStatus;
        }
        double ax = gpos1.x;
        double ay = gpos1.y;
        double dp1x = dpos1[0];
        double dp1y = dpos1[1];
        double dp1z = dpos1[2];
        SkySurface.reflectPoint(dpos0, dpos1);
        boolean bStatus = this.dataToGraphics(dpos1, visibleOnly, gpos1);
        dpos1[0] = dp1x;
        dpos1[1] = dp1y;
        dpos1[2] = dp1z;
        double bx = gpos1.x;
        double by = gpos1.y;
        if (aStatus && bStatus) {
            double bd;
            double ad = Math.hypot(ax - gpos0.x, ay - gpos0.y);
            forward = ad < 2.0 * (bd = Math.hypot(bx - gpos0.x, by - gpos0.y));
        } else if (aStatus && !bStatus) {
            forward = true;
        } else if (!aStatus && bStatus) {
            forward = false;
        } else {
            assert (!aStatus && !bStatus);
            return false;
        }
        if (forward) {
            gpos1.x = ax;
            gpos1.y = ay;
        } else {
            gpos1.x = 2.0 * gpos0.x - bx;
            gpos1.y = 2.0 * gpos0.y - by;
        }
        return true;
    }

    private static void reflectPoint(double[] a, double[] b) {
        double a0 = a[0];
        double a1 = a[1];
        double a2 = a[2];
        double b0 = b[0];
        double b1 = b[1];
        double b2 = b[2];
        double x = a1 * b2 - a2 * b1;
        double y = -(a0 * b2 - a2 * b0);
        double z = a0 * b1 - a1 * b0;
        x = -x;
        y = -y;
        z = -z;
        double phi = Math.sqrt(x * x + y * y + z * z);
        double s = Math.sin(phi);
        double c = Math.cos(phi);
        double w = 1.0 - c;
        if (phi != 0.0) {
            double phi1 = 1.0 / phi;
            x *= phi1;
            y *= phi1;
            z *= phi1;
        }
        double m00 = x * x * w + c;
        double m01 = x * y * w + z * s;
        double m02 = x * z * w - y * s;
        double m10 = x * y * w - z * s;
        double m11 = y * y * w + c;
        double m12 = y * z * w + x * s;
        double m20 = x * z * w + y * s;
        double m21 = y * z * w - x * s;
        double m22 = z * z * w + c;
        b[0] = m00 * a0 + m10 * a1 + m20 * a2;
        b[1] = m01 * a0 + m11 * a1 + m21 * a2;
        b[2] = m02 * a0 + m12 * a1 + m22 * a2;
    }

    private Point2D.Double graphicsToProjected(Point2D gpos) {
        return new Point2D.Double((gpos.getX() - (double)this.gXoff_) / this.gZoom_, (gpos.getY() - (double)this.gYoff_) / -this.gZoom_);
    }

    @Override
    public double[] graphicsToData(Point2D gpos, Iterable<double[]> dposIt) {
        double[] dpos;
        Point2D.Double ppos = this.graphicsToProjected(gpos);
        if (this.projection_.getProjectionShape().contains(ppos) && this.projection_.unproject(ppos, dpos = new double[3])) {
            return Matrices.mvMult(this.unrotmat_, dpos);
        }
        return null;
    }

    @Override
    public String formatPosition(double[] dpos) {
        double lonRad;
        double pixRad = Math.PI * 2 / this.gZoom_;
        double x = dpos[0];
        double y = dpos[1];
        double z = dpos[2];
        double latRad = 1.5707963267948966 - Math.acos(z);
        for (lonRad = Math.atan2(y, x); lonRad < 0.0; lonRad += Math.PI * 2) {
        }
        return this.sexagesimal_ ? SkySurface.formatPositionSex(lonRad, latRad, pixRad) : SkySurface.formatPositionDec(lonRad, latRad, pixRad);
    }

    double[] getRoundedLonLatDegrees(double[] r3) {
        double lonRad;
        double pixRad = Math.PI * 2 / this.gZoom_;
        double x = r3[0];
        double y = r3[1];
        double z = r3[2];
        double latRad = 1.5707963267948966 - Math.acos(z);
        for (lonRad = Math.atan2(y, x); lonRad < 0.0; lonRad += Math.PI * 2) {
        }
        double degFact = 57.29577951308232;
        double degEpsilon = degFact * pixRad * 0.1;
        return new double[]{PlotUtil.roundNumber(degFact * lonRad, degEpsilon), PlotUtil.roundNumber(degFact * latRad, degEpsilon)};
    }

    public double pixelAreaSteradians() {
        Point2D.Double screenCenter = new Point2D.Double((double)(this.gxlo_ + this.gxhi_) * 0.5, (double)(this.gylo_ + this.gyhi_) * 0.5);
        double size = this.pixelAreaSteradians(screenCenter);
        return Double.isNaN(size) ? this.pixelAreaSteradians(this.getSkyCenter()) : size;
    }

    public double pixelAreaSteradians(Point2D gpos) {
        double gx = gpos.getX();
        double gy = gpos.getY();
        double delta = 1.0;
        double d2 = delta * 0.5;
        return 0.5 * this.screenDistanceRadians(new Point2D.Double(gx - d2, gy - d2), new Point2D.Double(gx + d2, gy + d2)) * this.screenDistanceRadians(new Point2D.Double(gx - d2, gy + d2), new Point2D.Double(gx + d2, gy - d2));
    }

    public double screenDistanceRadians(Point2D gp1, Point2D gp2) {
        double[] dp1 = this.graphicsToData(gp1, null);
        double[] dp2 = this.graphicsToData(gp2, null);
        return dp1 == null || dp2 == null ? Double.NaN : Math.atan2(Matrices.mod(Matrices.cross(dp1, dp2)), Matrices.dot(dp1, dp2));
    }

    private static String formatPositionSex(double lonRad, double latRad, double pixRad) {
        int secondDp = SkySurface.getDecimalPlaces(pixRad / Math.PI * 12.0 * 60.0 * 60.0);
        int arcsecDp = SkySurface.getDecimalPlaces(pixRad / Math.PI * 180.0 * 60.0 * 60.0);
        String lonSex = CoordsRadians.radiansToHms(lonRad, Math.max(0, secondDp));
        if (secondDp < -1) {
            lonSex = lonSex.substring(0, lonSex.lastIndexOf(58));
        }
        String latSex = CoordsRadians.radiansToDms(latRad, Math.max(0, arcsecDp));
        if (arcsecDp < -1) {
            latSex = latSex.substring(0, latSex.lastIndexOf(58));
        }
        return lonSex + ", " + latSex;
    }

    private static String formatPositionDec(double lonRad, double latRad, double pixRad) {
        String slat;
        String slon;
        double lonDeg = lonRad * 180.0 / Math.PI;
        double latDeg = latRad * 180.0 / Math.PI;
        double pixDeg = pixRad * 180.0 / Math.PI;
        if (pixDeg >= 1.0) {
            slon = Integer.toString((int)Math.round(lonDeg));
            slat = Integer.toString((int)Math.round(latDeg));
        } else {
            int ndp = SkySurface.getDecimalPlaces(pixDeg);
            assert (ndp >= 0);
            slon = PlotUtil.formatNumber(lonDeg, "0.0", ndp);
            slat = PlotUtil.formatNumber(latDeg, "0.0", ndp);
        }
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(slon);
        sbuf.append(", ");
        char s0 = slat.charAt(0);
        if (s0 != '-' && s0 != '+') {
            sbuf.append('+');
        }
        sbuf.append(slat);
        return sbuf.toString();
    }

    private static int getDecimalPlaces(double value) {
        return -((int)Math.floor(Math.log(value) / Math.log(10.0)));
    }

    SkyAspect pan(Point2D pos0, Point2D pos1) {
        return this.inBounds(pos0) ? this.projPan(pos0, pos1) : null;
    }

    SkyAspect zoom(Point pos, double factor) {
        return this.inBounds(pos) ? this.projZoom(pos, factor) : null;
    }

    private boolean inBounds(Point2D pos) {
        return pos.getX() >= (double)this.gxlo_ && pos.getX() <= (double)this.gxhi_ && pos.getY() >= (double)this.gylo_ && pos.getY() <= (double)this.gyhi_;
    }

    SkyAspect center(double[] dpos) {
        Point2D.Double gp = new Point2D.Double();
        return this.dataToGraphics(dpos, false, gp) ? this.pan(gp, new Point2D.Double((double)(this.gxlo_ + this.gxhi_) * 0.5, (double)(this.gylo_ + this.gyhi_) * 0.5)) : null;
    }

    public SkyAspect flatPan(Point2D pos0, Point2D pos1) {
        double xoff1 = this.xoff_ + (pos1.getX() - pos0.getX()) / this.gScale_;
        double yoff1 = this.yoff_ + (pos1.getY() - pos0.getY()) / this.gScale_;
        return this.createAspect(this.rotmat_, this.zoom_, xoff1, yoff1);
    }

    public SkyAspect flatZoom(Point2D pos, double factor) {
        double dz = this.zoom_ * (1.0 - factor);
        double zoom1 = this.zoom_ * factor;
        double xoff1 = this.xoff_ + (pos.getX() - (double)this.gXoff_) / this.gZoom_ * dz;
        double yoff1 = this.yoff_ + (pos.getY() - (double)this.gYoff_) / this.gZoom_ * dz;
        return this.createAspect(this.rotmat_, zoom1, xoff1, yoff1);
    }

    public SkyAspect projPan(Point2D pos0, Point2D pos1) {
        double[] rotmat1 = this.projection_.cursorRotate(this.rotmat_, this.graphicsToProjected(pos0), this.graphicsToProjected(pos1));
        return rotmat1 == null ? this.flatPan(pos0, pos1) : this.createAspect(rotmat1, this.zoom_, this.xoff_, this.yoff_);
    }

    public SkyAspect projZoom(Point2D pos, double factor) {
        Point2D.Double ppos0 = this.graphicsToProjected(pos);
        Point2D.Double ppos1 = new Point2D.Double(ppos0.x / factor, ppos0.y / factor);
        double zoom1 = this.zoom_ * factor;
        double[] rotmat1 = this.projection_.projRotate(this.rotmat_, ppos0, ppos1);
        return rotmat1 == null ? this.flatZoom(pos, factor) : this.createAspect(rotmat1, zoom1, this.xoff_, this.yoff_);
    }

    public SkyAspect reframe(Point2D center, double factor) {
        Point2D.Double ppos1;
        Point2D.Double surfCenter = new Point2D.Double((double)(this.gxlo_ + this.gxhi_) * 0.5, (double)(this.gylo_ + this.gyhi_) * 0.5);
        double zoom1 = this.zoom_ * factor;
        Point2D.Double ppos0 = this.graphicsToProjected(center);
        double[] rotmat1 = this.projection_.projRotate(this.rotmat_, ppos0, ppos1 = this.graphicsToProjected(surfCenter));
        if (rotmat1 != null) {
            return this.createAspect(rotmat1, zoom1, this.xoff_, this.yoff_);
        }
        double xoff1 = -ppos0.x * zoom1;
        double yoff1 = ppos0.y * zoom1;
        return this.createAspect(this.rotmat_, zoom1, xoff1, yoff1);
    }

    public Point getSkyCenter() {
        return new Point(this.gXoff_, this.gYoff_);
    }

    public Shape getSkyShape() {
        Area shape = new Area(this.projection_.getProjectionShape());
        shape.transform(new AffineTransform(this.gZoom_, 0.0, 0.0, -this.gZoom_, (double)this.gXoff_, (double)this.gYoff_));
        return shape;
    }

    public boolean equals(Object o) {
        if (o instanceof SkySurface) {
            SkySurface other = (SkySurface)o;
            return this.gxlo_ == other.gxlo_ && this.gxhi_ == other.gxhi_ && this.gylo_ == other.gylo_ && this.gyhi_ == other.gyhi_ && this.projection_.equals(other.projection_) && Arrays.equals(this.rotmat_, other.rotmat_) && this.zoom_ == other.zoom_ && this.xoff_ == other.xoff_ && this.yoff_ == other.yoff_ && PlotUtil.equals(this.viewSystem_, other.viewSystem_) && PlotUtil.equals(this.axLabeller_, other.axLabeller_) && PlotUtil.equals(this.gridColor_, other.gridColor_) && PlotUtil.equals(this.axlabelColor_, other.axlabelColor_) && this.sexagesimal_ == other.sexagesimal_ && this.crowd_ == other.crowd_ && PlotUtil.equals(this.captioner_, other.captioner_) && this.antialias_ == other.antialias_;
        }
        return false;
    }

    public int hashCode() {
        int code = 9873;
        code = 23 * code + this.gxlo_;
        code = 23 * code + this.gxhi_;
        code = 23 * code + this.gylo_;
        code = 23 * code + this.gyhi_;
        code = 23 * code + this.projection_.hashCode();
        code = 23 * code + Arrays.hashCode(this.rotmat_);
        code = 23 * code + Float.floatToIntBits((float)this.zoom_);
        code = 23 * code + Float.floatToIntBits((float)this.xoff_);
        code = 23 * code + Float.floatToIntBits((float)this.yoff_);
        code = 23 * code + PlotUtil.hashCode(this.viewSystem_);
        code = 23 * code + PlotUtil.hashCode(this.axLabeller_);
        code = 23 * code + PlotUtil.hashCode(this.gridColor_);
        code = 23 * code + PlotUtil.hashCode(this.axlabelColor_);
        code = 23 * code + (this.sexagesimal_ ? 5 : 13);
        code = 23 * code + Float.floatToIntBits((float)this.crowd_);
        code = 23 * code + PlotUtil.hashCode(this.captioner_);
        code = 23 * code + (this.antialias_ ? 17 : 29);
        return code;
    }

    private SkyAspect createAspect(double[] rotmat, double zoom, double xoff, double yoff) {
        assert (Matrices.det(this.rotmat_) * Matrices.det(rotmat) >= 0.0);
        return new SkyAspect(rotmat, zoom, xoff, yoff);
    }
}

