/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;
import skyview.geometry.projecter.Ait;
import skyview.geometry.projecter.Arc;
import skyview.geometry.projecter.Car;
import skyview.geometry.projecter.Stg;
import skyview.geometry.projecter.Tan;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.geom.Projection;
import uk.ac.starlink.ttools.plot2.geom.SkyAspect;
import uk.ac.starlink.ttools.plot2.geom.SkyFov;
import uk.ac.starlink.ttools.plot2.geom.SkySurface;

public class SkyviewProjection
implements Projection {
    private final Projecter projecter_;
    private final Deprojecter deprojecter_;
    private final Shape shape_;
    private final boolean isContinuous_;
    public static final SkyviewProjection AIT = SkyviewProjection.createProjection((Projecter)new Ait(), false, "Aitoff", "Hammer-Aitoff projection");
    public static final SkyviewProjection CAR1 = SkyviewProjection.createProjection(new Car1(), false, "Car", "Plate Carree projection (lon/lat on Cartesian axes)");
    public static final SkyviewProjection TAN = SkyviewProjection.createProjection((Projecter)new Tan(), true);
    private static final SkyviewProjection ARC = SkyviewProjection.createProjection((Projecter)new Arc(), true);
    private static final SkyviewProjection STG = SkyviewProjection.createProjection((Projecter)new Stg(), true);
    private static final double[] RX = new double[]{1.0, 0.0, 0.0};
    private static final double[] RY = new double[]{0.0, 1.0, 0.0};
    private static final double[] RZ = new double[]{0.0, 0.0, 1.0};

    public SkyviewProjection(Projecter projecter, Shape shape, boolean isContinuous) {
        this.projecter_ = projecter;
        this.deprojecter_ = projecter.inverse();
        this.shape_ = shape;
        this.isContinuous_ = isContinuous;
    }

    @Override
    public String getProjectionName() {
        return this.projecter_.getName();
    }

    @Override
    public String getProjectionDescription() {
        return this.projecter_.getDescription();
    }

    @Override
    public Shape getProjectionShape() {
        return this.shape_;
    }

    @Override
    public boolean isContinuous() {
        return this.isContinuous_;
    }

    @Override
    public boolean project(double rx, double ry, double rz, Point2D.Double pos) {
        double[] r2 = this.projecter_.transform(new double[]{rx, ry, rz});
        if (Double.isNaN(r2[0])) {
            return false;
        }
        pos.x = r2[0];
        pos.y = r2[1];
        return true;
    }

    @Override
    public boolean unproject(Point2D.Double pos, double[] r3) {
        double[] xy = new double[]{pos.x, pos.y};
        if (this.projecter_.validPosition(xy)) {
            this.deprojecter_.transform(xy, r3);
            return true;
        }
        return false;
    }

    @Override
    public double[] cursorRotate(double[] rotmat, Point2D.Double pos0, Point2D.Double pos1) {
        return null;
    }

    @Override
    public double[] projRotate(double[] rotmat, Point2D.Double pos0, Point2D.Double pos1) {
        return null;
    }

    @Override
    public boolean useRanges(boolean reflect, double[] r3, double radiusRad) {
        return false;
    }

    @Override
    public SkyAspect createAspect(boolean reflect, double[] r3, double radiusRad, Range[] ranges) {
        double yoff;
        double xoff;
        double zoom;
        Point2D.Double dpos = new Point2D.Double();
        if (r3 != null && this.project(r3[0], r3[1], r3[2], dpos)) {
            zoom = Math.PI / radiusRad;
            xoff = dpos.x * zoom;
            yoff = dpos.y * zoom;
        } else {
            zoom = 1.0;
            xoff = 0.0;
            yoff = 0.0;
        }
        double[] rotmat = SkyAspect.unitMatrix(reflect);
        return new SkyAspect(rotmat, zoom, xoff, yoff);
    }

    @Override
    public SkyFov getFov(SkySurface surf) {
        if (surf.getZoom() == 1.0 && surf.getOffsetX() == 0.0 && surf.getOffsetY() == 0.0) {
            return null;
        }
        Rectangle bounds = surf.getPlotBounds();
        int npix = Math.max(bounds.width, bounds.height);
        Point2D.Double gpos = new Point2D.Double(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        double[] r3 = surf.graphicsToData(gpos, null);
        if (r3 != null) {
            double[] lonLat = surf.getRoundedLonLatDegrees(r3);
            double rdeg = 180.0 / surf.getZoom();
            double radiusDeg = PlotUtil.roundNumber(rdeg, rdeg / (double)(10 * npix));
            return new SkyFov(lonLat[0], lonLat[1], radiusDeg);
        }
        return null;
    }

    public Projecter getSkyviewProjecter() {
        return this.projecter_;
    }

    public static SkyviewProjection createProjection(Projecter projecter, boolean isContinuous) {
        return SkyviewProjection.createProjection(projecter, isContinuous, projecter.getName(), projecter.getDescription());
    }

    private static SkyviewProjection createProjection(Projecter projecter, boolean isContinuous, final String name, final String descrip) {
        return new SkyviewProjection(projecter, SkyviewProjection.getShape(projecter), isContinuous){

            @Override
            public String getProjectionName() {
                return name;
            }

            @Override
            public String getProjectionDescription() {
                return descrip;
            }
        };
    }

    private static Shape getShape(Projecter projecter) {
        double S2 = Math.sqrt(2.0);
        double PI = Math.PI;
        Class<?> clazz = projecter.getClass();
        if (clazz.equals(Ait.class)) {
            return new Ellipse2D.Double(-2.0 * S2, -S2, 4.0 * S2, 2.0 * S2);
        }
        if (clazz.equals(Arc.class)) {
            return new Ellipse2D.Double(-Math.PI, -Math.PI, Math.PI * 2, Math.PI * 2);
        }
        if (clazz.equals(Car1.class)) {
            return new Rectangle2D.Double(-Math.PI, -1.5707963267948966, Math.PI * 2, Math.PI);
        }
        if (clazz.equals(Stg.class)) {
            return new Ellipse2D.Double(-2.0, -2.0, 4.0, 4.0);
        }
        if (clazz.equals(Tan.class)) {
            return null;
        }
        throw new IllegalArgumentException("Don't know shape for projection");
    }

    private static class Car1
    extends Projecter {
        final Car base_ = new Car();

        Car1() {
        }

        public String getName() {
            return this.base_.getName();
        }

        public String getDescription() {
            return this.base_.getDescription();
        }

        public Deprojecter inverse() {
            return this.base_.inverse();
        }

        public double getXTiling() {
            return 0.0;
        }

        public double getYTiling() {
            return 0.0;
        }

        public boolean isInverse(Transformer t) {
            return this.base_.isInverse(t);
        }

        public void transform(double[] sphere, double[] plane) {
            this.base_.transform(sphere, plane);
        }

        public boolean allValid() {
            return false;
        }

        public boolean validPosition(double[] pos) {
            double x = pos[0];
            double y = pos[1];
            return x >= -Math.PI && x <= Math.PI && y >= -1.5707963267948966 && y <= 1.5707963267948966;
        }
    }
}

