/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.Tuple;

public class SliceDataGeom
implements DataGeom {
    private final int dataDimCount_;
    private final FloatingCoord[] sliceCoords_;
    private final boolean[] sliceFlags_;
    private final Coord[] posCoords_;
    private final String variantName_;

    public SliceDataGeom(FloatingCoord[] sliceCoords, String variantName) {
        this.sliceCoords_ = sliceCoords;
        this.dataDimCount_ = sliceCoords.length;
        this.sliceFlags_ = new boolean[this.dataDimCount_];
        ArrayList<FloatingCoord> posCoordList = new ArrayList<FloatingCoord>();
        for (int i = 0; i < this.dataDimCount_; ++i) {
            FloatingCoord coord = sliceCoords[i];
            if (coord == null) continue;
            posCoordList.add(coord);
            this.sliceFlags_[i] = true;
        }
        this.posCoords_ = posCoordList.toArray(new Coord[0]);
        this.variantName_ = variantName;
    }

    @Override
    public int getDataDimCount() {
        return this.dataDimCount_;
    }

    @Override
    public boolean hasPosition() {
        return false;
    }

    @Override
    public String getVariantName() {
        return this.variantName_;
    }

    @Override
    public Coord[] getPosCoords() {
        return this.posCoords_;
    }

    @Override
    public boolean readDataPos(Tuple tuple, int ic, double[] dpos) {
        for (int i = 0; i < this.dataDimCount_; ++i) {
            if (this.sliceFlags_[i]) {
                double d;
                if (Double.isNaN(d = this.sliceCoords_[i].readDoubleCoord(tuple, ic++))) {
                    return false;
                }
                dpos[i] = d;
                continue;
            }
            dpos[i] = Double.NaN;
        }
        return true;
    }

    public int hashCode() {
        int code = 771;
        code = 23 * code + Arrays.hashCode(this.sliceCoords_);
        code = 23 * code + this.variantName_.hashCode();
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof SliceDataGeom) {
            SliceDataGeom other = (SliceDataGeom)o;
            return Arrays.equals(this.sliceCoords_, other.sliceCoords_) && this.variantName_.equals(other.variantName_);
        }
        return false;
    }
}

