/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotType;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.CubeSurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.SphereDataGeom;
import uk.ac.starlink.ttools.plot2.layer.ContourPlotter;
import uk.ac.starlink.ttools.plot2.layer.LabelPlotter;
import uk.ac.starlink.ttools.plot2.layer.MarkForm;
import uk.ac.starlink.ttools.plot2.layer.PairLinkForm;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapeMode;
import uk.ac.starlink.ttools.plot2.layer.ShapePlotter;
import uk.ac.starlink.ttools.plot2.layer.SizeForm;
import uk.ac.starlink.ttools.plot2.layer.SizeXyForm;
import uk.ac.starlink.ttools.plot2.paper.PaperTypeSelector;

public class SpherePlotType
implements PlotType {
    private static final SurfaceFactory SURFACE_FACTORY = new CubeSurfaceFactory(true);
    private static final SpherePlotType INSTANCE = new SpherePlotType();
    private final DataGeom[] dataGeoms_ = new DataGeom[]{SphereDataGeom.INSTANCE};

    private SpherePlotType() {
    }

    @Override
    public DataGeom[] getPointDataGeoms() {
        return this.dataGeoms_;
    }

    @Override
    public Plotter[] getPlotters() {
        ArrayList<Plotter> list = new ArrayList<Plotter>();
        ShapeForm[] forms = new ShapeForm[]{MarkForm.SINGLE, SizeForm.getInstance(), SizeXyForm.getInstance(), PairLinkForm.getInstance(), MarkForm.PAIR};
        ShapePlotter.ShapeModePlotter[] shapePlotters = ShapePlotter.createShapePlotters(forms, ShapeMode.MODES_3D);
        list.addAll(Arrays.asList(shapePlotters));
        list.addAll(Arrays.asList(new LabelPlotter(), new ContourPlotter()));
        return list.toArray(new Plotter[0]);
    }

    @Override
    public SurfaceFactory getSurfaceFactory() {
        return SURFACE_FACTORY;
    }

    @Override
    public PaperTypeSelector getPaperTypeSelector() {
        return PaperTypeSelector.SELECTOR_3D;
    }

    public String toString() {
        return "sphere";
    }

    public static SpherePlotType getInstance() {
        return INSTANCE;
    }
}

