/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Point;
import java.awt.Rectangle;
import uk.ac.starlink.ttools.plot2.Gang;
import uk.ac.starlink.ttools.plot2.Ganger;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.PlotPlacement;
import uk.ac.starlink.ttools.plot2.ShadeAxis;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.ZoneContent;

public abstract class StackGanger<P, A>
implements Ganger<P, A> {
    private final boolean isUp_;
    private final Padding padding_;

    protected StackGanger(boolean isUp, Padding padding) {
        this.isUp_ = isUp;
        this.padding_ = padding;
    }

    public abstract double[] getXLimits(A var1);

    public abstract A fixXLimits(A var1, double var2, double var4);

    @Override
    public Gang createGang(Rectangle[] zonePlotBounds) {
        if (zonePlotBounds.length > 0) {
            return new StackGang(zonePlotBounds);
        }
        throw new IllegalArgumentException("no regions");
    }

    @Override
    public Gang createGang(Rectangle gangExtBox, SurfaceFactory<P, A> surfFact, int nz, ZoneContent[] contents, P[] profiles, A[] aspects, ShadeAxis[] shadeAxes, boolean withScroll) {
        int iz;
        if (nz == 0) {
            throw new IllegalArgumentException("no zones");
        }
        int[] heights = new int[nz];
        for (int iz2 = 0; iz2 < nz; ++iz2) {
            heights[iz2] = gangExtBox.height / nz + (iz2 < gangExtBox.height % nz ? 1 : 0);
        }
        Rectangle[] zboxes = new Rectangle[nz];
        int y = 0;
        for (int iz3 = 0; iz3 < nz; ++iz3) {
            int h = heights[iz3];
            Rectangle zoneExtBox = new Rectangle(gangExtBox.x, this.isUp_ ? gangExtBox.height - y - h : y, gangExtBox.width, h);
            y += h;
            ZoneContent content = contents[iz3];
            zboxes[iz3] = PlotPlacement.calculateDataBounds(zoneExtBox, this.padding_, surfFact, profiles[iz3], aspects[iz3], withScroll, content.getLegend(), content.getLegendPosition(), content.getTitle(), shadeAxes[iz3]);
        }
        assert (y == gangExtBox.height) : y + " !=" + gangExtBox.height;
        int maxxlo = zboxes[0].x;
        int minxhi = zboxes[0].x + zboxes[0].width;
        for (iz = 1; iz < nz; ++iz) {
            maxxlo = Math.max(maxxlo, zboxes[iz].x);
            minxhi = Math.min(minxhi, zboxes[iz].x + zboxes[iz].width);
        }
        for (iz = 0; iz < nz; ++iz) {
            zboxes[iz].x = maxxlo;
            zboxes[iz].width = Math.max(minxhi - maxxlo, 10);
        }
        return new StackGang(zboxes);
    }

    @Override
    public Gang createApproxGang(Rectangle extBounds, int nz) {
        int h = extBounds.height / nz;
        Rectangle[] boxes = new Rectangle[nz];
        for (int iz = 0; iz < nz; ++iz) {
            boxes[iz] = new Rectangle(extBounds.x, extBounds.y + h * (this.isUp_ ? nz - 1 - iz : iz), extBounds.width, h);
        }
        return new StackGang(boxes);
    }

    @Override
    public A[] adjustAspects(A[] aspects, int index) {
        double[] xlimits;
        if (index >= 0) {
            xlimits = this.getXLimits(aspects[index]);
        } else {
            double[] dArray;
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            for (A aspect : aspects) {
                double[] lims = this.getXLimits(aspect);
                min = Math.min(min, lims[0]);
                max = Math.max(max, lims[1]);
            }
            if (min < max) {
                double[] dArray2 = new double[2];
                dArray2[0] = min;
                dArray = dArray2;
                dArray2[1] = max;
            } else {
                dArray = xlimits = null;
            }
        }
        if (xlimits != null) {
            Object[] newAspects = (Object[])aspects.clone();
            for (int iz = 0; iz < aspects.length; ++iz) {
                newAspects[iz] = this.fixXLimits(aspects[iz], xlimits[0], xlimits[1]);
            }
            return newAspects;
        }
        return aspects;
    }

    @Override
    public P[] adjustProfiles(P[] profiles) {
        return profiles;
    }

    private static class StackGang
    implements Gang {
        private final Rectangle[] zoneBoxes_;

        StackGang(Rectangle[] zoneBoxes) {
            this.zoneBoxes_ = zoneBoxes;
        }

        @Override
        public int getZoneCount() {
            return this.zoneBoxes_.length;
        }

        @Override
        public Rectangle getZonePlotBounds(int iz) {
            return new Rectangle(this.zoneBoxes_[iz]);
        }

        @Override
        public int getNavigationZoneIndex(Point pos) {
            int y = pos.y;
            int minDist = Integer.MAX_VALUE;
            int izClosest = -1;
            for (int iz = 0; iz < this.zoneBoxes_.length; ++iz) {
                Rectangle box = this.zoneBoxes_[iz];
                int ylo = box.y;
                int yhi = box.y + box.height;
                if (y >= ylo && y < yhi) {
                    return iz;
                }
                int ydist = Math.min(Math.abs(y - ylo), Math.abs(y - yhi));
                if (ydist >= minDist) continue;
                minDist = ydist;
                izClosest = iz;
            }
            return izClosest;
        }
    }
}

