/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.LinkedHashMap;
import uk.ac.starlink.ttools.plot2.Anchor;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.geom.AxisAnnotation;
import uk.ac.starlink.ttools.plot2.geom.GridLiner;
import uk.ac.starlink.ttools.plot2.geom.SkyAxisLabeller;

public abstract class TickSkyAxisLabeller
implements SkyAxisLabeller {
    private final String name_;
    private final String description_;
    public static Anchor X_ANCHOR = Anchor.N;
    public static Anchor Y_ANCHOR = Anchor.E;

    public TickSkyAxisLabeller(String name, String description) {
        this.name_ = name;
        this.description_ = description;
    }

    @Override
    public String getLabellerName() {
        return this.name_;
    }

    @Override
    public String getLabellerDescription() {
        return this.description_;
    }

    @Override
    public AxisAnnotation createAxisAnnotation(GridLiner gridLiner, Captioner captioner) {
        SkyTick[] ticks = this.calculateTicks(gridLiner.getLines(), gridLiner.getLabels(), gridLiner.getBounds());
        ticks = this.removeOverlaps(ticks, captioner);
        return new TickAxisAnnotation(ticks, gridLiner.getBounds(), captioner);
    }

    protected abstract SkyTick[] calculateTicks(double[][][] var1, String[] var2, Rectangle var3);

    protected SkyTick[] removeOverlaps(SkyTick[] ticks, Captioner captioner) {
        LinkedHashMap<SkyTick, Rectangle> tickMap = new LinkedHashMap<SkyTick, Rectangle>();
        for (int it = 0; it < ticks.length; ++it) {
            SkyTick tick1 = ticks[it];
            Rectangle box1 = tick1.getCaptionBounds(captioner);
            Iterator tit = tickMap.keySet().iterator();
            while (tit.hasNext() && tick1 != null) {
                SkyTick tick0 = (SkyTick)tit.next();
                Rectangle box0 = tick0.getCaptionBounds(captioner);
                if (!box0.intersects(box1)) continue;
                tick1 = null;
            }
            if (tick1 == null) continue;
            tickMap.put(tick1, box1);
        }
        return tickMap.keySet().toArray(new SkyTick[0]);
    }

    public static SkyTick createExternalTick(String label, double[][] line, Rectangle bounds) {
        for (int is = 0; is < line.length; ++is) {
            double theta;
            double[] seg = line[is];
            double px = seg[0];
            double py = seg[1];
            int iseg1 = is == 0 ? 1 : is;
            int iseg0 = iseg1 - 1;
            assert (iseg0 >= 0);
            if (iseg1 < line.length) {
                double dx = line[iseg1][0] - line[iseg0][0];
                double dy = line[iseg1][1] - line[iseg0][1];
                theta = Math.atan2(dy, dx);
            } else {
                theta = Double.NaN;
            }
            double upness = 1.0 - Math.abs(1.0 - Math.abs(2.0 * theta / Math.PI));
            assert (upness >= 0.0 && upness <= 1.0);
            if (Math.abs(py - (double)bounds.y - (double)bounds.height) < 0.5 && upness >= 0.5) {
                return new SkyTick(label, (int)Math.round(px), bounds.y + bounds.height, X_ANCHOR);
            }
            if (!(Math.abs(px - (double)bounds.x) < 0.5) || !(upness <= 0.5)) continue;
            return new SkyTick(label, bounds.x, (int)Math.round(py), Y_ANCHOR);
        }
        return null;
    }

    public static SkyTick createInternalTick(String label, double[][] line) {
        int nseg = line.length;
        double[] dists = new double[nseg];
        for (int is1 = 1; is1 < nseg; ++is1) {
            int is0 = is1 - 1;
            double[] seg0 = line[is0];
            double[] seg1 = line[is1];
            double segleng = Math.hypot(seg1[0] - seg0[0], seg1[1] - seg0[1]);
            dists[is1] = dists[is0] + segleng;
        }
        double halfway = 0.5 * dists[nseg - 1];
        int iseg0 = -1;
        double segfrac = Double.NaN;
        for (int is1 = 1; is1 < nseg && iseg0 < 0; ++is1) {
            int is0 = is1 - 1;
            double d0 = dists[is0];
            double d1 = dists[is1];
            if (!(d1 >= halfway)) continue;
            iseg0 = is0;
            segfrac = d1 == d0 ? 0.0 : (halfway - d0) / (d1 - d0);
        }
        assert (iseg0 >= 0 && iseg0 < nseg - 1 && segfrac >= 0.0 && segfrac <= 1.0);
        int iseg1 = iseg0 + 1;
        double x0 = line[iseg0][0];
        double y0 = line[iseg0][1];
        double x1 = line[iseg1][0];
        double y1 = line[iseg1][1];
        double dx = x1 - x0;
        double dy = y1 - y0;
        int px = (int)Math.round(x0 + segfrac * dx);
        int py = (int)Math.round(y0 + segfrac * dy);
        double theta = Math.atan2(dy, dx);
        if (theta > 1.5707963267948966) {
            theta -= Math.PI;
        } else if (theta < -1.5707963267948966) {
            theta += Math.PI;
        }
        Anchor.HorizontalAnchor onAnchor = new Anchor.HorizontalAnchor(){

            @Override
            protected int[] getOffset(Rectangle bounds, int pad) {
                return new int[]{-bounds.width / 2, -2};
            }
        };
        Anchor anchor = Anchor.createAngledAnchor(theta, onAnchor);
        return new SkyTick(label, px, py, anchor);
    }

    public static class SkyTick {
        private final String label_;
        private final int px_;
        private final int py_;
        private final Anchor anchor_;

        public SkyTick(String label, int px, int py, Anchor anchor) {
            this.label_ = label;
            this.px_ = px;
            this.py_ = py;
            this.anchor_ = anchor;
        }

        private Rectangle getCaptionBounds(Captioner captioner) {
            return this.getCaptionBoundsAt(this.px_, this.py_, captioner);
        }

        private Rectangle getCaptionBoundsAt(int px, int py, Captioner captioner) {
            return this.anchor_.getCaptionBounds(this.label_, px, py, captioner);
        }
    }

    private static class TickAxisAnnotation
    implements AxisAnnotation {
        private final SkyTick[] ticks_;
        private final Rectangle plotBounds_;
        private final Captioner captioner_;

        TickAxisAnnotation(SkyTick[] ticks, Rectangle plotBounds, Captioner captioner) {
            this.ticks_ = ticks;
            this.plotBounds_ = plotBounds;
            this.captioner_ = captioner;
        }

        @Override
        public Insets getPadding(boolean withScroll) {
            Rectangle bounds = new Rectangle(this.plotBounds_);
            for (int i = 0; i < this.ticks_.length; ++i) {
                SkyTick tick = this.ticks_[i];
                if (withScroll) {
                    this.extendScrollBounds(bounds, tick);
                    continue;
                }
                this.extendBounds(bounds, tick);
            }
            int top = this.plotBounds_.y - bounds.y;
            int left = this.plotBounds_.x - bounds.x;
            int bottom = bounds.y + bounds.height - this.plotBounds_.y - this.plotBounds_.height;
            int right = bounds.x + bounds.width - this.plotBounds_.x - this.plotBounds_.width;
            assert (top >= 0 && left >= 0 && bottom >= 0 && right >= 0);
            return new Insets(top, left, bottom, right);
        }

        @Override
        public void drawLabels(Graphics g) {
            for (int i = 0; i < this.ticks_.length; ++i) {
                SkyTick tick = this.ticks_[i];
                tick.anchor_.drawCaption(tick.label_, tick.px_, tick.py_, this.captioner_, g);
            }
        }

        private void extendBounds(Rectangle bounds, SkyTick tick) {
            bounds.add(tick.getCaptionBounds(this.captioner_));
        }

        private void extendScrollBounds(Rectangle bounds, SkyTick tick) {
            Point[] points;
            Rectangle box = this.plotBounds_;
            Anchor anchor = tick.anchor_;
            if (anchor == X_ANCHOR) {
                int py = box.y + box.height;
                points = new Point[]{new Point(box.x, py), new Point(box.x + box.width, py)};
            } else if (anchor == Y_ANCHOR) {
                int px = box.x;
                points = new Point[]{new Point(px, box.y), new Point(px, box.y + box.height)};
            } else {
                points = new Point[]{};
            }
            for (int ip = 0; ip < points.length; ++ip) {
                Point p = points[ip];
                bounds.add(tick.getCaptionBoundsAt(p.x, p.y, this.captioner_));
            }
        }
    }
}

