/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.ac.starlink.ttools.plot2.Decoration;
import uk.ac.starlink.ttools.plot2.Gesture;
import uk.ac.starlink.ttools.plot2.NavAction;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.CombinationConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.geom.BandDecoration;
import uk.ac.starlink.ttools.plot2.geom.NavDecorations;
import uk.ac.starlink.ttools.plot2.geom.PlaneNavigator;
import uk.ac.starlink.ttools.plot2.geom.TimeAspect;
import uk.ac.starlink.ttools.plot2.geom.TimeSurface;

public class TimeNavigator
implements Navigator<TimeAspect> {
    private final double zoomFactor_;
    private final boolean tZoom_;
    private final boolean yZoom_;
    private final boolean tPan_;
    private final boolean yPan_;
    public static final ConfigKey<boolean[]> NAVAXES_KEY = TimeNavigator.createNavAxesKey();

    public TimeNavigator(double zoomFactor, boolean tZoom, boolean yZoom, boolean tPan, boolean yPan) {
        this.zoomFactor_ = zoomFactor;
        this.tZoom_ = tZoom;
        this.yZoom_ = yZoom;
        this.tPan_ = tPan;
        this.yPan_ = yPan;
    }

    @Override
    public NavAction<TimeAspect> drag(Surface surface, Point point, int ibutt, Point origin) {
        boolean[] useFlags = PlaneNavigator.getAxisNavFlags(surface, origin, this.tPan_, this.yPan_);
        TimeSurface tsurf = (TimeSurface)surface;
        boolean tUse = useFlags[0];
        boolean yUse = useFlags[1];
        Rectangle plotBounds = surface.getPlotBounds();
        if (ibutt == 3) {
            double tf = tUse ? PlotUtil.toZoom(this.zoomFactor_, origin, point, false) : 1.0;
            double yf = yUse ? PlotUtil.toZoom(this.zoomFactor_, origin, point, true) : 1.0;
            TimeAspect aspect = tsurf.zoom(origin, tf, yf);
            Decoration dec = NavDecorations.createDragDecoration(origin, tf, yf, tUse, yUse, plotBounds);
            return new NavAction<TimeAspect>(aspect, dec);
        }
        if (ibutt == 2) {
            BandDecoration dec = NavDecorations.createBandDecoration(origin, point, tUse, yUse, plotBounds);
            return new NavAction<Object>(null, dec);
        }
        TimeAspect aspect = tsurf.pan(origin, point, tUse, yUse);
        return new NavAction<TimeAspect>(aspect, null);
    }

    @Override
    public NavAction<TimeAspect> endDrag(Surface surface, Point pos, int ibutt, Point origin) {
        if (ibutt == 2) {
            boolean[] useFlags = PlaneNavigator.getAxisNavFlags(surface, origin, this.tPan_, this.yPan_);
            TimeSurface tsurf = (TimeSurface)surface;
            boolean tUse = useFlags[0];
            boolean yUse = useFlags[1];
            Rectangle plotBounds = surface.getPlotBounds();
            BandDecoration dec = NavDecorations.createBandDecoration(origin, pos, tUse, yUse, plotBounds);
            if (dec != null) {
                TimeAspect aspect = tsurf.reframe(dec.getTargetRectangle());
                return new NavAction<TimeAspect>(aspect, null);
            }
            return null;
        }
        return null;
    }

    @Override
    public NavAction<TimeAspect> wheel(Surface surface, Point pos, int wheelrot) {
        boolean[] useFlags = PlaneNavigator.getAxisNavFlags(surface, pos, this.tZoom_, this.yZoom_);
        double zfact = PlotUtil.toZoom(this.zoomFactor_, wheelrot);
        double tf = useFlags[0] ? zfact : 1.0;
        double yf = useFlags[1] ? zfact : 1.0;
        TimeAspect aspect = ((TimeSurface)surface).zoom(pos, tf, yf);
        Decoration dec = NavDecorations.createWheelDecoration(pos, tf, yf, useFlags[0], useFlags[1], surface.getPlotBounds());
        return new NavAction<TimeAspect>(aspect, dec);
    }

    @Override
    public NavAction<TimeAspect> click(Surface surface, Point pos, int ibutt, Iterable<double[]> dposIt) {
        return null;
    }

    @Override
    public Map<Gesture, String> getNavOptions(Surface surface, Point pos) {
        boolean[] useFlags = PlaneNavigator.getAxisNavFlags(surface, pos, this.tZoom_, this.yZoom_);
        return TimeNavigator.getNavOptions(useFlags[0], useFlags[1]);
    }

    public static Map<Gesture, String> getNavOptions(boolean tUse, boolean yUse) {
        String isoTxt;
        String freeTxt;
        if (tUse && yUse) {
            freeTxt = "t/Y";
            isoTxt = "Iso";
        } else {
            freeTxt = tUse ? "t  " : (yUse ? "Y  " : "   ");
            isoTxt = freeTxt;
        }
        LinkedHashMap<Gesture, String> map = new LinkedHashMap<Gesture, String>();
        map.put(Gesture.DRAG_1, "Pan " + freeTxt);
        map.put(Gesture.DRAG_3, "Stretch " + freeTxt);
        map.put(Gesture.DRAG_2, "Frame " + freeTxt);
        map.put(Gesture.WHEEL, "Zoom " + isoTxt);
        return map;
    }

    public static ConfigKey[] getConfigKeys() {
        return new ConfigKey[]{NAVAXES_KEY, StyleKeys.ZOOM_FACTOR};
    }

    public static TimeNavigator createNavigator(ConfigMap config) {
        boolean[] navFlags = config.get(NAVAXES_KEY);
        boolean tnav = navFlags[0];
        boolean ynav = navFlags[1];
        double zoom = config.get(StyleKeys.ZOOM_FACTOR);
        return new TimeNavigator(zoom, tnav, ynav, tnav, ynav);
    }

    private static CombinationConfigKey createNavAxesKey() {
        ConfigMeta meta = new ConfigMeta("navaxes", "Pan/Zoom Axes");
        meta.setStringUsage("t|y|ty");
        meta.setShortDescription("Axes affected by pan/zoom");
        meta.setXmlDescription(new String[]{"<p>Determines the axes which are affected by", "the interactive navigation actions (pan and zoom).", "The default is <code>t</code>", "which means that the various mouse gestures", "will provide panning and zooming in the Time direction only.", "However, if it is set to <code>ty</code>", "mouse actions will affect both the horizontal and vertical", "axes.", "</p>"});
        CombinationConfigKey key = new CombinationConfigKey(meta, new boolean[]{true, false}, new String[]{"Time", "Y"}, null){

            @Override
            public int optCharToIndex(char c) throws ConfigException {
                return Character.toLowerCase(c) == 'x' ? 0 : super.optCharToIndex(c);
            }
        };
        return key;
    }
}

