/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import uk.ac.starlink.ttools.plot2.Ganger;
import uk.ac.starlink.ttools.plot2.GangerFactory;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.geom.StackGanger;
import uk.ac.starlink.ttools.plot2.geom.TimeAspect;
import uk.ac.starlink.ttools.plot2.geom.TimeSurfaceFactory;

public class TimeStackGanger
extends StackGanger<TimeSurfaceFactory.Profile, TimeAspect> {
    private static final boolean UP = false;
    public static final GangerFactory FACTORY = new GangerFactory(){

        @Override
        public boolean isMultiZone() {
            return true;
        }

        public Ganger createGanger(Padding padding) {
            return new TimeStackGanger(padding);
        }
    };

    public TimeStackGanger(Padding padding) {
        super(false, padding);
    }

    @Override
    public double[] getXLimits(TimeAspect aspect) {
        return new double[]{aspect.getTMin(), aspect.getTMax()};
    }

    @Override
    public TimeAspect fixXLimits(TimeAspect aspect, double xmin, double xmax) {
        return new TimeAspect(new double[]{xmin, xmax}, new double[]{aspect.getYMin(), aspect.getYMax()});
    }

    public TimeSurfaceFactory.Profile[] adjustProfiles(TimeSurfaceFactory.Profile[] profiles) {
        profiles = (TimeSurfaceFactory.Profile[])profiles.clone();
        for (int i = 0; i < profiles.length; ++i) {
            if (i >= profiles.length - 1) continue;
            profiles[i] = profiles[i].fixTimeAnnotation(false);
        }
        return profiles;
    }
}

