/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Arrays;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.BasicTicker;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.Tick;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.geom.AxisAnnotation;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.geom.PlaneAxisAnnotation;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurface;
import uk.ac.starlink.ttools.plot2.geom.TimeAspect;
import uk.ac.starlink.ttools.plot2.geom.TimeFormat;
import uk.ac.starlink.ttools.plot2.geom.TimeSurfaceFactory;

public class TimeSurface
implements Surface,
PlanarSurface {
    private final int gxlo_;
    private final int gxhi_;
    private final int gylo_;
    private final int gyhi_;
    private final double dtlo_;
    private final double dthi_;
    private final double dylo_;
    private final double dyhi_;
    private final boolean ylog_;
    private final boolean yflip_;
    private final Tick[] tticks_;
    private final Tick[] yticks_;
    private final String tlabel_;
    private final String ylabel_;
    private final Captioner captioner_;
    private final boolean grid_;
    private final TimeFormat tformat_;
    private final boolean tannotate_;
    private final Axis tAxis_;
    private final Axis yAxis_;
    private static final boolean INVERT_Y = true;

    public TimeSurface(int gxlo, int gxhi, int gylo, int gyhi, double dtlo, double dthi, double dylo, double dyhi, boolean ylog, boolean yflip, Tick[] tticks, Tick[] yticks, String tlabel, String ylabel, Captioner captioner, boolean grid, TimeFormat tformat, boolean tannotate) {
        this.gxlo_ = gxlo;
        this.gxhi_ = gxhi;
        this.gylo_ = gylo;
        this.gyhi_ = gyhi;
        this.dtlo_ = dtlo;
        this.dthi_ = dthi;
        this.dylo_ = dylo;
        this.dyhi_ = dyhi;
        this.ylog_ = ylog;
        this.yflip_ = yflip;
        this.tticks_ = tticks;
        this.yticks_ = yticks;
        this.tlabel_ = tlabel;
        this.ylabel_ = ylabel;
        this.captioner_ = captioner;
        this.grid_ = grid;
        this.tformat_ = tformat;
        this.tannotate_ = tannotate;
        this.tAxis_ = Axis.createAxis(this.gxlo_, this.gxhi_, this.dtlo_, this.dthi_, false, false);
        this.yAxis_ = Axis.createAxis(this.gylo_, this.gyhi_, this.dylo_, this.dyhi_, this.ylog_, this.yflip_ ^ true);
        assert (this.equals(this));
    }

    @Override
    public Rectangle getPlotBounds() {
        return new Rectangle(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
    }

    @Override
    public Insets getPlotInsets(boolean withScroll) {
        return this.createAxisAnnotation().getPadding(withScroll);
    }

    @Override
    public int getDataDimCount() {
        return 2;
    }

    @Override
    public boolean dataToGraphics(double[] dpos, boolean visibleOnly, Point2D.Double gp) {
        double gx = this.tAxis_.dataToGraphics(dpos[0]);
        double gy = this.yAxis_.dataToGraphics(dpos[1]);
        if (!visibleOnly || gx >= (double)this.gxlo_ && gx < (double)this.gxhi_ && gy >= (double)this.gylo_ && gy < (double)this.gyhi_) {
            gp.x = gx;
            gp.y = gy;
            return true;
        }
        return false;
    }

    @Override
    public boolean dataToGraphicsOffset(double[] dpos0, Point2D.Double gpos0, double[] dpos1, boolean visibleOnly, Point2D.Double gpos1) {
        return this.dataToGraphics(dpos1, visibleOnly, gpos1);
    }

    @Override
    public double[] graphicsToData(Point2D gp, Iterable<double[]> dposIt) {
        return new double[]{this.tAxis_.graphicsToData(gp.getX()), this.yAxis_.graphicsToData(gp.getY())};
    }

    @Override
    public String formatPosition(double[] dpos) {
        double timePixelSize = (this.dthi_ - this.dtlo_) / (double)(this.gxhi_ - this.gxlo_);
        return this.tformat_.formatTime(dpos[0], timePixelSize) + ", " + PlaneSurface.formatPosition(this.yAxis_, dpos[1]);
    }

    @Override
    public void paintBackground(Graphics g) {
        Color color0 = g.getColor();
        g.setColor(Color.WHITE);
        g.fillRect(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
        if (this.grid_) {
            Tick tick;
            int it;
            g.setColor(Color.LIGHT_GRAY);
            for (it = 0; it < this.tticks_.length; ++it) {
                tick = this.tticks_[it];
                if (tick.getLabel() == null) continue;
                int gx = (int)this.tAxis_.dataToGraphics(tick.getValue());
                g.drawLine(gx, this.gylo_, gx, this.gyhi_);
            }
            for (it = 0; it < this.yticks_.length; ++it) {
                tick = this.yticks_[it];
                if (tick.getLabel() == null) continue;
                int gy = (int)this.yAxis_.dataToGraphics(tick.getValue());
                g.drawLine(this.gxlo_, gy, this.gxhi_, gy);
            }
        }
        g.setColor(color0);
    }

    @Override
    public void paintForeground(Graphics g) {
        Color color0 = g.getColor();
        g.setColor(Color.BLACK);
        this.createAxisAnnotation().drawLabels(g);
        g.drawRect(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
        g.setColor(color0);
    }

    @Override
    public Captioner getCaptioner() {
        return this.captioner_;
    }

    @Override
    public boolean[] getLogFlags() {
        return new boolean[]{false, this.ylog_};
    }

    @Override
    public boolean[] getFlipFlags() {
        return new boolean[]{false, this.yflip_};
    }

    @Override
    public boolean[] getTimeFlags() {
        return new boolean[]{true, false};
    }

    @Override
    public double[][] getDataLimits() {
        return new double[][]{{this.dtlo_, this.dthi_}, {this.dylo_, this.dyhi_}};
    }

    @Override
    public Axis[] getAxes() {
        return new Axis[]{this.tAxis_, this.yAxis_};
    }

    ConfigMap getAspectConfig() {
        ConfigMap config = new ConfigMap();
        double timeEpsilon = 0.1 * (this.dthi_ - this.dtlo_) / (double)(this.gxhi_ - this.gxlo_);
        TimeFormat tfmt = this.dthi_ - this.dtlo_ > 3.1536E7 ? TimeFormat.DECIMAL_YEAR : TimeFormat.ISO8601;
        config.put(TimeSurfaceFactory.TMIN_KEY, new Double(TimeSurface.roundTime(this.dtlo_, tfmt, timeEpsilon)));
        config.put(TimeSurfaceFactory.TMAX_KEY, new Double(TimeSurface.roundTime(this.dthi_, tfmt, timeEpsilon)));
        config.putAll(PlotUtil.configLimits(TimeSurfaceFactory.YMIN_KEY, TimeSurfaceFactory.YMAX_KEY, this.dylo_, this.dyhi_, this.gyhi_ - this.gylo_));
        return config;
    }

    TimeAspect zoom(Point2D pos, double tZoom, double yZoom) {
        return new TimeAspect(this.tAxis_.dataZoom(this.tAxis_.graphicsToData(pos.getX()), tZoom), this.yAxis_.dataZoom(this.yAxis_.graphicsToData(pos.getY()), yZoom));
    }

    TimeAspect pan(Point2D pos0, Point2D pos1, boolean tFlag, boolean yFlag) {
        if (tFlag || yFlag) {
            double[] dArray;
            double[] dArray2;
            if (tFlag) {
                dArray2 = this.tAxis_.dataPan(this.tAxis_.graphicsToData(pos0.getX()), this.tAxis_.graphicsToData(pos1.getX()));
            } else {
                double[] dArray3 = new double[2];
                dArray3[0] = this.dtlo_;
                dArray2 = dArray3;
                dArray3[1] = this.dthi_;
            }
            if (yFlag) {
                dArray = this.yAxis_.dataPan(this.yAxis_.graphicsToData(pos0.getY()), this.yAxis_.graphicsToData(pos1.getY()));
            } else {
                double[] dArray4 = new double[2];
                dArray4[0] = this.dylo_;
                dArray = dArray4;
                dArray4[1] = this.dyhi_;
            }
            return new TimeAspect(dArray2, dArray);
        }
        return null;
    }

    TimeAspect center(double[] dpos, boolean tFlag, boolean yFlag) {
        Point2D.Double gp = new Point2D.Double();
        return this.dataToGraphics(dpos, false, gp) && PlotUtil.isPointFinite(gp) ? this.pan(gp, new Point2D.Double((double)(this.gxlo_ + this.gxhi_) * 0.5, (double)(this.gylo_ + this.gyhi_) * 0.5), tFlag, yFlag) : null;
    }

    TimeAspect reframe(Rectangle frame) {
        Point gp1 = new Point(frame.x, frame.y);
        Point gp2 = new Point(frame.x + frame.width, frame.y + frame.height);
        double[] dpos1 = this.graphicsToData(gp1, null);
        double[] dpos2 = this.graphicsToData(gp2, null);
        return new TimeAspect(PlotUtil.orderPair(dpos1[0], dpos2[0]), PlotUtil.orderPair(dpos1[1], dpos2[1]));
    }

    private AxisAnnotation createAxisAnnotation() {
        return new PlaneAxisAnnotation(this.gxlo_, this.gxhi_, this.gylo_, this.gyhi_, this.tAxis_, this.yAxis_, this.tticks_, this.yticks_, this.tlabel_, this.ylabel_, this.captioner_, this.tannotate_, true);
    }

    public int hashCode() {
        int code = 943;
        code = 23 * code + this.gxlo_;
        code = 23 * code + this.gxhi_;
        code = 23 * code + this.gylo_;
        code = 23 * code + this.gyhi_;
        code = 23 * code + Float.floatToIntBits((float)this.dtlo_);
        code = 23 * code + Float.floatToIntBits((float)this.dthi_);
        code = 23 * code + Float.floatToIntBits((float)this.dylo_);
        code = 23 * code + Float.floatToIntBits((float)this.dyhi_);
        code = 23 * code + (this.ylog_ ? 1 : 3);
        code = 23 * code + (this.yflip_ ? 5 : 7);
        code = 23 * code + Arrays.hashCode(this.tticks_);
        code = 23 * code + Arrays.hashCode(this.yticks_);
        code = 23 * code + PlotUtil.hashCode(this.tlabel_);
        code = 23 * code + PlotUtil.hashCode(this.ylabel_);
        code = 23 * code + this.captioner_.hashCode();
        code = 23 * code + (this.grid_ ? 11 : 13);
        code = 23 * code + this.tformat_.hashCode();
        code = 23 * code + (this.tannotate_ ? 17 : 23);
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof TimeSurface) {
            TimeSurface other = (TimeSurface)o;
            return this.gxlo_ == other.gxlo_ && this.gxhi_ == other.gxhi_ && this.gylo_ == other.gylo_ && this.gyhi_ == other.gyhi_ && this.dtlo_ == other.dtlo_ && this.dthi_ == other.dthi_ && this.dylo_ == other.dylo_ && this.dyhi_ == other.dyhi_ && this.ylog_ == other.ylog_ && this.yflip_ == other.yflip_ && Arrays.equals(this.tticks_, other.tticks_) && Arrays.equals(this.yticks_, other.yticks_) && PlotUtil.equals(this.tlabel_, this.tlabel_) && PlotUtil.equals(this.ylabel_, other.ylabel_) && this.captioner_.equals(other.captioner_) && this.grid_ == other.grid_ && this.tformat_.equals(other.tformat_) && this.tannotate_ == other.tannotate_;
        }
        return false;
    }

    private static double roundTime(double tval, TimeFormat tfmt, double tepsilon) {
        try {
            return tfmt.parseTime(tfmt.formatTime(tval, tepsilon));
        }
        catch (RuntimeException e) {
            return tval;
        }
    }

    public static TimeSurface createSurface(Rectangle plotBounds, TimeAspect aspect, boolean ylog, boolean yflip, String tlabel, String ylabel, Captioner captioner, boolean grid, TimeFormat tformat, double tcrowd, double ycrowd, boolean minor, boolean tannotate) {
        int gxlo = plotBounds.x;
        int gxhi = plotBounds.x + plotBounds.width;
        int gylo = plotBounds.y;
        int gyhi = plotBounds.y + plotBounds.height;
        double dtlo = aspect.getTMin();
        double dthi = aspect.getTMax();
        double dylo = aspect.getYMin();
        double dyhi = aspect.getYMax();
        Tick[] tticks = tformat.getTicker().getTicks(aspect.getTMin(), aspect.getTMax(), minor, captioner, PlaneAxisAnnotation.X_ORIENT, plotBounds.width, tcrowd);
        Tick[] yticks = (ylog ? BasicTicker.LOG : BasicTicker.LINEAR).getTicks(dylo, dyhi, minor, captioner, PlaneAxisAnnotation.Y_ORIENT, plotBounds.height, ycrowd);
        return new TimeSurface(gxlo, gxhi, gylo, gyhi, dtlo, dthi, dylo, dyhi, ylog, yflip, tticks, yticks, tlabel, ylabel, captioner, grid, tformat, tannotate);
    }
}

