/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.config.BooleanConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.StringConfigKey;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.config.SubrangeConfigKey;
import uk.ac.starlink.ttools.plot2.config.TimeConfigKey;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.TimeAspect;
import uk.ac.starlink.ttools.plot2.geom.TimeFormat;
import uk.ac.starlink.ttools.plot2.geom.TimeNavigator;
import uk.ac.starlink.ttools.plot2.geom.TimeSurface;

public class TimeSurfaceFactory
implements SurfaceFactory<Profile, TimeAspect> {
    public static final ConfigKey<Double> TMIN_KEY = new TimeConfigKey(new ConfigMeta("tmin", "Time Minimum").setShortDescription("Lower limit on time axis").setXmlDescription(new String[]{"<p>Minimum value of the time coordinate plotted.", "This sets the value before any subranging is applied.", "If not supplied, the value is determined from the plotted", "data.", "</p>", TimeConfigKey.FORMAT_XML}));
    public static final ConfigKey<Double> TMAX_KEY = new TimeConfigKey(new ConfigMeta("tmax", "Time Maximum").setShortDescription("Upper limit on time axis").setXmlDescription(new String[]{"<p>Maximum value of the time coordinate plotted.", "This sets the value before any subranging is applied.", "If not supplied, the value is determined from the plotted", "data.", "</p>", TimeConfigKey.FORMAT_XML}));
    public static final ConfigKey<Subrange> TSUBRANGE_KEY = new SubrangeConfigKey(SubrangeConfigKey.createAxisSubMeta("t", "Time"));
    public static final ConfigKey<Double> YMIN_KEY = PlaneSurfaceFactory.YMIN_KEY;
    public static final ConfigKey<Double> YMAX_KEY = PlaneSurfaceFactory.YMAX_KEY;
    public static final ConfigKey<Subrange> YSUBRANGE_KEY = PlaneSurfaceFactory.YSUBRANGE_KEY;
    public static final ConfigKey<Boolean> YLOG_KEY = PlaneSurfaceFactory.YLOG_KEY;
    public static final ConfigKey<Boolean> YFLIP_KEY = PlaneSurfaceFactory.YFLIP_KEY;
    public static final ConfigKey<String> TLABEL_KEY = new StringConfigKey(new ConfigMeta("tlabel", "Time Label").setStringUsage("<text>").setShortDescription("Label for Time axis").setXmlDescription(new String[]{"<p>Gives a label to be used for annotating the Time axis.", "If not supplied no label will be drawn.", "</p>"}), null);
    public static final ConfigKey<String> YLABEL_KEY = PlaneSurfaceFactory.YLABEL_KEY;
    public static final ConfigKey<Boolean> GRID_KEY = new BooleanConfigKey(new ConfigMeta("grid", "Draw Grid").setShortDescription("Draw grid lines?").setXmlDescription(new String[]{"<p>If true, grid lines are drawn on the plot", "at positions determined by the major tick marks.", "If false, they are absent.", "</p>"}), false);
    public static final ConfigKey<Double> TCROWD_KEY = PlaneSurfaceFactory.createAxisCrowdKey("Time");
    public static final ConfigKey<Double> YCROWD_KEY = PlaneSurfaceFactory.YCROWD_KEY;
    public static final ConfigKey<TimeFormat> TFORMAT_KEY = TimeSurfaceFactory.createTimeFormatKey();

    @Override
    public Surface createSurface(Rectangle plotBounds, Profile profile, TimeAspect aspect) {
        Profile p = profile;
        return TimeSurface.createSurface(plotBounds, aspect, p.ylog_, p.yflip_, p.tlabel_, p.ylabel_, p.captioner_, p.grid_, p.tformat_, p.tcrowd_, p.ycrowd_, p.minor_, p.tannotate_);
    }

    @Override
    public ConfigKey[] getProfileKeys() {
        ArrayList<ConfigKey> list = new ArrayList<ConfigKey>();
        list.addAll(Arrays.asList(YLOG_KEY, YFLIP_KEY, TLABEL_KEY, YLABEL_KEY, GRID_KEY, TCROWD_KEY, YCROWD_KEY, TFORMAT_KEY, StyleKeys.MINOR_TICKS));
        list.addAll(Arrays.asList(StyleKeys.CAPTIONER.getKeys()));
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public Profile createProfile(ConfigMap config) {
        boolean ylog = config.get(YLOG_KEY);
        boolean yflip = config.get(YFLIP_KEY);
        String tlabel = config.get(TLABEL_KEY);
        String ylabel = config.get(YLABEL_KEY);
        boolean grid = config.get(GRID_KEY);
        double tcrowd = config.get(TCROWD_KEY);
        double ycrowd = config.get(YCROWD_KEY);
        TimeFormat tformat = config.get(TFORMAT_KEY);
        boolean minor = config.get(StyleKeys.MINOR_TICKS);
        Captioner captioner = StyleKeys.CAPTIONER.createValue(config);
        return new Profile(ylog, yflip, tlabel, ylabel, captioner, grid, tcrowd, ycrowd, tformat, minor, true);
    }

    @Override
    public ConfigKey[] getAspectKeys() {
        return new ConfigKey[]{TMIN_KEY, TMAX_KEY, TSUBRANGE_KEY, YMIN_KEY, YMAX_KEY, YSUBRANGE_KEY};
    }

    @Override
    public boolean useRanges(Profile profile, ConfigMap config) {
        return TimeSurfaceFactory.createUnrangedAspect(profile, config) == null;
    }

    @Override
    public TimeAspect createAspect(Profile profile, ConfigMap config, Range[] ranges) {
        TimeAspect unrangedAspect = TimeSurfaceFactory.createUnrangedAspect(profile, config);
        if (unrangedAspect != null) {
            return unrangedAspect;
        }
        Range trange = ranges == null ? new Range() : ranges[0];
        Range yrange = ranges == null ? new Range() : ranges[1];
        double[] tlimits = PlaneSurfaceFactory.getLimits(config, TMIN_KEY, TMAX_KEY, TSUBRANGE_KEY, false, trange);
        double[] ylimits = PlaneSurfaceFactory.getLimits(config, YMIN_KEY, YMAX_KEY, YSUBRANGE_KEY, profile.ylog_, yrange);
        return new TimeAspect(tlimits, ylimits);
    }

    @Override
    public ConfigMap getAspectConfig(Surface surf) {
        return surf instanceof TimeSurface ? ((TimeSurface)surf).getAspectConfig() : new ConfigMap();
    }

    @Override
    public Range[] readRanges(Profile profile, PlotLayer[] layers, DataStore dataStore) {
        boolean[] logFlags = new boolean[]{false, profile.getYLog()};
        return PlotUtil.readCoordinateRanges(layers, 2, logFlags, dataStore);
    }

    @Override
    public ConfigKey[] getNavigatorKeys() {
        return TimeNavigator.getConfigKeys();
    }

    @Override
    public Navigator<TimeAspect> createNavigator(ConfigMap navConfig) {
        return TimeNavigator.createNavigator(navConfig);
    }

    private static TimeAspect createUnrangedAspect(Profile profile, ConfigMap config) {
        double[] tlimits = PlaneSurfaceFactory.getLimits(config, TMIN_KEY, TMAX_KEY, TSUBRANGE_KEY, false, null);
        double[] ylimits = PlaneSurfaceFactory.getLimits(config, YMIN_KEY, YMAX_KEY, YSUBRANGE_KEY, profile.ylog_, null);
        return tlimits == null || ylimits == null ? null : new TimeAspect(tlimits, ylimits);
    }

    private static ConfigKey<TimeFormat> createTimeFormatKey() {
        TimeFormat[] formats = TimeFormat.getKnownFormats();
        ConfigMeta meta = new ConfigMeta("tformat", "Time Format");
        meta.setShortDescription("Time display format");
        meta.setXmlDescription(new String[]{"<p>Selects the way in which time values are represented", "when using them to label the time axis.", "</p>"});
        OptionConfigKey<TimeFormat> key = new OptionConfigKey<TimeFormat>(meta, TimeFormat.class, formats){
            private final double unixSec = 1.33161342E9;
            private final double secPrecision = 14400.0;

            @Override
            public String valueToString(TimeFormat format) {
                return format.getFormatName().toLowerCase();
            }

            @Override
            public String getXmlDescription(TimeFormat format) {
                return format.getFormatDescription() + " (e.g. \"" + format.formatTime(1.33161342E9, 14400.0) + "\")";
            }
        };
        key.setOptionUsage();
        key.addOptionsXml();
        return key;
    }

    public static class Profile {
        private final boolean ylog_;
        private final boolean yflip_;
        private final String tlabel_;
        private final String ylabel_;
        private final Captioner captioner_;
        private final boolean grid_;
        private final double tcrowd_;
        private final double ycrowd_;
        private final TimeFormat tformat_;
        private final boolean minor_;
        private final boolean tannotate_;

        public Profile(boolean ylog, boolean yflip, String tlabel, String ylabel, Captioner captioner, boolean grid, double tcrowd, double ycrowd, TimeFormat tformat, boolean minor, boolean tannotate) {
            this.ylog_ = ylog;
            this.yflip_ = yflip;
            this.tlabel_ = tlabel;
            this.ylabel_ = ylabel;
            this.captioner_ = captioner;
            this.grid_ = grid;
            this.tcrowd_ = tcrowd;
            this.ycrowd_ = ycrowd;
            this.tformat_ = tformat;
            this.minor_ = minor;
            this.tannotate_ = tannotate;
        }

        public boolean getYLog() {
            return this.ylog_;
        }

        public Profile fixTimeAnnotation(boolean tannotate) {
            return new Profile(this.ylog_, this.yflip_, this.tlabel_, this.ylabel_, this.captioner_, this.grid_, this.tcrowd_, this.ycrowd_, this.tformat_, this.minor_, tannotate);
        }
    }
}

