/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.layer.FillMode;
import uk.ac.starlink.ttools.plot2.layer.Kernel1d;
import uk.ac.starlink.ttools.plot2.layer.Kernel1dShape;
import uk.ac.starlink.ttools.plot2.layer.Normalisation;
import uk.ac.starlink.ttools.plot2.layer.Pixel1dPlotter;

public abstract class AbstractKernelDensityPlotter
extends Pixel1dPlotter<KDenseStyle> {
    public static final ReportKey<double[]> BINS_KEY = ReportKey.createUnprintableKey(new ReportMeta("bins", "Bins"), double[].class);
    public static final ConfigKey<Integer> THICK_KEY = StyleKeys.createThicknessKey(2);
    private final ConfigKey<Normalisation> normKey_;
    private static final int GUESS_PLOT_WIDTH = 300;

    protected AbstractKernelDensityPlotter(FloatingCoord xCoord, boolean hasWeight, ConfigKey<Normalisation> normKey, String name, Icon icon) {
        super(xCoord, hasWeight, name, icon);
        this.normKey_ = normKey;
    }

    protected abstract ConfigKey[] getKernelConfigKeys();

    protected abstract KernelFigure createKernelFigure(ConfigMap var1) throws ConfigException;

    @Override
    public ConfigKey[] getStyleKeys() {
        ArrayList<ConfigKey<Object>> list = new ArrayList<ConfigKey<Object>>();
        list.add(StyleKeys.COLOR);
        list.add(StyleKeys.TRANSPARENCY);
        list.addAll(Arrays.asList(this.getKernelConfigKeys()));
        list.add(KERNEL_KEY);
        list.add(StyleKeys.CUMULATIVE);
        list.add(this.normKey_);
        list.add(StyleKeys.FILL);
        list.add(THICK_KEY);
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public KDenseStyle createStyle(ConfigMap config) throws ConfigException {
        Color color = StyleKeys.getAlphaColor(config, StyleKeys.COLOR, StyleKeys.TRANSPARENCY);
        Kernel1dShape kernelShape = (Kernel1dShape)config.get(KERNEL_KEY);
        boolean isCumulative = config.get(StyleKeys.CUMULATIVE);
        Normalisation norm = config.get(this.normKey_);
        FillMode fill = config.get(StyleKeys.FILL);
        KernelFigure kernelFigure = this.createKernelFigure(config);
        BasicStroke stroke = fill.hasLine() ? new BasicStroke(config.get(THICK_KEY).intValue(), 1, 1) : null;
        return new KDenseStyle(color, fill, stroke, kernelShape, kernelFigure, isCumulative, norm);
    }

    @Override
    protected LayerOpt getLayerOpt(KDenseStyle style) {
        Color color = style.color_;
        boolean isOpaque = color.getAlpha() == 255 && style.fill_.isOpaque();
        return new LayerOpt(color, isOpaque);
    }

    @Override
    protected int getPixelPadding(KDenseStyle style, PlanarSurface surf) {
        Kernel1d kernel = style.createKernel(surf.getAxes()[0], surf.getLogFlags()[0]);
        return AbstractKernelDensityPlotter.getEffectiveExtent(kernel);
    }

    @Override
    protected void paintBins(PlanarSurface surface, Pixel1dPlotter.BinArray binArray, KDenseStyle style, Graphics2D g) {
        float lineAlpha;
        int gy0;
        Color color0 = g.getColor();
        float[] rgba = style.color_.getComponents(null);
        float cr = rgba[0];
        float cg = rgba[1];
        float cb = rgba[2];
        float calpha = rgba[3];
        Axis xAxis = surface.getAxes()[0];
        boolean xLog = surface.getLogFlags()[0];
        Kernel1d kernel = style.createKernel(xAxis, xLog);
        double[] bins = AbstractKernelDensityPlotter.getDataBins(binArray, xAxis, kernel, style.norm_, style.isCumulative_);
        Axis yAxis = surface.getAxes()[1];
        boolean yLog = surface.getLogFlags()[1];
        boolean yFlip = surface.getFlipFlags()[1];
        if (yLog) {
            double[] dyLimits = surface.getDataLimits()[1];
            double dy0 = yAxis.dataToGraphics(dyLimits[0]);
            gy0 = (int)(yFlip ? dy0 - 2.0 : dy0 + 2.0);
        } else {
            gy0 = (int)yAxis.dataToGraphics(0.0);
        }
        Rectangle clip = surface.getPlotBounds();
        int yClipMin = clip.y - 64;
        int yClipMax = clip.y + clip.height + 64;
        gy0 = AbstractKernelDensityPlotter.clip(gy0, yClipMin, yClipMax);
        int ixlo = binArray.getBinIndex(clip.x);
        int ixhi = binArray.getBinIndex(clip.x + clip.width);
        int np = ixhi - ixlo;
        int[] xs = new int[np];
        int[] ys = new int[np];
        for (int ip = 0; ip < np; ++ip) {
            int ix = ixlo + ip;
            double dy = yAxis.dataToGraphics(bins[ix]);
            xs[ip] = binArray.getGraphicsCoord(ix);
            ys[ip] = PlotUtil.isFinite(dy) ? AbstractKernelDensityPlotter.clip(dy, yClipMin, yClipMax) : gy0;
        }
        boolean squareLines = kernel.isSquare() || kernel.getExtent() <= 1;
        float fillAlpha = style.fill_.getFillAlpha();
        if (fillAlpha > 0.0f) {
            int[] pys;
            int[] pxs;
            int nVertex;
            if (squareLines) {
                nVertex = np * 2 + 2;
                pxs = new int[nVertex];
                pys = new int[nVertex];
                for (int ip = 0; ip < np; ++ip) {
                    pxs[ip * 2 + 1] = xs[ip];
                    pys[ip * 2 + 1] = ys[ip];
                    pxs[ip * 2 + 2] = xs[ip] + 1;
                    pys[ip * 2 + 2] = ys[ip];
                }
            } else {
                nVertex = np + 3;
                pxs = new int[nVertex];
                pys = new int[nVertex];
                System.arraycopy(xs, 0, pxs, 1, np);
                System.arraycopy(ys, 0, pys, 1, np);
                pxs[nVertex - 2] = pxs[nVertex - 3] + 1;
                pys[nVertex - 2] = pys[nVertex - 3];
            }
            pxs[0] = xs[0];
            pys[0] = gy0;
            pxs[nVertex - 1] = xs[np - 1] + 1;
            pys[nVertex - 1] = gy0;
            g.setColor(new Color(cr, cg, cb, calpha * fillAlpha));
            g.fillPolygon(pxs, pys, nVertex);
        }
        if ((lineAlpha = style.fill_.getLineAlpha()) > 0.0f) {
            int[] pys;
            int[] pxs;
            int nVertex;
            if (squareLines) {
                nVertex = np * 2;
                pxs = new int[nVertex];
                pys = new int[nVertex];
                for (int ip = 0; ip < np; ++ip) {
                    pxs[ip * 2] = xs[ip];
                    pys[ip * 2] = ys[ip];
                    pxs[ip * 2 + 1] = xs[ip] + 1;
                    pys[ip * 2 + 1] = ys[ip];
                }
            } else {
                nVertex = np;
                pxs = xs;
                pys = ys;
            }
            g.setColor(new Color(cr, cg, cb, calpha * lineAlpha));
            Stroke stroke0 = g.getStroke();
            g.setStroke(style.stroke_);
            g.drawPolyline(pxs, pys, nVertex);
            g.setStroke(stroke0);
        }
        g.setColor(color0);
    }

    @Override
    protected void extendPixel1dCoordinateRanges(Range[] ranges, boolean[] logFlags, KDenseStyle style, DataSpec dataSpec, DataStore dataStore) {
        Range xRange = ranges[0];
        Range yRange = ranges[1];
        boolean xlog = logFlags[0];
        boolean ylog = logFlags[1];
        yRange.submit(ylog ? 1.0 : 0.0);
        double[] dxlimits = xRange.getFiniteBounds(xlog);
        double dxlo = dxlimits[0];
        double dxhi = dxlimits[1];
        int gxlo = 0;
        int gxhi = 300;
        boolean xflip = false;
        Axis xAxis = Axis.createAxis(gxlo, gxhi, dxlo, dxhi, xlog, xflip);
        Kernel1d kernel = style.createKernel(xAxis, xlog);
        int xpad = AbstractKernelDensityPlotter.getEffectiveExtent(kernel);
        Pixel1dPlotter.BinArray binArray = this.readBins(xAxis, xpad, dataSpec, dataStore);
        double[] bins = AbstractKernelDensityPlotter.getDataBins(binArray, xAxis, kernel, style.norm_, style.isCumulative_);
        int ixlo = binArray.getBinIndex(gxlo);
        int ixhi = binArray.getBinIndex(gxhi);
        for (int ix = ixlo; ix < ixhi; ++ix) {
            yRange.submit(bins[ix]);
        }
    }

    @Override
    protected ReportMap getPixel1dReport(Pixel1dPlotter.Pixel1dPlan plan, KDenseStyle style, boolean xLog) {
        int ghi;
        Pixel1dPlotter.BinArray binArray = plan.binArray_;
        Axis xAxis = plan.xAxis_;
        Kernel1d kernel = style.createKernel(xAxis, xLog);
        double[] dataBins = AbstractKernelDensityPlotter.getDataBins(binArray, xAxis, kernel, style.norm_, style.isCumulative_);
        double[] dlimits = xAxis.getDataLimits();
        double dlo = dlimits[0];
        double dhi = dlimits[1];
        int glo = (int)Math.round(xAxis.dataToGraphics(dlo));
        if (glo > (ghi = (int)Math.round(xAxis.dataToGraphics(dhi)))) {
            int gt = glo;
            glo = ghi;
            ghi = gt;
        }
        int ixlo = binArray.getBinIndex(glo);
        int nx = ghi - glo;
        double[] clipBins = new double[nx];
        System.arraycopy(dataBins, ixlo, clipBins, 0, nx);
        ReportMap report = new ReportMap();
        report.put(BINS_KEY, clipBins);
        ReportMap kReport = style.kernelFigure_.getReportMap(xLog, dlo, dhi);
        if (kReport != null) {
            report.putAll(kReport);
        }
        return report;
    }

    private static int clip(double p, int lo, int hi) {
        if (Double.isNaN(p)) {
            return lo;
        }
        if (p < (double)lo) {
            return lo;
        }
        if (p > (double)hi) {
            return hi;
        }
        return (int)Math.round(p);
    }

    @Equality
    public static interface KernelFigure {
        public Kernel1d createKernel(Kernel1dShape var1, Axis var2, boolean var3);

        public ReportMap getReportMap(boolean var1, double var2, double var4);
    }

    public static class KDenseStyle
    implements Style {
        private final Color color_;
        private final FillMode fill_;
        private final Stroke stroke_;
        private final Kernel1dShape kernelShape_;
        private final KernelFigure kernelFigure_;
        private final boolean isCumulative_;
        private final Normalisation norm_;
        private static final int[] ICON_DATA = new int[]{4, 6, 8, 9, 9, 7, 5, 3};

        public KDenseStyle(Color color, FillMode fill, Stroke stroke, Kernel1dShape kernelShape, KernelFigure kernelFigure, boolean isCumulative, Normalisation norm) {
            this.color_ = color;
            this.fill_ = fill;
            this.stroke_ = stroke;
            this.kernelShape_ = kernelShape;
            this.kernelFigure_ = kernelFigure;
            this.isCumulative_ = isCumulative;
            this.norm_ = norm;
        }

        public boolean isCumulative() {
            return this.isCumulative_;
        }

        public Normalisation getNormalisation() {
            return this.norm_;
        }

        @Override
        public Icon getLegendIcon() {
            return this.fill_.createIcon(ICON_DATA, this.color_, this.stroke_, 2);
        }

        public Kernel1d createKernel(Axis xAxis, boolean xLog) {
            return this.kernelFigure_.createKernel(this.kernelShape_, xAxis, xLog);
        }

        public int hashCode() {
            int code = 33421;
            code = 23 * code + this.color_.hashCode();
            code = 23 * code + this.fill_.hashCode();
            code = 23 * code + PlotUtil.hashCode(this.stroke_);
            code = 23 * code + this.kernelShape_.hashCode();
            code = 23 * code + this.kernelFigure_.hashCode();
            code = 23 * code + (this.isCumulative_ ? 11 : 13);
            code = 23 * code + PlotUtil.hashCode(this.norm_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof KDenseStyle) {
                KDenseStyle other = (KDenseStyle)o;
                return this.color_.equals(other.color_) && this.fill_.equals(other.fill_) && PlotUtil.equals(this.stroke_, other.stroke_) && this.kernelShape_.equals(other.kernelShape_) && this.kernelFigure_.equals(other.kernelFigure_) && this.isCumulative_ == other.isCumulative_ && PlotUtil.equals(this.norm_, other.norm_);
            }
            return false;
        }
    }
}

