/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.HashBinList;

public abstract class ArrayBinList
implements BinList {
    private final int size_;
    private final Combiner combiner_;
    private final BitSet mask_;

    protected ArrayBinList(int size, Combiner combiner) {
        this.size_ = size;
        this.combiner_ = combiner;
        this.mask_ = new BitSet(size);
    }

    protected abstract void submitToBinInt(int var1, double var2);

    protected abstract double getBinResultInt(int var1);

    @Override
    public void submitToBin(long lndex, double datum) {
        int index = (int)lndex;
        this.mask_.set(index);
        this.submitToBinInt(index, datum);
    }

    @Override
    public long getSize() {
        return this.size_;
    }

    @Override
    public Combiner getCombiner() {
        return this.combiner_;
    }

    @Override
    public BinList.Result getResult() {
        return new MaskResult(this.mask_, this.size_, this.combiner_.hasBigBin()){

            @Override
            public double getPopulatedBinValue(int index) {
                return ArrayBinList.this.getBinResultInt(index);
            }
        };
    }

    private static Iterator<Long> createMaskIterator(final BitSet mask) {
        return new Iterator<Long>(){
            int ibit;
            {
                this.ibit = mask.nextSetBit(0);
            }

            @Override
            public Long next() {
                if (this.ibit >= 0) {
                    Long result = new Long(this.ibit);
                    this.ibit = mask.nextSetBit(this.ibit + 1);
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return this.ibit >= 0;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static BinList.Result createDoubleMaskResult(final BitSet mask, final double[] values) {
        return new BinList.Result(){

            @Override
            public double getBinValue(long lndex) {
                int index = (int)lndex;
                return mask.get(index) ? values[index] : Double.NaN;
            }

            @Override
            public long getBinCount() {
                return mask.cardinality();
            }

            @Override
            public Iterator<Long> indexIterator() {
                return ArrayBinList.createMaskIterator(mask);
            }

            @Override
            public BinList.Result compact() {
                return this;
            }
        };
    }

    private static abstract class MaskResult
    implements BinList.Result {
        private final BitSet mask_;
        private final int arraysize_;
        private final boolean hasBigBin_;

        MaskResult(BitSet mask, int arraysize, boolean hasBigBin) {
            this.mask_ = mask;
            this.arraysize_ = arraysize;
            this.hasBigBin_ = hasBigBin;
        }

        @Override
        public long getBinCount() {
            return this.mask_.cardinality();
        }

        @Override
        public Iterator<Long> indexIterator() {
            return ArrayBinList.createMaskIterator(this.mask_);
        }

        @Override
        public double getBinValue(long lndex) {
            int index = (int)lndex;
            return this.mask_.get(index) ? this.getPopulatedBinValue(index) : Double.NaN;
        }

        @Override
        public BinList.Result compact() {
            double frac = (double)this.mask_.cardinality() * 1.0 / (double)this.arraysize_;
            if (frac < 0.25) {
                HashMap<Long, Double> map = new HashMap<Long, Double>();
                Iterator<Long> it = this.indexIterator();
                while (it.hasNext()) {
                    Long key = it.next();
                    map.put(key, this.getPopulatedBinValue(key.intValue()));
                }
                return HashBinList.createHashResult(map);
            }
            return this;
        }

        abstract double getPopulatedBinValue(int var1);
    }
}

