/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import uk.ac.starlink.ttools.plot2.layer.BinMapper;
import uk.ac.starlink.ttools.plot2.layer.Normalisation;

public class BinBag {
    private final boolean log_;
    private final double binWidth_;
    private final double binPhase_;
    private final BinMapper mapper_;
    private final Map<Integer, Value> valueMap_;

    public BinBag(boolean log, double binWidth, double binPhase, double point) {
        this.log_ = log;
        this.binWidth_ = binWidth;
        this.binPhase_ = binPhase;
        this.mapper_ = BinMapper.createMapper(log, binWidth, binPhase, point);
        this.valueMap_ = new HashMap<Integer, Value>();
    }

    public void addToBin(double point, double inc) {
        if (!(Double.isNaN(point) || Double.isInfinite(point) || this.log_ && !(point > 0.0))) {
            int ix = this.mapper_.getBinIndex(point);
            Value val = this.valueMap_.get(ix);
            if (val == null) {
                val = new Value();
                this.valueMap_.put(ix, val);
            }
            val.value_ += inc;
        }
    }

    public Iterator<Bin> binIterator(boolean cumulative, Normalisation norm) {
        if (this.valueMap_.isEmpty()) {
            return new ArrayList().iterator();
        }
        final int nbin = this.valueMap_.size();
        final int[] binIndices = new int[nbin];
        int ib = 0;
        for (Integer index : this.valueMap_.keySet()) {
            binIndices[ib++] = index;
        }
        assert (ib == nbin);
        Arrays.sort(binIndices);
        final double[] binValues = new double[nbin];
        double total = 0.0;
        double max = 0.0;
        for (int ib2 = 0; ib2 < nbin; ++ib2) {
            double value = this.valueMap_.get((Object)Integer.valueOf((int)binIndices[ib2])).value_;
            binValues[ib2] = cumulative ? total + value : value;
            total += value;
            max = Math.max(max, Math.abs(value));
        }
        double bw = this.log_ ? BinMapper.log(this.binWidth_) : this.binWidth_;
        double scale = norm.getScaleFactor(total, max, bw, cumulative);
        if (scale != 1.0) {
            int ib3 = 0;
            while (ib3 < nbin) {
                int n = ib3++;
                binValues[n] = binValues[n] * scale;
            }
        }
        if (cumulative) {
            return new Iterator<Bin>(){
                int ib = 0;
                int index = binIndices[0];

                @Override
                public boolean hasNext() {
                    return this.ib < nbin;
                }

                @Override
                public Bin next() {
                    if (this.ib < nbin) {
                        assert (this.index >= binIndices[this.ib]);
                        Bin bin = BinBag.this.createBin(this.index, binValues[this.ib]);
                        ++this.index;
                        if (this.ib == nbin - 1 || this.index == binIndices[this.ib + 1]) {
                            ++this.ib;
                        }
                        return bin;
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<Bin>(){
            int ib = 0;

            @Override
            public boolean hasNext() {
                return this.ib < nbin;
            }

            @Override
            public Bin next() {
                if (this.ib < nbin) {
                    Bin bin = BinBag.this.createBin(binIndices[this.ib], binValues[this.ib]);
                    ++this.ib;
                    return bin;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<double[]> barIterator(double lo, double hi) {
        final int ibin0 = this.mapper_.getBinIndex(lo);
        final int ibin1 = this.mapper_.getBinIndex(hi);
        return new Iterator<double[]>(){
            int ib;
            {
                this.ib = ibin0;
            }

            @Override
            public boolean hasNext() {
                return this.ib <= ibin1;
            }

            @Override
            public double[] next() {
                if (this.ib <= ibin1) {
                    return BinBag.this.mapper_.getBinLimits(this.ib++);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public double getBinWidth() {
        return this.binWidth_;
    }

    public boolean matches(boolean log, double binWidth, double binPhase) {
        return log == this.log_ && binWidth == this.binWidth_ && binPhase == this.binPhase_;
    }

    private Bin createBin(int binIndex, final double binValue) {
        final double[] limits = this.mapper_.getBinLimits(binIndex);
        return new Bin(){

            @Override
            public double getXMin() {
                return limits[0];
            }

            @Override
            public double getXMax() {
                return limits[1];
            }

            @Override
            public double getY() {
                return binValue;
            }

            public String toString() {
                return limits[0] + ".." + limits[1] + ": " + binValue;
            }
        };
    }

    private static class Value {
        double value_;

        private Value() {
        }
    }

    public static interface Bin {
        public double getXMin();

        public double getXMax();

        public double getY();
    }
}

