/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import uk.ac.starlink.ttools.plot2.Equality;

@Equality
public abstract class BinMapper {
    public abstract int getBinIndex(double var1);

    public abstract double[] getBinLimits(int var1);

    public static BinMapper createMapper(boolean log, double binWidth, double binPhase, double point) {
        if ((binPhase %= 1.0) < 0.0) {
            binPhase += 1.0;
        }
        return log ? new LogBinMapper(binWidth, binPhase, point) : new LinearBinMapper(binWidth, binPhase, point);
    }

    public static double log(double val) {
        return Math.log10(val);
    }

    private static class LogBinMapper
    extends BinMapper {
        private final double width_;
        private final double floor_;
        private final double logWidth1_;
        private final double floor1_;

        LogBinMapper(double width, double phase, double point) {
            this.width_ = width;
            if (point <= 0.0) {
                point = 1.0;
            }
            int n = (int)Math.floor(LogBinMapper.log(point) / LogBinMapper.log(width));
            this.floor_ = Math.pow(width, (double)n + phase);
            assert (Math.abs(LogBinMapper.log(this.floor_ / point)) <= width);
            this.logWidth1_ = 1.0 / LogBinMapper.log(width);
            this.floor1_ = 1.0 / this.floor_;
        }

        @Override
        public int getBinIndex(double value) {
            return (int)Math.floor(LogBinMapper.log(value * this.floor1_) * this.logWidth1_);
        }

        @Override
        public double[] getBinLimits(int index) {
            double lo = this.floor_ * Math.pow(this.width_, index);
            return new double[]{lo, lo * this.width_};
        }

        public int hashCode() {
            int code = 44178;
            code = 23 * Float.floatToIntBits((float)this.width_);
            code = 23 * Float.floatToIntBits((float)this.floor_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof LogBinMapper) {
                LogBinMapper other = (LogBinMapper)o;
                return this.width_ == other.width_ && this.floor_ == other.floor_;
            }
            return false;
        }
    }

    private static class LinearBinMapper
    extends BinMapper {
        private final double width_;
        private final double width1_;
        private final double floor_;

        LinearBinMapper(double width, double phase, double point) {
            this.width_ = width;
            this.width1_ = 1.0 / width;
            int n = (int)Math.floor(point / width);
            this.floor_ = ((double)n + phase) * width;
            assert (Math.abs(this.floor_ - point) <= width);
        }

        @Override
        public int getBinIndex(double value) {
            return (int)Math.floor((value - this.floor_) * this.width1_);
        }

        @Override
        public double[] getBinLimits(int index) {
            double lo = this.floor_ + (double)index * this.width_;
            return new double[]{lo, lo + this.width_};
        }

        public int hashCode() {
            int code = 55289;
            code = 23 * code + Float.floatToIntBits((float)this.width_);
            code = 23 * code + Float.floatToIntBits((float)this.floor_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof LinearBinMapper) {
                LinearBinMapper other = (LinearBinMapper)o;
                return this.width_ == other.width_ && this.floor_ == other.floor_;
            }
            return false;
        }
    }
}

