/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.PointCloud;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.layer.Binner;
import uk.ac.starlink.ttools.plot2.layer.Gridder;

public class BinPlan {
    private final Binner binner_;
    private final Gridder gridder_;

    public BinPlan(Binner binner, Gridder gridder) {
        this.binner_ = binner;
        this.gridder_ = gridder;
    }

    public Binner getBinner() {
        return this.binner_;
    }

    public Gridder getGridder() {
        return this.gridder_;
    }

    public static BinPlan calculatePointCloudPlan(PointCloud pointCloud, Surface surface, DataStore dataStore, Object[] knownPlans) {
        for (int ip = 0; ip < knownPlans.length; ++ip) {
            PointCloudBinPlan plan;
            if (!(knownPlans[ip] instanceof PointCloudBinPlan) || !(plan = (PointCloudBinPlan)knownPlans[ip]).matches(pointCloud, surface)) continue;
            return plan;
        }
        Rectangle bounds = surface.getPlotBounds();
        int xoff = bounds.x;
        int yoff = bounds.y;
        Gridder gridder = new Gridder(bounds.width, bounds.height);
        Binner binner = new Binner(gridder.getLength());
        Point2D.Double gp = new Point2D.Double();
        for (double[] dpos : pointCloud.createDataPosIterable(dataStore)) {
            if (!surface.dataToGraphics(dpos, true, gp)) continue;
            int gx = PlotUtil.ifloor(gp.x) - xoff;
            int gy = PlotUtil.ifloor(gp.y) - yoff;
            binner.increment(gridder.getIndex(gx, gy));
        }
        return new PointCloudBinPlan(binner, gridder, pointCloud, surface);
    }

    private static class PointCloudBinPlan
    extends BinPlan {
        final PointCloud pointCloud_;
        final Surface surface_;

        PointCloudBinPlan(Binner binner, Gridder gridder, PointCloud pointCloud, Surface surface) {
            super(binner, gridder);
            this.pointCloud_ = pointCloud;
            this.surface_ = surface;
        }

        boolean matches(PointCloud pointCloud, Surface surface) {
            return pointCloud.equals(this.pointCloud_) && surface.equals(this.surface_);
        }
    }
}

