/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.util.logging.Logger;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot2.layer.BinList;

public abstract class BinResultColumnData<T>
extends ColumnData {
    private final BinList.Result binResult_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.layer");

    BinResultColumnData(ValueInfo info, BinList.Result binResult) {
        super(info);
        this.binResult_ = binResult;
    }

    public Object readValue(long irow) {
        double dval = this.binResult_.getBinValue(irow);
        return Double.isNaN(dval) ? null : this.convert(dval);
    }

    abstract T convert(double var1);

    public static ColumnData createInstance(ValueInfo info, BinList.Result binResult) {
        Class clazz = info.getContentClass();
        if (Byte.class.equals((Object)clazz)) {
            return new BinResultColumnData<Byte>(info, binResult){

                @Override
                Byte convert(double dval) {
                    return new Byte((byte)dval);
                }
            };
        }
        if (Short.class.equals((Object)clazz)) {
            return new BinResultColumnData<Short>(info, binResult){

                @Override
                Short convert(double dval) {
                    return new Short((short)dval);
                }
            };
        }
        if (Integer.class.equals((Object)clazz)) {
            return new BinResultColumnData<Integer>(info, binResult){

                @Override
                Integer convert(double dval) {
                    return new Integer((int)dval);
                }
            };
        }
        if (Long.class.equals((Object)clazz)) {
            return new BinResultColumnData<Long>(info, binResult){

                @Override
                Long convert(double dval) {
                    return new Long((long)dval);
                }
            };
        }
        if (Float.class.equals((Object)clazz)) {
            return new BinResultColumnData<Float>(info, binResult){

                @Override
                Float convert(double dval) {
                    return new Float((float)dval);
                }
            };
        }
        if (Double.class.equals((Object)clazz)) {
            return new BinResultColumnData<Double>(info, binResult){

                @Override
                public Double convert(double dval) {
                    return new Double(dval);
                }
            };
        }
        logger_.warning("Surprising data type: " + clazz + "; " + "can't create ColumnData");
        return null;
    }
}

