/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JTextField;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.SliderSpecifier;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.SpecifierPanel;
import uk.ac.starlink.ttools.plot2.layer.Rounding;

@Equality
public abstract class BinSizer {
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.layer");

    public abstract double getWidth(boolean var1, double var2, double var4, Rounding var6);

    public static BinSizer createFixedBinSizer(double binWidth) {
        return new FixedBinSizer(binWidth);
    }

    public static BinSizer createCountBinSizer(double nbin) {
        return new CountBinSizer(nbin);
    }

    public static ConfigKey<BinSizer> createSizerConfigKey(ConfigMeta meta, ReportKey<Double> widthReportKey, int dfltNbin, boolean allowZero) {
        return new BinSizerConfigKey(meta, widthReportKey, dfltNbin, allowZero);
    }

    public static String getConfigKeyDescription() {
        return PlotUtil.concatLines(new String[]{"<p>If the supplied value is a positive number", "it is interpreted as a fixed width in the data coordinates", "of the X axis", "(if the X axis is logarithmic, the value is a fixed factor).", "If it is a negative number, then it will be interpreted", "as the approximate number of smooothing widths that fit", "in the width of the visible plot", "(i.e. plot width / smoothing width).", "If the value is zero, no smoothing is applied.", "</p>", "<p>When setting this value graphically,", "you can use either the slider to adjust the bin count", "or the numeric entry field to fix the bin width.", "</p>"});
    }

    public static class BinSizerSpecifier
    extends SpecifierPanel<BinSizer> {
        private final ReportKey<Double> widthReportKey_;
        private final boolean allowZero_;
        private final SliderSpecifier sliderSpecifier_;
        private final int maxCount_;

        BinSizerSpecifier(ReportKey<Double> widthReportKey, int dfltNbin, boolean allowZero, int maxCount) {
            super(true);
            this.widthReportKey_ = widthReportKey;
            this.allowZero_ = allowZero;
            this.maxCount_ = maxCount;
            double reset = dfltNbin == 0 ? (double)maxCount : (double)dfltNbin;
            this.sliderSpecifier_ = new SliderSpecifier(2.0, maxCount, true, reset, true, SliderSpecifier.TextOption.ENTER);
        }

        @Override
        protected JComponent createComponent() {
            this.sliderSpecifier_.addActionListener(this.getActionForwarder());
            return this.sliderSpecifier_.getComponent();
        }

        @Override
        public BinSizer getSpecifiedValue() {
            double dval = Double.NaN;
            if (!this.sliderSpecifier_.isSliderActive()) {
                dval = this.sliderSpecifier_.getTextValue();
            }
            if (Double.isNaN(dval) || dval == 0.0 && !this.allowZero_) {
                dval = -this.sliderSpecifier_.getSliderValue();
                if (this.allowZero_ && dval == (double)(-this.maxCount_)) {
                    dval = 0.0;
                }
            }
            return dval >= 0.0 ? new FixedBinSizer(dval) : new CountBinSizer(-dval);
        }

        @Override
        public void setSpecifiedValue(BinSizer sizer) {
            if (sizer instanceof CountBinSizer) {
                double nbin = ((CountBinSizer)sizer).nbin_;
                this.sliderSpecifier_.setSliderActive(true);
                this.sliderSpecifier_.setSpecifiedValue(nbin);
            } else if (sizer instanceof FixedBinSizer) {
                double bw = ((FixedBinSizer)sizer).binWidth_;
                this.sliderSpecifier_.setSliderActive(false);
                this.sliderSpecifier_.setSpecifiedValue(bw);
            } else {
                logger_.warning("Can't reset to unknown sizer type");
            }
        }

        @Override
        public void submitReport(ReportMap report) {
            Double objval = report == null ? null : report.get(this.widthReportKey_);
            double dval = objval == null ? Double.NaN : objval;
            this.displayBinWidth(dval);
        }

        private void displayBinWidth(double fixVal) {
            if (this.sliderSpecifier_.isSliderActive()) {
                String txt = Double.isNaN(fixVal) ? "" : Float.toString((float)fixVal);
                JTextField txtField = this.sliderSpecifier_.getTextField();
                txtField.setText(txt);
                txtField.setCaretPosition(0);
            }
        }
    }

    private static class BinSizerConfigKey
    extends ConfigKey<BinSizer> {
        private final ReportKey<Double> widthReportKey_;
        private final int dfltNbin_;
        private final boolean allowZero_;

        BinSizerConfigKey(ConfigMeta meta, ReportKey<Double> widthReportKey, int dfltNbin, boolean allowZero) {
            super(meta, BinSizer.class, new CountBinSizer(dfltNbin));
            this.widthReportKey_ = widthReportKey;
            this.dfltNbin_ = dfltNbin;
            this.allowZero_ = allowZero;
        }

        @Override
        public BinSizer stringToValue(String txt) throws ConfigException {
            double dval;
            try {
                dval = Double.valueOf(txt.trim());
            }
            catch (NumberFormatException e) {
                throw new ConfigException(this, "\"" + txt + "\" not numeric", e);
            }
            if (dval > 0.0 || dval == 0.0 && this.allowZero_) {
                return new FixedBinSizer(dval);
            }
            if (dval <= -1.0) {
                return new CountBinSizer(-dval);
            }
            String msg = "Bad sizer value " + dval + " - should be " + (this.allowZero_ ? ">=" : ">") + "0 (fixed) " + "or <=-1 (-bin_count)";
            throw new ConfigException(this, msg);
        }

        @Override
        public String valueToString(BinSizer sizer) {
            if (sizer instanceof FixedBinSizer) {
                double width = ((FixedBinSizer)sizer).binWidth_;
                return Double.toString(width);
            }
            if (sizer instanceof CountBinSizer) {
                double nbin = ((CountBinSizer)sizer).nbin_;
                return Integer.toString(-((int)nbin));
            }
            return "??";
        }

        @Override
        public Specifier<BinSizer> createSpecifier() {
            return new BinSizerSpecifier(this.widthReportKey_, this.dfltNbin_, this.allowZero_, 1000);
        }
    }

    private static class CountBinSizer
    extends BinSizer {
        private final double nbin_;

        CountBinSizer(double nbin) {
            this.nbin_ = nbin;
        }

        @Override
        public double getWidth(boolean xlog, double xlo, double xhi, Rounding rounding) {
            double width0 = xlog ? Math.exp(Math.log(xhi / xlo) / this.nbin_) : (xhi - xlo) / this.nbin_;
            return rounding == null ? width0 : rounding.getRounder(xlog).round(width0);
        }

        public int hashCode() {
            int code = 44301;
            code = 23 * code + Float.floatToIntBits((float)this.nbin_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof CountBinSizer) {
                CountBinSizer other = (CountBinSizer)o;
                return this.nbin_ == other.nbin_;
            }
            return false;
        }
    }

    private static class FixedBinSizer
    extends BinSizer {
        private final double binWidth_;

        FixedBinSizer(double binWidth) {
            this.binWidth_ = binWidth;
        }

        @Override
        public double getWidth(boolean xlog, double xlo, double xhi, Rounding rounding) {
            return xlog ? Math.max(1.0, this.binWidth_) : this.binWidth_;
        }

        public int hashCode() {
            return Float.floatToIntBits((float)this.binWidth_);
        }

        public boolean equals(Object o) {
            if (o instanceof FixedBinSizer) {
                FixedBinSizer other = (FixedBinSizer)o;
                return this.binWidth_ == other.binWidth_;
            }
            return false;
        }
    }
}

