/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

public class Binner {
    private final int n_;
    private long total_;
    private ArrayBinner aBinner_;

    public Binner(int n) {
        this.n_ = n;
        this.aBinner_ = new ByteBinner(n);
    }

    public int getLength() {
        return this.n_;
    }

    public void increment(int index) {
        ++this.total_;
        if (!this.aBinner_.increment(index)) {
            ArrayBinner aBinner1;
            if (this.aBinner_ instanceof ByteBinner) {
                aBinner1 = new ShortBinner(this.n_);
            } else if (this.aBinner_ instanceof ShortBinner) {
                aBinner1 = new IntBinner(this.n_);
            } else {
                throw new RuntimeException("Do what?");
            }
            for (int i = 0; i < this.n_; ++i) {
                aBinner1.setCount(i, this.aBinner_.getCount(i));
            }
            aBinner1.setCount(index, this.aBinner_.maxValue());
            this.aBinner_ = aBinner1;
            this.increment(index);
        }
    }

    public int getCount(int index) {
        return this.aBinner_.getCount(index);
    }

    public long getTotal() {
        return this.total_;
    }

    private static class IntBinner
    extends ArrayBinner {
        final int[] buf_;

        IntBinner(int n) {
            this.buf_ = new int[n];
        }

        @Override
        int maxValue() {
            return Integer.MAX_VALUE;
        }

        @Override
        boolean increment(int index) {
            int n = index;
            int n2 = this.buf_[n] + 1;
            this.buf_[n] = n2;
            return n2 > 0;
        }

        @Override
        int getCount(int index) {
            return this.buf_[index];
        }

        @Override
        void setCount(int index, int value) {
            this.buf_[index] = value;
        }
    }

    private static class ShortBinner
    extends ArrayBinner {
        final short[] buf_;

        ShortBinner(int n) {
            this.buf_ = new short[n];
        }

        @Override
        int maxValue() {
            return 65535;
        }

        @Override
        boolean increment(int index) {
            int n = index;
            short s = (short)(this.buf_[n] + 1);
            this.buf_[n] = s;
            return s != 0;
        }

        @Override
        int getCount(int index) {
            return this.buf_[index] & 0xFFFF;
        }

        @Override
        void setCount(int index, int value) {
            this.buf_[index] = (short)value;
        }
    }

    private static class ByteBinner
    extends ArrayBinner {
        final byte[] buf_;

        ByteBinner(int n) {
            this.buf_ = new byte[n];
        }

        @Override
        int maxValue() {
            return 255;
        }

        @Override
        boolean increment(int index) {
            int n = index;
            byte by = (byte)(this.buf_[n] + 1);
            this.buf_[n] = by;
            return by != 0;
        }

        @Override
        int getCount(int index) {
            return this.buf_[index] & 0xFF;
        }

        @Override
        void setCount(int index, int value) {
            this.buf_[index] = (byte)value;
        }
    }

    private static abstract class ArrayBinner {
        private ArrayBinner() {
        }

        abstract boolean increment(int var1);

        abstract int maxValue();

        abstract int getCount(int var1);

        abstract void setCount(int var1, int var2);
    }
}

