/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.util.Arrays;
import java.util.BitSet;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.layer.ArrayBinList;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.layer.HashBinList;
import uk.ac.starlink.ttools.plot2.layer.QuantileCombiner;

@Equality
public abstract class Combiner {
    private final String name_;
    private final String description_;
    private final boolean hasBigBin_;
    public static final Combiner COUNT;
    public static final Combiner SUM;
    public static final Combiner MEAN;
    public static final Combiner MEDIAN;
    public static final Combiner SAMPLE_STDEV;
    public static final Combiner MIN;
    public static final Combiner MAX;
    public static final Combiner HIT;
    private static final Combiner[] COMBINERS;

    protected Combiner(String name, String description, boolean hasBigBin) {
        this.name_ = name;
        this.description_ = description;
        this.hasBigBin_ = hasBigBin;
    }

    public abstract Container createContainer();

    public abstract BinList createArrayBinList(int var1);

    public abstract BinList createHashBinList(long var1);

    public String getName() {
        return this.name_;
    }

    public String getDescription() {
        return this.description_;
    }

    public boolean hasBigBin() {
        return this.hasBigBin_;
    }

    public abstract ValueInfo createCombinedInfo(ValueInfo var1);

    public String toString() {
        return this.name_;
    }

    public static Combiner[] getKnownCombiners() {
        return (Combiner[])COMBINERS.clone();
    }

    private static String getInfoDescription(ValueInfo info) {
        String descrip = info.getDescription();
        return descrip != null && descrip.trim().length() > 0 ? descrip : info.getName();
    }

    private static String modifyUcd(String ucd, String word, boolean isPrimary) {
        if (isPrimary) {
            return word;
        }
        if (ucd == null || ucd.trim().length() == 0) {
            return ucd;
        }
        return ucd + ";" + word;
    }

    static {
        SUM = new SumCombiner();
        MEAN = new MeanCombiner();
        MEDIAN = new MedianCombiner();
        MIN = new MinCombiner();
        MAX = new MaxCombiner();
        SAMPLE_STDEV = new StdevCombiner(true);
        COUNT = new CountCombiner();
        HIT = new HitCombiner();
        COMBINERS = new Combiner[]{SUM, MEAN, MEDIAN, MIN, MAX, SAMPLE_STDEV, COUNT, HIT};
    }

    private static class HitCombiner
    extends AbstractCombiner {
        HitCombiner() {
            super("hit", "1 if any values present, NaN otherwise (weight is ignored)", false);
        }

        @Override
        public BinList createArrayBinList(int size) {
            final BitSet mask = new BitSet();
            return new ArrayBinList(size, this){

                @Override
                public void submitToBinInt(int index, double datum) {
                    mask.set(index);
                }

                @Override
                public double getBinResultInt(int index) {
                    return mask.get(index) ? 1.0 : Double.NaN;
                }
            };
        }

        @Override
        public Container createContainer() {
            return new HitContainer();
        }

        @Override
        public ValueInfo createCombinedInfo(ValueInfo dataInfo) {
            return new DefaultValueInfo("hit", Short.class, "1 if bin contains data, 0 if not");
        }

        private static class HitContainer
        implements Container {
            boolean hit_;

            private HitContainer() {
            }

            @Override
            public void submit(double datum) {
                this.hit_ = true;
            }

            @Override
            public double getResult() {
                return this.hit_ ? 1.0 : Double.NaN;
            }
        }
    }

    private static class MaxCombiner
    extends AbstractCombiner {
        private static double combineMax(double oldValue, double datum) {
            return Double.isNaN(oldValue) ? datum : Math.max(oldValue, datum);
        }

        MaxCombiner() {
            super("max", "the maximum of all the combined values", false);
        }

        @Override
        public BinList createArrayBinList(int size) {
            final double[] maxs = new double[size];
            Arrays.fill(maxs, Double.NaN);
            return new ArrayBinList(size, this){

                @Override
                public void submitToBinInt(int index, double datum) {
                    maxs[index] = MaxCombiner.combineMax(maxs[index], datum);
                }

                @Override
                public double getBinResultInt(int index) {
                    return maxs[index];
                }
            };
        }

        @Override
        public Container createContainer() {
            return new MaxContainer();
        }

        @Override
        public ValueInfo createCombinedInfo(ValueInfo dataInfo) {
            DefaultValueInfo info = new DefaultValueInfo(dataInfo.getName() + "_max", dataInfo.getContentClass(), Combiner.getInfoDescription(dataInfo) + ", maximum value in bin");
            info.setUnitString(dataInfo.getUnitString());
            info.setUCD(Combiner.modifyUcd(dataInfo.getUCD(), "stat.max", false));
            return info;
        }

        private static class MaxContainer
        implements Container {
            private double max_ = Double.NaN;

            private MaxContainer() {
            }

            @Override
            public void submit(double datum) {
                this.max_ = MaxCombiner.combineMax(this.max_, datum);
            }

            @Override
            public double getResult() {
                return this.max_;
            }
        }
    }

    private static class MinCombiner
    extends AbstractCombiner {
        private static double combineMin(double oldValue, double datum) {
            return Double.isNaN(oldValue) ? datum : Math.min(oldValue, datum);
        }

        MinCombiner() {
            super("min", "the minimum of all the combined values", false);
        }

        @Override
        public BinList createArrayBinList(int size) {
            final double[] mins = new double[size];
            Arrays.fill(mins, Double.NaN);
            return new ArrayBinList(size, this){

                @Override
                public void submitToBinInt(int index, double datum) {
                    mins[index] = MinCombiner.combineMin(mins[index], datum);
                }

                @Override
                public double getBinResultInt(int index) {
                    return mins[index];
                }
            };
        }

        @Override
        public Container createContainer() {
            return new MinContainer();
        }

        @Override
        public ValueInfo createCombinedInfo(ValueInfo dataInfo) {
            DefaultValueInfo info = new DefaultValueInfo(dataInfo.getName() + "_min", dataInfo.getContentClass(), Combiner.getInfoDescription(dataInfo) + ", minimum value in bin");
            info.setUnitString(dataInfo.getUnitString());
            info.setUCD(Combiner.modifyUcd(dataInfo.getUCD(), "stat.min", false));
            return info;
        }

        private static class MinContainer
        implements Container {
            private double min_ = Double.NaN;

            private MinContainer() {
            }

            @Override
            public void submit(double datum) {
                this.min_ = MinCombiner.combineMin(this.min_, datum);
            }

            @Override
            public double getResult() {
                return this.min_;
            }
        }
    }

    private static class SumCombiner
    extends AbstractCombiner {
        private static double combineSum(double oldValue, double datum) {
            return Double.isNaN(oldValue) ? datum : oldValue + datum;
        }

        SumCombiner() {
            super("sum", "the sum of all the combined values", false);
        }

        @Override
        public BinList createArrayBinList(int size) {
            final double[] sums = new double[size];
            Arrays.fill(sums, Double.NaN);
            return new ArrayBinList(size, this){

                @Override
                public void submitToBinInt(int index, double datum) {
                    sums[index] = SumCombiner.combineSum(sums[index], datum);
                }

                @Override
                public double getBinResultInt(int index) {
                    return sums[index];
                }
            };
        }

        @Override
        public Container createContainer() {
            return new SumContainer();
        }

        @Override
        public ValueInfo createCombinedInfo(ValueInfo dataInfo) {
            DefaultValueInfo info = new DefaultValueInfo(dataInfo.getName() + "_sum", Double.class, Combiner.getInfoDescription(dataInfo) + ", sum in bin");
            info.setUnitString(dataInfo.getUnitString());
            return info;
        }

        private static class SumContainer
        implements Container {
            double sum_ = Double.NaN;

            private SumContainer() {
            }

            @Override
            public void submit(double datum) {
                this.sum_ = SumCombiner.combineSum(this.sum_, datum);
            }

            @Override
            public double getResult() {
                return this.sum_;
            }
        }
    }

    private static class CountCombiner
    extends AbstractCombiner {
        CountCombiner() {
            super("count", "the number of non-blank values (weight is ignored)", false);
        }

        @Override
        public BinList createArrayBinList(int size) {
            final int[] counts = new int[size];
            return new ArrayBinList(size, this){

                @Override
                public void submitToBinInt(int index, double value) {
                    int n = index;
                    counts[n] = counts[n] + 1;
                }

                @Override
                public double getBinResultInt(int index) {
                    int count = counts[index];
                    return count == 0 ? Double.NaN : (double)count;
                }
            };
        }

        @Override
        public Container createContainer() {
            return new CountContainer();
        }

        @Override
        public ValueInfo createCombinedInfo(ValueInfo inInfo) {
            DefaultValueInfo outInfo = new DefaultValueInfo("count", Integer.class, "Number of items counted per bin");
            outInfo.setUCD("meta.number");
            return outInfo;
        }

        private static class CountContainer
        implements Container {
            int count_;

            private CountContainer() {
            }

            @Override
            public void submit(double datum) {
                ++this.count_;
            }

            @Override
            public double getResult() {
                return this.count_ == 0 ? Double.NaN : (double)this.count_;
            }
        }
    }

    private static class StdevCombiner
    extends AbstractCombiner {
        private final boolean isSampleStdev_;

        public StdevCombiner(boolean isSampleStdev) {
            super("stdev", "the " + (isSampleStdev ? "sample" : "population") + " standard deviation of the combined values", true);
            this.isSampleStdev_ = isSampleStdev;
        }

        @Override
        public BinList createArrayBinList(int size) {
            final int[] counts = new int[size];
            final double[] sum1s = new double[size];
            final double[] sum2s = new double[size];
            return new ArrayBinList(size, this){

                @Override
                public void submitToBinInt(int index, double value) {
                    int n = index;
                    counts[n] = counts[n] + 1;
                    int n2 = index;
                    sum1s[n2] = sum1s[n2] + value;
                    int n3 = index;
                    sum2s[n3] = sum2s[n3] + value * value;
                }

                @Override
                public double getBinResultInt(int index) {
                    return StdevCombiner.getStdev(StdevCombiner.this.isSampleStdev_, counts[index], sum1s[index], sum2s[index]);
                }
            };
        }

        @Override
        public Container createContainer() {
            return this.isSampleStdev_ ? new SampleStdevContainer() : new PopulationStdevContainer();
        }

        @Override
        public ValueInfo createCombinedInfo(ValueInfo dataInfo) {
            DefaultValueInfo info = new DefaultValueInfo(dataInfo.getName() + "_stdev", Double.class, (this.isSampleStdev_ ? "Sample " : "Population ") + "standard deviation of " + Combiner.getInfoDescription(dataInfo));
            info.setUnitString(dataInfo.getUnitString());
            info.setUCD(Combiner.modifyUcd(dataInfo.getUCD(), "stat.stdev", true));
            return info;
        }

        private static double getStdev(boolean isSampleStdev, int count, double sum1, double sum2) {
            if (count < (isSampleStdev ? 2 : 1)) {
                return Double.NaN;
            }
            double dcount = count;
            double nvar = sum2 - sum1 * sum1 / dcount;
            double divisor = isSampleStdev ? dcount - 1.0 : dcount;
            return Math.sqrt(nvar / divisor);
        }

        private static class SampleStdevContainer
        extends StdevContainer {
            private SampleStdevContainer() {
            }

            @Override
            public double getResult() {
                return StdevCombiner.getStdev(true, this.count_, this.sum1_, this.sum2_);
            }
        }

        private static class PopulationStdevContainer
        extends StdevContainer {
            private PopulationStdevContainer() {
            }

            @Override
            public double getResult() {
                return StdevCombiner.getStdev(false, this.count_, this.sum1_, this.sum2_);
            }
        }

        private static abstract class StdevContainer
        implements Container {
            int count_;
            double sum1_;
            double sum2_;

            private StdevContainer() {
            }

            @Override
            public void submit(double datum) {
                ++this.count_;
                this.sum1_ += datum;
                this.sum2_ += datum * datum;
            }
        }
    }

    private static class MedianCombiner
    extends QuantileCombiner {
        MedianCombiner() {
            super("median", "the median of the combined values (may be slow)", new QuantileCombiner.Quantiler(){

                @Override
                public double calculateValue(double[] sortedValues) {
                    int nv = sortedValues.length;
                    if (nv % 2 == 1) {
                        return sortedValues[nv / 2];
                    }
                    if (nv > 0) {
                        int nv2 = nv / 2;
                        return 0.5 * (sortedValues[nv2 - 1] + sortedValues[nv2]);
                    }
                    return Double.NaN;
                }
            });
        }

        @Override
        public ValueInfo createCombinedInfo(ValueInfo dataInfo) {
            DefaultValueInfo info = new DefaultValueInfo(dataInfo);
            info.setContentClass(Double.class);
            info.setDescription(Combiner.getInfoDescription(dataInfo) + ", median value in bin");
            info.setUCD(Combiner.modifyUcd(dataInfo.getUCD(), "stat.median", false));
            return info;
        }
    }

    private static class MeanCombiner
    extends AbstractCombiner {
        public MeanCombiner() {
            super("mean", "the mean of the combined values", true);
        }

        @Override
        public BinList createArrayBinList(int size) {
            final int[] counts = new int[size];
            final double[] sums = new double[size];
            return new ArrayBinList(size, this){

                @Override
                public void submitToBinInt(int index, double value) {
                    int n = index;
                    counts[n] = counts[n] + 1;
                    int n2 = index;
                    sums[n2] = sums[n2] + value;
                }

                @Override
                public double getBinResultInt(int index) {
                    int count = counts[index];
                    return count == 0 ? Double.NaN : sums[index] / (double)count;
                }
            };
        }

        @Override
        public Container createContainer() {
            return new MeanContainer();
        }

        @Override
        public ValueInfo createCombinedInfo(ValueInfo dataInfo) {
            DefaultValueInfo info = new DefaultValueInfo(dataInfo);
            info.setContentClass(Double.class);
            info.setDescription(Combiner.getInfoDescription(dataInfo) + ", mean value in bin");
            info.setUCD(Combiner.modifyUcd(dataInfo.getUCD(), "stat.mean", false));
            return info;
        }

        private static class MeanContainer
        implements Container {
            int count_;
            double sum_;

            private MeanContainer() {
            }

            @Override
            public void submit(double datum) {
                ++this.count_;
                this.sum_ += datum;
            }

            @Override
            public double getResult() {
                return this.count_ == 0 ? Double.NaN : this.sum_ / (double)this.count_;
            }
        }
    }

    private static abstract class AbstractCombiner
    extends Combiner {
        AbstractCombiner(String name, String description, boolean hasBigBin) {
            super(name, description, hasBigBin);
        }

        @Override
        public BinList createHashBinList(long size) {
            return new HashBinList(size, this);
        }
    }

    public static interface Container {
        public void submit(double var1);

        public double getResult();
    }
}

