/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.PointCloud;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.SubCloud;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.DoubleConfigKey;
import uk.ac.starlink.ttools.plot2.config.IntegerConfigKey;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotter;
import uk.ac.starlink.ttools.plot2.layer.BinPlan;
import uk.ac.starlink.ttools.plot2.layer.Binner;
import uk.ac.starlink.ttools.plot2.layer.ContourStyle;
import uk.ac.starlink.ttools.plot2.layer.Gridder;
import uk.ac.starlink.ttools.plot2.layer.LevelMode;
import uk.ac.starlink.ttools.plot2.layer.NumberArray;
import uk.ac.starlink.ttools.plot2.layer.ShapeMode;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;

public class ContourPlotter
extends AbstractPlotter<ContourStyle> {
    private static final ConfigKey<Integer> NLEVEL_KEY = IntegerConfigKey.createSpinnerKey(new ConfigMeta("nlevel", "Level Count").setShortDescription("Maximum number of contours").setXmlDescription(new String[]{"<p>Number of countour lines drawn.", "In fact, this is an upper limit;", "if there is not enough variation in the plot's density,", "then fewer conrour lines will be drawn.", "</p>"}), 5, 0, 999);
    private static final ConfigKey<Integer> SMOOTH_KEY = IntegerConfigKey.createSpinnerKey(new ConfigMeta("smooth", "Smoothing").setStringUsage("<pixels>").setShortDescription("Smoothing kernel size in pixels").setXmlDescription(new String[]{"<p>The size of the smoothing kernel applied to the", "density before performing the contour determination.", "If set too low the contours will be too crinkly,", "and if too high they will lose definition.", "</p>"}), 4, 1, 40);
    private static final ConfigKey<Double> OFFSET_KEY = DoubleConfigKey.createSliderKey(new ConfigMeta("zero", "Zero Point").setShortDescription("Level of first contour").setXmlDescription(new String[]{"<p>Determines the level at which the first contour", "(and hence all the others, which are separated from it", "by a fixed amount) are drawn.", "</p>"}), 0.0, -2.0, 2.0, false);
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2");

    public ContourPlotter() {
        super("Contour", ResourceIcon.PLOT_CONTOUR, 1, new Coord[0]);
    }

    @Override
    public String getPlotterDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Plots position density contours.", "This provides another way", "(alongside the", ShapeMode.modeRef(ShapeMode.AUTO), "and", ShapeMode.modeRef(ShapeMode.DENSITY), "shading modes)", "to visualise the characteristics of overdense regions", "in a crowded plot.", "It's not very useful if you just have a few points.", "</p>", "<p>The contours are currently drawn as pixels rather than lines", "so they don't look very beautify in exported vector", "output formats (PDF, PostScript).", "This may be improved in the future.", "</p>"});
    }

    @Override
    public ConfigKey[] getStyleKeys() {
        return new ConfigKey[]{StyleKeys.COLOR, NLEVEL_KEY, SMOOTH_KEY, StyleKeys.LEVEL_MODE, OFFSET_KEY};
    }

    @Override
    public ContourStyle createStyle(ConfigMap config) {
        Color color = config.get(StyleKeys.COLOR);
        int nlevel = config.get(NLEVEL_KEY);
        double offset = (config.get(OFFSET_KEY) % 1.0 + 1.0) % 1.0;
        int nsmooth = config.get(SMOOTH_KEY);
        LevelMode levMode = config.get(StyleKeys.LEVEL_MODE);
        return new ContourStyle(color, nlevel, offset, nsmooth, levMode);
    }

    @Override
    public PlotLayer createLayer(DataGeom geom, DataSpec dataSpec, final ContourStyle style) {
        final PointCloud pointCloud = new PointCloud(new SubCloud(geom, dataSpec, 0));
        LayerOpt opt = new LayerOpt(style.getColor(), true);
        return new AbstractPlotLayer(this, geom, dataSpec, style, opt){

            @Override
            public Drawing createDrawing(Surface surface, Map<AuxScale, Range> auxRanges, PaperType paperType) {
                if (!paperType.isBitmap()) {
                    logger_.warning("Sorry - contours are ugly in vector plots");
                }
                return new BitmapContourDrawing(surface, pointCloud, style, paperType);
            }
        };
    }

    private static NumberArray smooth(NumberArray inArray, Gridder gridder, int smooth) {
        int nx = gridder.getWidth();
        int ny = gridder.getHeight();
        final float[] out = new float[gridder.getLength()];
        int lo = -smooth / 2;
        int hi = (smooth + 1) / 2;
        for (int px = lo; px < hi; ++px) {
            for (int py = lo; py < hi; ++py) {
                int ix0 = Math.max(0, px);
                int ix1 = Math.min(nx, nx + px);
                int iy0 = Math.max(0, py);
                int iy1 = Math.min(ny, ny + py);
                for (int iy = iy0; iy < iy1; ++iy) {
                    int jy = iy - py;
                    for (int ix = ix0; ix < ix1; ++ix) {
                        int jx = ix - px;
                        int n = gridder.getIndex(ix, iy);
                        out[n] = (float)((double)out[n] + inArray.getValue(gridder.getIndex(jx, jy)));
                    }
                }
            }
        }
        float factor = 1.0f / (float)((hi - lo) * (hi - lo));
        int i = 0;
        while (i < out.length) {
            int n = i++;
            out[n] = out[n] * factor;
        }
        return new NumberArray(){

            @Override
            public int getLength() {
                return out.length;
            }

            @Override
            public double getValue(int i) {
                return out[i];
            }
        };
    }

    private static Leveller createLeveller(NumberArray array, ContourStyle style) {
        final double[] levels = style.getLevelMode().calculateLevels(array, style.getLevelCount(), style.getOffset(), true);
        return new Leveller(){

            @Override
            public int getLevel(double count) {
                int ipos = Arrays.binarySearch(levels, count);
                return ipos < 0 ? -(ipos + 1) : ipos;
            }
        };
    }

    private static interface Leveller {
        public int getLevel(double var1);
    }

    private static class BitmapContourDrawing
    implements Drawing {
        private final Surface surface_;
        private final PointCloud pointCloud_;
        private final ContourStyle style_;
        private final PaperType paperType_;

        BitmapContourDrawing(Surface surface, PointCloud pointCloud, ContourStyle style, PaperType paperType) {
            this.surface_ = surface;
            this.pointCloud_ = pointCloud;
            this.style_ = style;
            this.paperType_ = paperType;
        }

        @Override
        public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
            return BinPlan.calculatePointCloudPlan(this.pointCloud_, this.surface_, dataStore, knownPlans);
        }

        @Override
        public void paintData(final Object plan, Paper paper, final DataStore dataStore) {
            this.paperType_.placeDecal(paper, new Decal(){

                @Override
                public void paintDecal(Graphics g) {
                    BitmapContourDrawing.this.paintContours(g, (BinPlan)plan, dataStore);
                }

                @Override
                public boolean isOpaque() {
                    return true;
                }
            });
        }

        @Override
        public ReportMap getReport(Object plan) {
            return null;
        }

        private void paintContours(Graphics g, BinPlan binPlan, DataStore dataStore) {
            int lev1;
            int lev0;
            final Binner binner = binPlan.getBinner();
            Gridder gridder = binPlan.getGridder();
            Color color0 = g.getColor();
            g.setColor(this.style_.getColor());
            Rectangle bounds = this.surface_.getPlotBounds();
            int xoff = bounds.x;
            int yoff = bounds.y;
            int nx = gridder.getWidth();
            int ny = gridder.getHeight();
            final int leng = gridder.getLength();
            NumberArray array = new NumberArray(){

                @Override
                public int getLength() {
                    return leng;
                }

                @Override
                public double getValue(int index) {
                    return binner.getCount(index);
                }
            };
            int smooth = this.style_.getSmoothing();
            if (smooth > 1) {
                array = ContourPlotter.smooth(array, gridder, smooth);
            }
            Leveller leveller = ContourPlotter.createLeveller(array, this.style_);
            for (int ix = 0; ix < nx; ++ix) {
                lev0 = leveller.getLevel(array.getValue(gridder.getIndex(ix, 0)));
                for (int iy = 1; iy < ny; ++iy) {
                    lev1 = leveller.getLevel(array.getValue(gridder.getIndex(ix, iy)));
                    if (lev1 != lev0) {
                        g.fillRect(xoff + ix, yoff + iy - 1, 1, 1);
                    }
                    lev0 = lev1;
                }
            }
            for (int iy = 0; iy < ny; ++iy) {
                lev0 = leveller.getLevel(array.getValue(gridder.getIndex(0, iy)));
                for (int ix = 1; ix < nx; ++ix) {
                    lev1 = leveller.getLevel(array.getValue(gridder.getIndex(ix, iy)));
                    if (lev1 != lev0) {
                        g.fillRect(xoff + ix - 1, yoff + iy, 1, 1);
                    }
                    lev0 = lev1;
                }
            }
            g.setColor(color0);
        }
    }
}

