/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.layer.LevelMode;

@Equality
public class ContourStyle
implements Style {
    private final Color color_;
    private final int nLevel_;
    private final double offset_;
    private final int nSmooth_;
    private final LevelMode levelMode_;

    public ContourStyle(Color color, int nLevel, double offset, int nSmooth, LevelMode levelMode) {
        this.color_ = color;
        this.nLevel_ = nLevel;
        this.offset_ = offset;
        this.nSmooth_ = nSmooth;
        this.levelMode_ = levelMode;
    }

    public Color getColor() {
        return this.color_;
    }

    public int getLevelCount() {
        return this.nLevel_;
    }

    public double getOffset() {
        return this.offset_;
    }

    public int getSmoothing() {
        return this.nSmooth_;
    }

    public LevelMode getLevelMode() {
        return this.levelMode_;
    }

    @Override
    public Icon getLegendIcon() {
        return new Icon(){
            private static final int width_ = 12;
            private static final int height_ = 12;

            @Override
            public int getIconWidth() {
                return 12;
            }

            @Override
            public int getIconHeight() {
                return 12;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Color color = g.getColor();
                g.setColor(ContourStyle.this.color_);
                g.drawOval(x, y, 12, 12);
                g.drawOval(x + 2, y + 3, 8, 6);
                g.setColor(color);
            }
        };
    }

    public int hashCode() {
        int code = 23037;
        code = code * 23 + this.color_.hashCode();
        code = code * 23 + this.nLevel_;
        code = code * 23 + Float.floatToIntBits((float)this.offset_);
        code = code * 23 + this.nSmooth_;
        code = code * 23 + this.levelMode_.hashCode();
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof ContourStyle) {
            ContourStyle other = (ContourStyle)o;
            return this.color_.equals(other.color_) && this.nLevel_ == other.nLevel_ && this.offset_ == other.offset_ && this.nSmooth_ == other.nSmooth_ && this.levelMode_ == other.levelMode_;
        }
        return false;
    }
}

