/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import uk.ac.starlink.ttools.plot2.Scaler;
import uk.ac.starlink.ttools.plot2.Scaling;

public class CountScaler {
    private final Scaler scaler_;
    private final double outFactor_;
    private final int nLookup_;
    private final int[] lookup_;
    private static final int MAX_LOOKUP = 256;

    public CountScaler(Scaling scaling, int maxIn, int maxOut) {
        this.scaler_ = scaling.createScaler(1.0, maxIn);
        this.outFactor_ = (double)maxOut - 0.1;
        this.nLookup_ = Math.min(maxIn, 256);
        this.lookup_ = new int[this.nLookup_];
        for (int i = 0; i < this.nLookup_; ++i) {
            this.lookup_[i] = this.calculateScaledCount(i);
        }
    }

    public int scaleCount(int count) {
        return count < this.nLookup_ ? this.lookup_[count] : this.calculateScaledCount(count);
    }

    private int calculateScaledCount(int count) {
        return count == 0 ? 0 : 1 + (int)(this.scaler_.scaleValue(count) * this.outFactor_);
    }
}

