/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.layer.Binner;
import uk.ac.starlink.ttools.plot2.layer.Gridder;

public class FillPlan {
    private final Binner binner_;
    private final Gridder gridder_;
    private final int[] xlos_;
    private final int[] xhis_;
    private final int[] ylos_;
    private final int[] yhis_;
    private final Point cpXlo_;
    private final Point cpXhi_;
    private final Point cpYlo_;
    private final Point cpYhi_;
    private final DataGeom geom_;
    private final DataSpec dataSpec_;
    private final Surface surface_;

    FillPlan(Binner binner, Gridder gridder, int[] xlos, int[] xhis, int[] ylos, int[] yhis, Point cpXlo, Point cpXhi, Point cpYlo, Point cpYhi, DataGeom geom, DataSpec dataSpec, Surface surface) {
        this.binner_ = binner;
        this.gridder_ = gridder;
        this.xlos_ = xlos;
        this.xhis_ = xhis;
        this.ylos_ = ylos;
        this.yhis_ = yhis;
        this.cpXlo_ = cpXlo;
        this.cpXhi_ = cpXhi;
        this.cpYlo_ = cpYlo;
        this.cpYhi_ = cpYhi;
        this.geom_ = geom;
        this.dataSpec_ = dataSpec;
        this.surface_ = surface;
    }

    public Binner getBinner() {
        return this.binner_;
    }

    public Gridder getGridder() {
        return this.gridder_;
    }

    public int[] getXlos() {
        return this.xlos_;
    }

    public int[] getXhis() {
        return this.xhis_;
    }

    public int[] getYlos() {
        return this.ylos_;
    }

    public int[] getYhis() {
        return this.yhis_;
    }

    public Point getCpXlo() {
        return this.cpXlo_;
    }

    public Point getCpXhi() {
        return this.cpXhi_;
    }

    public Point getCpYlo() {
        return this.cpYlo_;
    }

    public Point getCpYhi() {
        return this.cpYhi_;
    }

    public boolean matches(DataGeom geom, DataSpec dataSpec, Surface surface) {
        return this.geom_.equals(geom) && this.dataSpec_.equals(dataSpec) && this.surface_.equals(surface);
    }

    public static FillPlan createPlan(Surface surface, DataSpec dataSpec, DataGeom geom, int icPos, DataStore dataStore) {
        double[] dpos = new double[surface.getDataDimCount()];
        Point2D.Double gp = new Point2D.Double();
        Rectangle bounds = surface.getPlotBounds();
        Gridder gridder = new Gridder(bounds.width, bounds.height);
        Binner binner = new Binner(gridder.getLength());
        int x0 = bounds.x;
        int y0 = bounds.y;
        int nx = bounds.width;
        int ny = bounds.height;
        int[] xlos = new int[nx];
        int[] xhis = new int[nx];
        int[] ylos = new int[ny];
        int[] yhis = new int[ny];
        Point cpXlo = null;
        Point cpXhi = null;
        Point cpYlo = null;
        Point cpYhi = null;
        TupleSequence tseq = dataStore.getTupleSequence(dataSpec);
        while (tseq.next()) {
            boolean inY;
            if (!geom.readDataPos(tseq, icPos, dpos) || !surface.dataToGraphics(dpos, false, gp) || !PlotUtil.isPointReal(gp)) continue;
            int x = (int)gp.x - x0;
            int y = (int)gp.y - y0;
            boolean inX = x >= 0 && x < nx;
            boolean bl = inY = y >= 0 && y < ny;
            if (inX && inY) {
                binner.increment(gridder.getIndex(x, y));
                continue;
            }
            if (inX) {
                if (y < 0) {
                    int n = x;
                    xlos[n] = xlos[n] + 1;
                    if (cpYlo != null && y <= cpYlo.y) continue;
                    cpYlo = new Point(x, y);
                    continue;
                }
                int n = x;
                xhis[n] = xhis[n] + 1;
                if (cpYhi != null && y >= cpYhi.y) continue;
                cpYhi = new Point(x, y);
                continue;
            }
            if (!inY) continue;
            if (x < 0) {
                int n = y;
                ylos[n] = ylos[n] + 1;
                if (cpXlo != null && x <= cpXlo.x) continue;
                cpXlo = new Point(x, y);
                continue;
            }
            int n = y;
            yhis[n] = yhis[n] + 1;
            if (cpXhi != null && x >= cpXhi.x) continue;
            cpXhi = new Point(x, y);
        }
        return new FillPlan(binner, gridder, xlos, xhis, ylos, yhis, cpXlo, cpXhi, cpYlo, cpYhi, geom, dataSpec, surface);
    }
}

