/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.BooleanConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotter;
import uk.ac.starlink.ttools.plot2.layer.Binner;
import uk.ac.starlink.ttools.plot2.layer.FillPlan;
import uk.ac.starlink.ttools.plot2.layer.Gridder;
import uk.ac.starlink.ttools.plot2.layer.PixelImage;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;

public class FillPlotter
extends AbstractPlotter<FillStyle> {
    private final boolean hasHorizontal_;
    public static final ConfigKey<Boolean> HORIZONTAL_KEY = new BooleanConfigKey(new ConfigMeta("horizontal", "Horizontal").setShortDescription("Horizontal fill?").setXmlDescription(new String[]{"<p>Determines whether the filling is vertical", "(suitable for functions of the horizontal variable),", "or horizontal", "(suitable for functions of the vertical variable).", "If false, the fill is vertical (to the X axis),", "and if true, the fill is horizontal (to the Y axis).", "</p>"}), false);
    public static final ConfigKey<Boolean> POSITIVE_KEY = new BooleanConfigKey(new ConfigMeta("positive", "Positive").setShortDescription("Fill in positive direction?").setXmlDescription(new String[]{"<p>Determines the directional sense of the filling.", "If false, the fill is between the data points", "and negative infinity along the relevant axis", "(e.g. down from the data points to the bottom of the plot).", "If true, the fill is in the other direction.", "</p>"}), false);

    public FillPlotter(boolean hasHorizontal) {
        super("Fill", ResourceIcon.FORM_FILL, 1, new Coord[0]);
        this.hasHorizontal_ = hasHorizontal;
    }

    @Override
    public String getPlotterDescription() {
        return PlotUtil.concatLines(new String[]{"<p>If a two-dimensional dataset represents a single-valued", "function, this plotter will fill the area underneath the", "function's curve with a solid colour.", "Parts of the surface which would only be partially covered", "(because of rapid function variation within the width", "of a single pixel)", "are represented using appropriate alpha-blending.", "The filled area may alternatively be that above the curve" + (this.hasHorizontal_ ? " or to its left or right." : "."), "</p>", "<p>One example of its use is to reconstruct the appearance", "of a histogram plot from a set of histogram bins.", "For X,Y data which is not single-valued, the result", "may not be very useful.", "</p>"});
    }

    @Override
    public ConfigKey[] getStyleKeys() {
        ArrayList<ConfigKey<Serializable>> list = new ArrayList<ConfigKey<Serializable>>();
        list.add(StyleKeys.COLOR);
        list.add(StyleKeys.TRANSPARENCY);
        if (this.hasHorizontal_) {
            list.add(HORIZONTAL_KEY);
        }
        list.add(POSITIVE_KEY);
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public FillStyle createStyle(ConfigMap config) {
        Color color = StyleKeys.getAlphaColor(config, StyleKeys.COLOR, StyleKeys.TRANSPARENCY);
        boolean isHorizontal = config.get(HORIZONTAL_KEY);
        boolean isPositive = config.get(POSITIVE_KEY);
        return new FillStyle(color, isHorizontal, isPositive);
    }

    @Override
    public PlotLayer createLayer(final DataGeom geom, final DataSpec dataSpec, final FillStyle style) {
        if (dataSpec == null || style == null) {
            return null;
        }
        Color color = style.color_;
        LayerOpt layerOpt = new LayerOpt(color, false);
        return new AbstractPlotLayer(this, geom, dataSpec, style, layerOpt){
            final boolean isHorizontal;
            final int icPos;
            {
                super(x0, x1, x2, x3, x4);
                this.isHorizontal = style.isHorizontal_;
                this.icPos = FillPlotter.this.getCoordGroup().getPosCoordIndex(0, geom);
            }

            @Override
            public Drawing createDrawing(final Surface surface, Map<AuxScale, Range> auxRanges, final PaperType paperType) {
                return new Drawing(){

                    @Override
                    public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
                        for (Object plan : knownPlans) {
                            if (!(plan instanceof FillPlan) || !((FillPlan)plan).matches(geom, dataSpec, surface)) continue;
                            return plan;
                        }
                        return FillPlan.createPlan(surface, dataSpec, geom, icPos, dataStore);
                    }

                    @Override
                    public void paintData(Object plan, Paper paper, DataStore dataStore) {
                        final FillPlan fplan = (FillPlan)plan;
                        paperType.placeDecal(paper, new Decal(){

                            @Override
                            public void paintDecal(Graphics g) {
                                FillPlotter.this.paintFill(surface, fplan, style, g);
                            }

                            @Override
                            public boolean isOpaque() {
                                return false;
                            }
                        });
                    }

                    @Override
                    public ReportMap getReport(Object plan) {
                        return null;
                    }
                };
            }
        };
    }

    private void paintFill(Surface surface, FillPlan plan, FillStyle style, Graphics g) {
        int iy;
        Gridder gridder;
        Point cpXhi;
        Point cpXlo;
        int[] yhis;
        int[] ylos;
        int[] xhis;
        int[] xlos;
        IndexColorModel colorModel = FillPlotter.createAlphaColorModel(style.color_);
        int nlevel = colorModel.getMapSize();
        boolean isHorizontal = style.isHorizontal_;
        boolean invert = isHorizontal ^ style.isPositive_;
        Binner binner = plan.getBinner();
        if (isHorizontal) {
            xlos = plan.getYlos();
            xhis = plan.getYhis();
            ylos = plan.getXlos();
            yhis = plan.getXhis();
            cpXlo = FillPlotter.transposePoint(plan.getCpYlo());
            cpXhi = FillPlotter.transposePoint(plan.getCpYhi());
            gridder = Gridder.transpose(plan.getGridder());
        } else {
            xlos = plan.getXlos();
            xhis = plan.getXhis();
            ylos = plan.getYlos();
            yhis = plan.getYhis();
            cpXlo = plan.getCpXlo();
            cpXhi = plan.getCpXhi();
            gridder = plan.getGridder();
        }
        int nx = gridder.getWidth();
        int ny = gridder.getHeight();
        int[] pixels = new int[gridder.getLength()];
        boolean[] hasDatas = new boolean[nx];
        for (int ix = 0; ix < nx; ++ix) {
            int count = xlos[ix];
            for (int iy2 = 0; iy2 < ny; ++iy2) {
                count += binner.getCount(gridder.getIndex(ix, iy2));
            }
            if ((count += xhis[ix]) <= 0) continue;
            hasDatas[ix] = true;
            double factor = (double)(nlevel - 1) / (double)count;
            int sum = (invert ? xhis : xlos)[ix];
            for (iy = 0; iy < ny; ++iy) {
                int jy = invert ? ny - 1 - iy : iy;
                int ig = gridder.getIndex(ix, jy);
                pixels[ig] = (int)(factor * (double)(sum += binner.getCount(ig)));
            }
        }
        int kx = -1;
        for (int ix = 0; ix < nx; ++ix) {
            if (!hasDatas[ix]) continue;
            if (kx != ix - 1 && kx >= 0) {
                int mx = kx + (ix - kx) / 2;
                for (int jx = kx + 1; jx < ix; ++jx) {
                    int lx = jx <= mx ? kx : ix;
                    for (iy = 0; iy < ny; ++iy) {
                        pixels[gridder.getIndex((int)jx, (int)iy)] = pixels[gridder.getIndex(lx, iy)];
                    }
                }
            }
            kx = ix;
        }
        boolean hasUnplottedLo = false;
        boolean hasUnplottedHi = false;
        for (int iy3 = 0; iy3 < ny; ++iy3) {
            hasUnplottedLo = hasUnplottedLo || ylos[iy3] > 0;
            hasUnplottedHi = hasUnplottedHi || yhis[iy3] > 0;
        }
        if (hasUnplottedLo || hasUnplottedHi) {
            int iy4;
            int ix;
            int kxlo = -1;
            int kxhi = nx;
            for (ix = 0; ix < nx; ++ix) {
                if (!hasDatas[ix]) continue;
                kxhi = ix;
                if (kxlo >= 0) continue;
                kxlo = ix;
            }
            if (hasUnplottedLo && kxlo > 0) {
                for (ix = 0; ix < kxlo; ++ix) {
                    for (iy4 = 0; iy4 < ny; ++iy4) {
                        pixels[gridder.getIndex((int)ix, (int)iy4)] = pixels[gridder.getIndex(kxlo, iy4)];
                    }
                }
            }
            if (hasUnplottedHi && kxhi < nx - 1) {
                for (ix = kxhi + 1; ix < nx; ++ix) {
                    for (iy4 = 0; iy4 < ny; ++iy4) {
                        pixels[gridder.getIndex((int)ix, (int)iy4)] = pixels[gridder.getIndex(kxhi, iy4)];
                    }
                }
            }
            if (kxlo < 0 && kxhi >= nx && cpXlo != null && cpXhi != null) {
                for (ix = 0; ix < nx; ++ix) {
                    for (iy4 = 0; iy4 < ny; ++iy4) {
                        Point closest = ix - cpXlo.x < cpXhi.x - ix ? cpXlo : cpXhi;
                        boolean isFill = invert ^ iy4 > closest.y;
                        pixels[gridder.getIndex((int)ix, (int)iy4)] = isFill ? nlevel - 1 : 0;
                    }
                }
            }
        }
        Rectangle bounds = surface.getPlotBounds();
        new PixelImage(bounds.getSize(), pixels, colorModel).paintPixels(g, bounds.getLocation());
    }

    private static Point transposePoint(Point gp) {
        return gp == null ? null : new Point(gp.y, gp.x);
    }

    private static IndexColorModel createAlphaColorModel(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        int alpha = color.getAlpha();
        int size = alpha + 1;
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        byte[] a = new byte[size];
        for (int i = 0; i < size; ++i) {
            r[i] = (byte)red;
            g[i] = (byte)green;
            b[i] = (byte)blue;
            a[i] = (byte)i;
        }
        return new IndexColorModel(8, size, r, g, b, a);
    }

    public static class FillStyle
    implements Style {
        private final Color color_;
        private final boolean isHorizontal_;
        private final boolean isPositive_;

        public FillStyle(Color color, boolean isHorizontal, boolean isPositive) {
            this.color_ = color;
            this.isHorizontal_ = isHorizontal;
            this.isPositive_ = isPositive;
        }

        @Override
        public Icon getLegendIcon() {
            final int[] data = new int[]{2, 5, 7, 9, 10, 11, 10, 9, 7, 5, 2};
            int h = 12;
            return new Icon(){

                @Override
                public int getIconWidth() {
                    return FillStyle.this.isHorizontal_ ? data.length : 12;
                }

                @Override
                public int getIconHeight() {
                    return FillStyle.this.isHorizontal_ ? 12 : data.length;
                }

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    Color color0 = g.getColor();
                    g.setColor(FillStyle.this.color_);
                    for (int i = 0; i < data.length; ++i) {
                        int d = data[i];
                        if (FillStyle.this.isHorizontal_) {
                            g.drawRect(x + (FillStyle.this.isPositive_ ? 12 - d : 0), y + i, d, 1);
                            continue;
                        }
                        g.drawRect(x + i, y + (FillStyle.this.isPositive_ ? 0 : 12 - d), 1, d);
                    }
                    g.setColor(color0);
                }
            };
        }

        public int hashCode() {
            int code = 222552;
            code = 23 * code + this.color_.hashCode();
            code = 23 * code + (this.isHorizontal_ ? 3 : 5);
            code = 23 * code + (this.isPositive_ ? 7 : 11);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof FillStyle) {
                FillStyle other = (FillStyle)o;
                return this.color_.equals(other.color_) && this.isHorizontal_ == other.isHorizontal_ && this.isPositive_ == other.isPositive_;
            }
            return false;
        }
    }
}

