/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.geom.Point2D;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;

public class FloatingCoordAuxReader
implements AuxReader {
    private final FloatingCoord coord_;
    private final int icol_;
    private final DataGeom geom_;
    private final boolean visibleOnly_;
    private final double[] dpos_;
    private final Point2D.Double gpos_;

    public FloatingCoordAuxReader(FloatingCoord coord, int icol, DataGeom geom, boolean visibleOnly) {
        this.coord_ = coord;
        this.icol_ = icol;
        this.geom_ = geom;
        this.visibleOnly_ = visibleOnly;
        this.dpos_ = new double[geom.getDataDimCount()];
        this.gpos_ = new Point2D.Double();
    }

    @Override
    public int getCoordIndex() {
        return this.icol_;
    }

    @Override
    public void adjustAuxRange(Surface surface, DataSpec dataSpec, DataStore dataStore, Object[] plans, Range range) {
        TupleSequence tseq = dataStore.getTupleSequence(dataSpec);
        while (tseq.next()) {
            if (!this.geom_.readDataPos(tseq, 0, this.dpos_) || !surface.dataToGraphics(this.dpos_, this.visibleOnly_, this.gpos_) || !this.visibleOnly_ && !PlotUtil.isPointFinite(this.gpos_)) continue;
            double value = this.coord_.readDoubleCoord(tseq, this.icol_);
            range.submit(value);
        }
    }
}

