/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Rectangle;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.layer.Pixers;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType2D;

public abstract class GlyphPaper
implements Paper {
    private final Rectangle bounds_;
    private final GlyphPaperType paperType_;

    public GlyphPaper(Rectangle plotBounds) {
        this.bounds_ = new Rectangle(plotBounds);
        this.paperType_ = new GlyphPaperType();
    }

    public abstract void glyphPixels(Pixer var1);

    @Override
    public PaperType2D getPaperType() {
        return this.paperType_;
    }

    private class GlyphPaperType
    implements PaperType2D {
        private GlyphPaperType() {
        }

        @Override
        public void placeGlyph(Paper paper, double dx, double dy, Glyph glyph, Color color) {
            int gx = PlotUtil.ifloor(dx);
            int gy = PlotUtil.ifloor(dy);
            Rectangle cbox = new Rectangle(GlyphPaper.this.bounds_);
            cbox.translate(-gx, -gy);
            Pixer pixer = glyph.createPixer(cbox);
            if (pixer != null) {
                GlyphPaper.this.glyphPixels(Pixers.translate(pixer, gx, gy));
            }
        }

        @Override
        public boolean isBitmap() {
            return true;
        }

        @Override
        public void placeDecal(Paper paper, Decal decal) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Icon createDataIcon(Surface surface, Drawing[] drawing, Object[] plans, DataStore dataStore, boolean requireCached) {
            throw new UnsupportedOperationException();
        }
    }
}

