/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import uk.ac.starlink.ttools.plot2.Pixer;

public class GreyImage {
    private final BufferedImage image_;
    private final byte[] buffer_;

    private GreyImage(BufferedImage image, byte[] buffer) {
        this.image_ = image;
        this.buffer_ = buffer;
    }

    public BufferedImage getImage() {
        return this.image_;
    }

    public byte[] getBuffer() {
        return this.buffer_;
    }

    public Pixer createPixer() {
        final int npix = this.buffer_.length;
        final int width = this.image_.getWidth();
        return new Pixer(){
            int ip = -1;

            @Override
            public boolean next() {
                while (++this.ip < npix) {
                    if (GreyImage.this.buffer_[this.ip] == 0) continue;
                    return true;
                }
                return false;
            }

            @Override
            public int getX() {
                return this.ip % width;
            }

            @Override
            public int getY() {
                return this.ip / width;
            }
        };
    }

    public static GreyImage createGreyImage(int width, int height) {
        BufferedImage image = new BufferedImage(width, height, 10);
        byte[] buf = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        return new GreyImage(image, buf);
    }
}

