/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.Scaler;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.DoubleConfigKey;
import uk.ac.starlink.ttools.plot2.config.RampKeySet;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.layer.BinMapper;
import uk.ac.starlink.ttools.plot2.layer.BinSizer;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.Gridder;
import uk.ac.starlink.ttools.plot2.layer.PixelImage;
import uk.ac.starlink.ttools.plot2.layer.Rounding;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;

public class GridPlotter
implements Plotter<GridStyle> {
    private final boolean transparent_;
    private final boolean reportAuxKeys_;
    public static final ReportKey<Double> XBINWIDTH_KEY = GridPlotter.createBinWidthReportKey('x');
    public static final ReportKey<Double> YBINWIDTH_KEY = GridPlotter.createBinWidthReportKey('y');
    public static final ConfigKey<BinSizer> XBINSIZER_KEY = GridPlotter.createBinSizerConfigKey('x', XBINWIDTH_KEY);
    public static final ConfigKey<BinSizer> YBINSIZER_KEY = GridPlotter.createBinSizerConfigKey('y', YBINWIDTH_KEY);
    public static final ConfigKey<Double> XPHASE_KEY = GridPlotter.createPhaseKey('x');
    public static final ConfigKey<Double> YPHASE_KEY = GridPlotter.createPhaseKey('y');
    private static final AuxScale SCALE = AuxScale.COLOR;
    private static final RampKeySet RAMP_KEYS = StyleKeys.AUX_RAMP;
    private static final FloatingCoord WEIGHT_COORD = FloatingCoord.WEIGHT_COORD;
    public static final ConfigKey<Double> TRANSPARENCY_KEY = StyleKeys.TRANSPARENCY;
    private static final CoordGroup COORD_GROUP = CoordGroup.createCoordGroup(1, new Coord[]{FloatingCoord.WEIGHT_COORD});
    private static final double PADDING = 0.8;

    public GridPlotter(boolean transparent) {
        this.transparent_ = transparent;
        this.reportAuxKeys_ = false;
    }

    @Override
    public String getPlotterName() {
        return "Grid";
    }

    @Override
    public Icon getPlotterIcon() {
        return ResourceIcon.FORM_GRID;
    }

    @Override
    public CoordGroup getCoordGroup() {
        return COORD_GROUP;
    }

    @Override
    public boolean hasReports() {
        return false;
    }

    @Override
    public String getPlotterDescription() {
        StringBuffer sbuf = new StringBuffer().append("<p>Plots 2-d data aggregated into rectangular cells.\n").append("You can optionally use a weighting for the points,\n").append("and you can configure how the values are combined\n").append("to produce the output pixel values (colours).\n").append("You can use this plotter in various ways,\n").append("including as a 2-d histogram or weighted density map,\n").append("or to plot gridded data.\n").append("</p>\n").append("<p>The X and Y dimensions of the\n").append("grid cells (or equivalently histogram bins)\n").append("can be configured either\n").append("in terms of the data coordinates\n").append("or relative to the plot dimensions.\n").append("</p>\n");
        sbuf.append("<p>");
        if (this.reportAuxKeys_) {
            sbuf.append("There are additional options to adjust\n").append("the way data values are mapped to colours.\n");
        } else {
            sbuf.append("The way that data values are mapped\n").append("to colours is usually controlled by options\n").append("at the level of the plot itself,\n").append("rather than by per-layer configuration.\n");
        }
        sbuf.append("</p>\n");
        return sbuf.toString();
    }

    @Override
    public ConfigKey[] getStyleKeys() {
        ArrayList<ConfigKey<Double>> keyList = new ArrayList<ConfigKey<Double>>();
        keyList.add(XBINSIZER_KEY);
        keyList.add(YBINSIZER_KEY);
        keyList.add(StyleKeys.COMBINER);
        if (this.reportAuxKeys_) {
            keyList.addAll(Arrays.asList(RAMP_KEYS.getKeys()));
        }
        if (this.transparent_) {
            keyList.add(TRANSPARENCY_KEY);
        }
        keyList.add(XPHASE_KEY);
        keyList.add(YPHASE_KEY);
        return keyList.toArray(new ConfigKey[0]);
    }

    @Override
    public GridStyle createStyle(ConfigMap config) {
        BinSizer xSizer = config.get(XBINSIZER_KEY);
        BinSizer ySizer = config.get(YBINSIZER_KEY);
        double xPhase = config.get(XPHASE_KEY);
        double yPhase = config.get(YPHASE_KEY);
        Combiner combiner = config.get(StyleKeys.COMBINER);
        RampKeySet.Ramp ramp = RAMP_KEYS.createValue(config);
        Scaling scaling = ramp.getScaling();
        float scaleAlpha = 1.0f - config.get(TRANSPARENCY_KEY).floatValue();
        Shader shader = Shaders.fade(ramp.getShader(), scaleAlpha);
        return new GridStyle(xSizer, ySizer, xPhase, yPhase, scaling, shader, combiner);
    }

    @Override
    public PlotLayer createLayer(DataGeom geom, DataSpec dataSpec, GridStyle style) {
        return new GridLayer(this, geom, dataSpec, style);
    }

    private static ReportKey<Double> createBinWidthReportKey(char axname) {
        String sname = axname + "binwidth";
        String lname = GridPlotter.toUpperString(axname) + " Bin Width";
        return ReportKey.createDoubleKey(new ReportMeta(sname, lname), false);
    }

    private static ConfigKey<BinSizer> createBinSizerConfigKey(char axname, ReportKey<Double> widthRepKey) {
        String axName = GridPlotter.toUpperString(axname);
        ConfigMeta meta = new ConfigMeta(axname + "binsize", axName + " Bin Size");
        meta.setStringUsage("+<extent>|-<count>");
        meta.setShortDescription(axName + " bin size specification");
        meta.setXmlDescription(new String[]{"<p>Configures the extent of the density grid bins", "on the " + axName + " axis.", "</p>", "<p>If the supplied value is a positive number", "it is interpreted as a fixed size in data coordinates", "(if the " + axName + " axis is logarithmic,", "the value is a fixed factor).", "If it is a negative number, then it will be interpreted", "as the approximate number of bins to display across", "the plot in the " + axName + " direction", "(though an attempt is made to use only round numbers", "for bin sizes).", "</p>", "<p>When setting this value graphically,", "you can use either the slider to adjust the bin count", "or the numeric entry field to fix the bin size.", "</p>"});
        boolean allowZero = false;
        return BinSizer.createSizerConfigKey(meta, widthRepKey, 30, allowZero);
    }

    private static ConfigKey<Double> createPhaseKey(char axname) {
        String axName = GridPlotter.toUpperString(axname);
        ConfigMeta meta = new ConfigMeta(axname + "phase", axName + " Bin Phase");
        meta.setShortDescription(axName + " axis bin offset");
        meta.setXmlDescription(new String[]{"<p>Controls where the zero point on the " + axName + " axis", "is set.", "For instance if your bin size is 1,", "this value controls whether bin boundaries are at", "0, 1, 2, .. or 0.5, 1.5, 2.5, ... etc.", "</p>", "<p>A value of 0 (or any integer) will result in", "a bin boundary at X=0 (linear X axis)", "or X=1 (logarithmic X axis).", "A fractional value will give a bin boundary at", "that value multiplied by the bin width.", "</p>"});
        return DoubleConfigKey.createSliderKey(meta, 0.0, 0.0, 1.0, false);
    }

    private static String toUpperString(char axname) {
        return Character.valueOf(Character.toUpperCase(axname)).toString();
    }

    private static double getRoundedPixelWidth(Axis axis) {
        int[] glimits = axis.getGraphicsLimits();
        double gmid = 0.5 * (double)(glimits[0] + glimits[1]);
        double d1 = axis.graphicsToData(gmid - 0.5);
        double d2 = axis.graphicsToData(gmid + 0.5);
        double extent = Math.abs(axis.isLinear() ? d2 - d1 : d2 / d1);
        return (float)extent;
    }

    private static void paintBins(Graphics g, GridPixer pixer, BinList.Result binResult, Scaler scaler, IndexColorModel colorModel, PlanarSurface surface) {
        int ncolor = colorModel.getMapSize() - 1;
        Rectangle bounds = surface.getPlotBounds();
        int nx = bounds.width;
        int ny = bounds.height;
        int x0 = bounds.x;
        int y0 = bounds.y;
        Gridder gridder = new Gridder(nx, ny);
        int npix = gridder.getLength();
        int[] grid = new int[npix];
        Point2D.Double gp = new Point2D.Double();
        int ib0 = -1;
        int sval = -1;
        for (int ip = 0; ip < npix; ++ip) {
            gp.x = x0 + gridder.getX(ip);
            gp.y = y0 + gridder.getY(ip);
            double[] dpos = surface.graphicsToData(gp, null);
            int ib = pixer.getBinIndex(dpos);
            if (ib < 0) continue;
            if (ib != ib0) {
                ib0 = ib;
                double dval = binResult.getBinValue(ib);
                sval = Double.isNaN(dval) ? 0 : Math.min(1 + (int)(scaler.scaleValue(dval) * (double)ncolor), ncolor - 1);
            }
            grid[ip] = sval;
        }
        new PixelImage(new Dimension(nx, ny), grid, colorModel).paintPixels(g, new Point(x0, y0));
    }

    private static int[] getGraphicsBounds(int ibin, BinMapper mapper, Axis axis) {
        int[] nArray;
        int g1;
        double[] dlimits = mapper.getBinLimits(ibin);
        int g0 = (int)Math.floor(axis.dataToGraphics(dlimits[0]));
        if (g0 <= (g1 = (int)Math.floor(axis.dataToGraphics(dlimits[1])))) {
            int[] nArray2 = new int[2];
            nArray2[0] = g0;
            nArray = nArray2;
            nArray2[1] = g1;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = g1;
            nArray = nArray3;
            nArray3[1] = g0;
        }
        return nArray;
    }

    private static class GridSpec {
        final boolean isLog_;
        final double binWidth_;
        final double phase_;
        final double dlo_;
        final double dhi_;
        final BinMapper mapper_;
        final int ilo_;
        final int ihi_;

        GridSpec(boolean isLog, double binWidth, double phase, double[] drange) {
            this.isLog_ = isLog;
            this.binWidth_ = binWidth;
            this.phase_ = phase;
            this.mapper_ = BinMapper.createMapper(isLog, binWidth, phase, drange[0]);
            int i0 = this.mapper_.getBinIndex(drange[0]);
            int i1 = this.mapper_.getBinIndex(drange[1]);
            double[] dlimits0 = this.mapper_.getBinLimits(i0);
            double[] dlimits1 = this.mapper_.getBinLimits(i1);
            this.ilo_ = Math.min(i0, i1);
            this.ihi_ = Math.max(i0, i1);
            this.dlo_ = Math.min(dlimits0[0], dlimits1[0]);
            this.dhi_ = Math.max(dlimits0[1], dlimits1[1]);
        }

        boolean contains(GridSpec other) {
            return this.binWidth_ == other.binWidth_ && this.phase_ == other.phase_ && this.dlo_ <= other.dlo_ && this.dhi_ >= other.dhi_;
        }

        boolean containsDataPoint(double d) {
            return d >= this.dlo_ && d < this.dhi_;
        }

        boolean containsBin(int ibin) {
            return ibin >= this.ilo_ && ibin <= this.ihi_;
        }

        boolean nearlyContainsBin(int ibin) {
            return ibin >= this.ilo_ - 1 && ibin <= this.ihi_ + 1;
        }

        int getBinOffset(int ibin) {
            return ibin - this.ilo_;
        }

        int[] getBinRange(double[] dataRange) {
            int i0 = this.mapper_.getBinIndex(dataRange[0]);
            int i1 = this.mapper_.getBinIndex(dataRange[1]);
            return new int[]{Math.min(i0, i1), Math.max(i0, i1)};
        }
    }

    private static class GridPixer {
        private final GridSpec xgrid_;
        private final GridSpec ygrid_;
        private final Gridder gridder_;

        GridPixer(GridSpec xgrid, GridSpec ygrid) {
            this.xgrid_ = xgrid;
            this.ygrid_ = ygrid;
            this.gridder_ = new Gridder(xgrid.ihi_ - xgrid.ilo_ + 1, ygrid.ihi_ - ygrid.ilo_ + 1);
        }

        public int getBinCount() {
            return this.gridder_.getLength();
        }

        public int getBinIndex(double[] dpos) {
            double dx = dpos[0];
            double dy = dpos[1];
            if (this.xgrid_.containsDataPoint(dx) && this.ygrid_.containsDataPoint(dy)) {
                int ix = this.xgrid_.mapper_.getBinIndex(dx);
                int iy = this.ygrid_.mapper_.getBinIndex(dy);
                assert (this.xgrid_.nearlyContainsBin(ix) && this.ygrid_.nearlyContainsBin(iy));
                return this.getBinIndex(ix, iy);
            }
            return -1;
        }

        int getBinIndex(int ix, int iy) {
            return this.xgrid_.containsBin(ix) && this.ygrid_.containsBin(iy) ? this.gridder_.getIndex(this.xgrid_.getBinOffset(ix), this.ygrid_.getBinOffset(iy)) : -1;
        }

        boolean contains(GridPixer other) {
            return this.xgrid_.contains(other.xgrid_) && this.ygrid_.contains(other.ygrid_);
        }
    }

    private static class GridPlan {
        final GridPixer pixer_;
        final Combiner combiner_;
        final DataSpec dataSpec_;
        final DataGeom geom_;
        final BinList.Result result_;

        GridPlan(GridPixer pixer, Combiner combiner, DataSpec dataSpec, DataGeom geom, BinList.Result result) {
            this.pixer_ = pixer;
            this.combiner_ = combiner;
            this.dataSpec_ = dataSpec;
            this.geom_ = geom;
            this.result_ = result;
        }

        public boolean matches(GridPixer pixer, Combiner combiner, DataSpec dataSpec, DataGeom geom) {
            return this.pixer_.contains(pixer) && this.combiner_.equals(combiner) && this.dataSpec_.equals(dataSpec) && this.geom_.equals(geom);
        }
    }

    private static class GridLayer
    extends AbstractPlotLayer {
        private final GridStyle gstyle_;
        private final int icPos_;
        private final int icWeight_;

        GridLayer(GridPlotter plotter, DataGeom geom, DataSpec dataSpec, GridStyle style) {
            super(plotter, geom, dataSpec, style, LayerOpt.NO_SPECIAL);
            this.gstyle_ = style;
            this.icPos_ = COORD_GROUP.getPosCoordIndex(0, geom);
            this.icWeight_ = COORD_GROUP.getExtraCoordIndex(0, geom);
        }

        @Override
        public Drawing createDrawing(Surface surface, Map<AuxScale, Range> auxRanges, PaperType ptype) {
            return new GridDrawing((PlanarSurface)surface, auxRanges.get(SCALE), ptype);
        }

        @Override
        public Map<AuxScale, AuxReader> getAuxRangers() {
            HashMap<AuxScale, AuxReader> map = new HashMap<AuxScale, AuxReader>();
            map.put(SCALE, new AuxReader(){

                @Override
                public int getCoordIndex() {
                    return GridLayer.this.icWeight_;
                }

                @Override
                public void adjustAuxRange(Surface surface, DataSpec dataSpec, DataStore dataStore, Object[] plans, Range range) {
                    GridPixer pixer;
                    BinList.Result binResult;
                    PlanarSurface psurf = (PlanarSurface)surface;
                    GridPixer pixer0 = GridLayer.this.createGridPixer(psurf, 0.0);
                    GridPlan gridPlan = GridLayer.this.getGridPlan(plans, pixer0);
                    if (gridPlan != null) {
                        binResult = gridPlan.result_;
                        pixer = gridPlan.pixer_;
                    } else {
                        binResult = GridLayer.this.readBins(pixer0, dataSpec, dataStore).getResult();
                        pixer = pixer0;
                    }
                    GridLayer.this.extendRange(range, psurf, pixer, binResult);
                }
            });
            return map;
        }

        GridPixer createGridPixer(PlanarSurface surface, double fpad) {
            Subrange padder = new Subrange(0.0 - fpad, 1.0 + fpad);
            GridSpec[] grids = new GridSpec[2];
            BinSizer[] sizers = new BinSizer[]{this.gstyle_.xSizer_, this.gstyle_.ySizer_};
            double[] phases = new double[]{this.gstyle_.xPhase_, this.gstyle_.yPhase_};
            boolean[] logFlags = surface.getLogFlags();
            boolean[] timeFlags = surface.getTimeFlags();
            Axis[] axes = surface.getAxes();
            double[][] dataLimits = surface.getDataLimits();
            for (int i = 0; i < 2; ++i) {
                boolean isLog = logFlags[i];
                Rounding rounding = Rounding.getRounding(timeFlags[i]);
                double dlo = dataLimits[i][0];
                double dhi = dataLimits[i][1];
                double[] drange = PlotUtil.scaleRange(dlo, dhi, padder, isLog);
                double reqWidth = sizers[i].getWidth(isLog, dlo, dhi, rounding);
                double binWidth = Math.max(reqWidth, GridPlotter.getRoundedPixelWidth(axes[i]));
                double phase = phases[i];
                grids[i] = new GridSpec(isLog, binWidth, phase, drange);
            }
            return new GridPixer(grids[0], grids[1]);
        }

        private BinList readBins(GridPixer pixer, DataSpec dataSpec, DataStore dataStore) {
            int nbin = pixer.getBinCount();
            Combiner combiner = this.gstyle_.combiner_;
            BinList binList = combiner.createArrayBinList(nbin);
            TupleSequence tseq = dataStore.getTupleSequence(dataSpec);
            Point2D.Double gp = new Point2D.Double();
            DataGeom geom = this.getDataGeom();
            double[] dpos = new double[geom.getDataDimCount()];
            if (dataSpec.isCoordBlank(this.icWeight_)) {
                while (tseq.next()) {
                    int ibin;
                    if (!geom.readDataPos(tseq, this.icPos_, dpos) || (ibin = pixer.getBinIndex(dpos)) < 0) continue;
                    binList.submitToBin(ibin, 1.0);
                }
            } else {
                while (tseq.next()) {
                    double w;
                    int ibin;
                    if (!geom.readDataPos(tseq, this.icPos_, dpos) || (ibin = pixer.getBinIndex(dpos)) < 0 || Double.isNaN(w = WEIGHT_COORD.readDoubleCoord(tseq, this.icWeight_))) continue;
                    binList.submitToBin(ibin, w);
                }
            }
            return binList;
        }

        private GridPlan getGridPlan(Object[] knownPlans, GridPixer pixer) {
            Combiner combiner = this.gstyle_.combiner_;
            DataSpec dataSpec = this.getDataSpec();
            DataGeom geom = this.getDataGeom();
            for (Object plan : knownPlans) {
                GridPlan gplan;
                if (!(plan instanceof GridPlan) || !(gplan = (GridPlan)plan).matches(pixer, combiner, dataSpec, geom)) continue;
                return gplan;
            }
            return null;
        }

        private void extendRange(Range range, PlanarSurface surface, GridPixer pixer, BinList.Result binResult) {
            double[][] dlims = surface.getDataLimits();
            int[] ixRange = pixer.xgrid_.getBinRange(dlims[0]);
            int[] iyRange = pixer.ygrid_.getBinRange(dlims[1]);
            int ixlo = ixRange[0];
            int ixhi = ixRange[1];
            int iylo = iyRange[0];
            int iyhi = iyRange[1];
            for (int iy = iylo; iy <= iyhi; ++iy) {
                for (int ix = ixlo; ix <= ixhi; ++ix) {
                    int ibin = pixer.getBinIndex(ix, iy);
                    assert (ibin >= 0);
                    range.submit(binResult.getBinValue(ibin));
                }
            }
        }

        private class GridDrawing
        implements Drawing {
            private final PlanarSurface surface_;
            private final Range auxRange_;
            private final PaperType ptype_;

            GridDrawing(PlanarSurface surface, Range auxRange, PaperType ptype) {
                this.surface_ = surface;
                this.auxRange_ = auxRange;
                this.ptype_ = ptype;
            }

            @Override
            public GridPlan calculatePlan(Object[] knownPlans, DataStore dataStore) {
                GridPlan knownPlan = GridLayer.this.getGridPlan(knownPlans, GridLayer.this.createGridPixer(this.surface_, 0.0));
                if (knownPlan != null) {
                    return knownPlan;
                }
                DataSpec dataSpec = GridLayer.this.getDataSpec();
                GridPixer pixer1 = GridLayer.this.createGridPixer(this.surface_, 0.8);
                BinList.Result binResult = GridLayer.this.readBins(pixer1, dataSpec, dataStore).getResult();
                return new GridPlan(pixer1, GridLayer.this.gstyle_.combiner_, dataSpec, GridLayer.this.getDataGeom(), binResult);
            }

            @Override
            public void paintData(Object plan, Paper paper, DataStore dataStore) {
                final GridPlan gplan = (GridPlan)plan;
                this.ptype_.placeDecal(paper, new Decal(){

                    @Override
                    public void paintDecal(Graphics g) {
                        Scaler scaler = Scaling.createRangeScaler(GridLayer.this.gstyle_.scaling_, GridDrawing.this.auxRange_);
                        IndexColorModel colorModel = PixelImage.createColorModel(GridLayer.this.gstyle_.shader_, true);
                        GridPlotter.paintBins(g, gplan.pixer_, gplan.result_, scaler, colorModel, GridDrawing.this.surface_);
                    }

                    @Override
                    public boolean isOpaque() {
                        return false;
                    }
                });
            }

            @Override
            public ReportMap getReport(Object plan) {
                ReportMap report = new ReportMap();
                GridPixer pixer = GridLayer.this.createGridPixer(this.surface_, 0.0);
                report.put(XBINWIDTH_KEY, new Double(((GridPixer)pixer).xgrid_.binWidth_));
                report.put(YBINWIDTH_KEY, new Double(((GridPixer)pixer).ygrid_.binWidth_));
                return report;
            }
        }
    }

    public static class GridStyle
    implements Style {
        private final BinSizer xSizer_;
        private final BinSizer ySizer_;
        private final double xPhase_;
        private final double yPhase_;
        private final Scaling scaling_;
        private final Shader shader_;
        private final Combiner combiner_;

        public GridStyle(BinSizer xSizer, BinSizer ySizer, double xPhase, double yPhase, Scaling scaling, Shader shader, Combiner combiner) {
            this.xSizer_ = xSizer;
            this.ySizer_ = ySizer;
            this.xPhase_ = xPhase;
            this.yPhase_ = yPhase;
            this.scaling_ = scaling;
            this.shader_ = shader;
            this.combiner_ = combiner;
        }

        @Override
        public Icon getLegendIcon() {
            return Shaders.createShaderIcon(this.shader_, null, true, 16, 8, 2, 2);
        }

        public int hashCode() {
            int code = 27441;
            code = 23 * code + this.xSizer_.hashCode();
            code = 23 * code + this.ySizer_.hashCode();
            code = 23 * code + Float.floatToIntBits((float)this.xPhase_);
            code = 23 * code + Float.floatToIntBits((float)this.yPhase_);
            code = 23 * code + this.scaling_.hashCode();
            code = 23 * code + this.shader_.hashCode();
            code = 23 * code + this.combiner_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof GridStyle) {
                GridStyle other = (GridStyle)o;
                return this.xSizer_.equals(other.xSizer_) && this.ySizer_.equals(other.ySizer_) && this.xPhase_ == other.xPhase_ && this.yPhase_ == other.yPhase_ && this.scaling_.equals(other.scaling_) && this.shader_.equals(other.shader_) && this.combiner_.equals(other.combiner_);
            }
            return false;
        }
    }
}

