/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import uk.ac.starlink.ttools.plot2.layer.ArrayBinList;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.layer.Combiner;

public class HashBinList
implements BinList {
    private final long size_;
    private final Combiner combiner_;
    private final Map<Long, Combiner.Container> map_;

    public HashBinList(long size, Combiner combiner) {
        this.size_ = size;
        this.combiner_ = combiner;
        this.map_ = new HashMap<Long, Combiner.Container>();
    }

    @Override
    public long getSize() {
        return this.size_;
    }

    @Override
    public Combiner getCombiner() {
        return this.combiner_;
    }

    @Override
    public void submitToBin(long index, double value) {
        Long key = new Long(index);
        Combiner.Container container = this.map_.get(key);
        if (container == null) {
            container = this.getCombiner().createContainer();
            this.map_.put(key, container);
        }
        container.submit(value);
    }

    @Override
    public BinList.Result getResult() {
        return new BinList.Result(){

            @Override
            public double getBinValue(long index) {
                Combiner.Container container = (Combiner.Container)HashBinList.this.map_.get(new Long(index));
                return container == null ? Double.NaN : container.getResult();
            }

            @Override
            public long getBinCount() {
                return HashBinList.this.map_.size();
            }

            @Override
            public Iterator<Long> indexIterator() {
                return HashBinList.this.map_.keySet().iterator();
            }

            @Override
            public BinList.Result compact() {
                double frac = (double)HashBinList.this.map_.size() * 1.0 / (double)HashBinList.this.size_;
                if (frac > 0.25 && HashBinList.this.size_ < Integer.MAX_VALUE) {
                    int isize = (int)HashBinList.this.size_;
                    double[] values = new double[isize];
                    BitSet mask = new BitSet(isize);
                    Iterator<Long> it = this.indexIterator();
                    while (it.hasNext()) {
                        int index = it.next().intValue();
                        mask.set(index);
                        values[index] = this.getBinValue(index);
                    }
                    return ArrayBinList.createDoubleMaskResult(mask, values);
                }
                if (HashBinList.this.combiner_.hasBigBin()) {
                    HashMap<Long, Double> cmap = new HashMap<Long, Double>();
                    Iterator<Long> it = this.indexIterator();
                    while (it.hasNext()) {
                        Long key = it.next();
                        Combiner.Container container = (Combiner.Container)HashBinList.this.map_.get(key);
                        double val = container == null ? Double.NaN : container.getResult();
                        cmap.put(key, new Double(val));
                    }
                    return HashBinList.createHashResult(cmap);
                }
                return this;
            }
        };
    }

    public static BinList.Result createHashResult(final Map<Long, Double> map) {
        return new BinList.Result(){

            @Override
            public double getBinValue(long index) {
                Double value = (Double)map.get(new Long(index));
                return value == null ? Double.NaN : value;
            }

            @Override
            public long getBinCount() {
                return map.size();
            }

            @Override
            public Iterator<Long> indexIterator() {
                return map.keySet().iterator();
            }

            @Override
            public BinList.Result compact() {
                return this;
            }
        };
    }
}

