/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.BarStyle;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.DoubleConfigKey;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.geom.SliceDataGeom;
import uk.ac.starlink.ttools.plot2.geom.TimeDataGeom;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.BinBag;
import uk.ac.starlink.ttools.plot2.layer.BinSizer;
import uk.ac.starlink.ttools.plot2.layer.Normalisation;
import uk.ac.starlink.ttools.plot2.layer.Rounding;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;

public class HistogramPlotter
implements Plotter<HistoStyle> {
    private final FloatingCoord xCoord_;
    private final FloatingCoord weightCoord_;
    private final ConfigKey<Normalisation> normKey_;
    private final SliceDataGeom histoDataGeom_;
    private final CoordGroup histoCoordGrp_;
    private final int icX_;
    private final int icWeight_;
    private final boolean isTimeX_;
    public static final ReportKey<BinBag> BINS_KEY = ReportKey.createUnprintableKey(new ReportMeta("bins", "Bins"), BinBag.class);
    public static final ReportKey<Double> BINWIDTH_KEY = ReportKey.createDoubleKey(new ReportMeta("binwidth", "Bin Width"), false);
    public static final ConfigKey<BinSizer> BINSIZER_KEY = BinSizer.createSizerConfigKey(new ConfigMeta("binsize", "Bin Size").setStringUsage("+<width>|-<count>").setShortDescription("Bin size specification").setXmlDescription(new String[]{"<p>Configures the width of histogram bins.", "If the supplied string is a positive number,", "it is interpreted as a fixed width in the data coordinates", "of the X axis", "(if the X axis is logarithmic, the value is a fixed factor).", "If it is a negative number, then it will be interpreted", "as the approximate number of bins to display across", "the width of the plot", "(though an attempt is made to use only round numbers", "for bin widths).", "</p>", "<p>When setting this value graphically,", "you can use either the slider to adjust the bin count", "or the numeric entry field to fix the bin width.", "</p>"}), BINWIDTH_KEY, 30, false);
    public static final ConfigKey<Integer> THICK_KEY = StyleKeys.createThicknessKey(2);
    public static final ConfigKey<Double> PHASE_KEY = DoubleConfigKey.createSliderKey(new ConfigMeta("phase", "Bin Phase").setShortDescription("Horizontal zero point").setXmlDescription(new String[]{"<p>Controls where the horizontal zero point for binning", "is set.", "For instance if your bin size is 1,", "this value controls whether bin boundaries are at", "0, 1, 2, .. or 0.5, 1.5, 2.5, ... etc.", "</p>", "<p>A value of 0 (or any integer) will result in", "a bin boundary at X=0 (linear X axis)", "or X=1 (logarithmic X axis).", "A fractional value will give a bin boundary at", "that value multiplied by the bin width.", "</p>"}), 0.0, 0.0, 1.0, false);

    public HistogramPlotter(FloatingCoord xCoord, boolean hasWeight, ConfigKey<Normalisation> normKey) {
        this.xCoord_ = xCoord;
        this.normKey_ = normKey;
        if (hasWeight) {
            this.weightCoord_ = FloatingCoord.WEIGHT_COORD;
            this.histoCoordGrp_ = CoordGroup.createPartialCoordGroup(new Coord[]{xCoord, this.weightCoord_}, new boolean[]{true, true});
        } else {
            this.weightCoord_ = null;
            this.histoCoordGrp_ = CoordGroup.createPartialCoordGroup(new Coord[]{xCoord}, new boolean[]{true});
        }
        this.histoDataGeom_ = new SliceDataGeom(new FloatingCoord[]{this.xCoord_, null}, "X");
        this.icX_ = this.histoCoordGrp_.getExtraCoordIndex(0, null);
        this.icWeight_ = hasWeight ? this.histoCoordGrp_.getExtraCoordIndex(1, null) : -1;
        this.isTimeX_ = xCoord == TimeDataGeom.T_COORD;
    }

    @Override
    public String getPlotterName() {
        return "Histogram";
    }

    @Override
    public Icon getPlotterIcon() {
        return ResourceIcon.FORM_HISTOGRAM;
    }

    @Override
    public String getPlotterDescription() {
        return "<p>Plots a histogram.</p>";
    }

    @Override
    public CoordGroup getCoordGroup() {
        return this.histoCoordGrp_;
    }

    @Override
    public ConfigKey[] getStyleKeys() {
        return new ConfigKey[]{StyleKeys.COLOR, StyleKeys.TRANSPARENCY, BINSIZER_KEY, PHASE_KEY, StyleKeys.CUMULATIVE, this.normKey_, StyleKeys.BAR_FORM, THICK_KEY, StyleKeys.DASH};
    }

    @Override
    public HistoStyle createStyle(ConfigMap config) {
        Color color = StyleKeys.getAlphaColor(config, StyleKeys.COLOR, StyleKeys.TRANSPARENCY);
        BarStyle.Form barForm = config.get(StyleKeys.BAR_FORM);
        BarStyle.Placement placement = BarStyle.PLACE_OVER;
        boolean cumulative = config.get(StyleKeys.CUMULATIVE);
        Normalisation norm = config.get(this.normKey_);
        int thick = config.get(THICK_KEY);
        float[] dash = config.get(StyleKeys.DASH);
        BinSizer sizer = config.get(BINSIZER_KEY);
        double binPhase = config.get(PHASE_KEY);
        return new HistoStyle(color, barForm, placement, cumulative, norm, thick, dash, sizer, binPhase);
    }

    @Override
    public boolean hasReports() {
        return false;
    }

    @Override
    public PlotLayer createLayer(DataGeom geom, final DataSpec dataSpec, final HistoStyle style) {
        if (dataSpec == null || style == null) {
            return null;
        }
        final double binPhase = style.phase_;
        final BinSizer sizer = style.sizer_;
        final boolean cumul = style.cumulative_;
        final Normalisation norm = style.norm_;
        Color color = style.color_;
        final boolean isOpaque = color.getAlpha() == 255 && style.barForm_.isOpaque();
        final Rounding xround = Rounding.getRounding(this.isTimeX_);
        LayerOpt layerOpt = new LayerOpt(color, isOpaque);
        return new AbstractPlotLayer(this, this.histoDataGeom_, dataSpec, style, layerOpt){

            @Override
            public Drawing createDrawing(Surface surface, Map<AuxScale, Range> auxRanges, final PaperType paperType) {
                if (!(surface instanceof PlanarSurface)) {
                    throw new IllegalArgumentException("Not planar surface " + surface);
                }
                final PlanarSurface pSurf = (PlanarSurface)surface;
                final boolean xlog = pSurf.getLogFlags()[0];
                double[] xlimits = pSurf.getDataLimits()[0];
                final double xlo = xlimits[0];
                double xhi = xlimits[1];
                final double binWidth = sizer.getWidth(xlog, xlo, xhi, xround);
                boolean iseq = false;
                boolean nseq = true;
                return new Drawing(){

                    @Override
                    public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
                        for (int ip = 0; ip < knownPlans.length; ++ip) {
                            HistoPlan plan;
                            if (!(knownPlans[ip] instanceof HistoPlan) || !(plan = (HistoPlan)knownPlans[ip]).matches(xlog, binWidth, binPhase, dataSpec)) continue;
                            return plan;
                        }
                        BinBag binBag = HistogramPlotter.this.readBins(xlog, binWidth, binPhase, xlo, dataSpec, dataStore);
                        return new HistoPlan(binBag, dataSpec);
                    }

                    @Override
                    public void paintData(Object plan, Paper paper, DataStore dataStore) {
                        HistoPlan hPlan = (HistoPlan)plan;
                        final BinBag binBag = hPlan.binBag_;
                        paperType.placeDecal(paper, new Decal(){

                            @Override
                            public void paintDecal(Graphics g) {
                                HistogramPlotter.this.paintBins(pSurf, binBag, style, 0, 1, g);
                            }

                            @Override
                            public boolean isOpaque() {
                                return isOpaque;
                            }
                        });
                    }

                    @Override
                    public ReportMap getReport(Object plan) {
                        ReportMap report = new ReportMap();
                        if (plan instanceof HistoPlan) {
                            BinBag bbag = ((HistoPlan)plan).binBag_;
                            report.put(BINS_KEY, bbag);
                            report.put(BINWIDTH_KEY, bbag.getBinWidth());
                        }
                        return report;
                    }
                };
            }

            @Override
            public void extendCoordinateRanges(Range[] ranges, boolean[] logFlags, DataStore dataStore) {
                Range xRange = ranges[0];
                Range yRange = ranges[1];
                boolean xlog = logFlags[0];
                double[] xlimits = xRange.getFiniteBounds(xlog);
                double xlo = xlimits[0];
                double xhi = xlimits[1];
                double binWidth = sizer.getWidth(xlog, xlo, xhi, xround);
                BinBag binBag = HistogramPlotter.this.readBins(xlog, binWidth, binPhase, xlo, dataSpec, dataStore);
                yRange.submit(0.0);
                Iterator<BinBag.Bin> it = binBag.binIterator(cumul, norm);
                while (it.hasNext()) {
                    BinBag.Bin bin = it.next();
                    double y = bin.getY();
                    if (y == 0.0) continue;
                    yRange.submit(y);
                    xRange.submit(bin.getXMin());
                    xRange.submit(bin.getXMax());
                }
            }
        };
    }

    public int getWeightCoordIndex() {
        return this.icWeight_;
    }

    private BinBag readBins(boolean xlog, double binWidth, double binPhase, double point, DataSpec dataSpec, DataStore dataStore) {
        BinBag binBag = new BinBag(xlog, binWidth, binPhase, point);
        TupleSequence tseq = dataStore.getTupleSequence(dataSpec);
        if (this.weightCoord_ == null || dataSpec.isCoordBlank(this.icWeight_)) {
            while (tseq.next()) {
                double x = this.xCoord_.readDoubleCoord(tseq, this.icX_);
                binBag.addToBin(x, 1.0);
            }
        } else {
            while (tseq.next()) {
                double x = this.xCoord_.readDoubleCoord(tseq, this.icX_);
                double w = this.weightCoord_.readDoubleCoord(tseq, this.icWeight_);
                double weight = Double.isNaN(w) ? 0.0 : w;
                binBag.addToBin(x, weight);
            }
        }
        return binBag;
    }

    private void paintBins(PlanarSurface surface, BinBag binBag, HistoStyle style, int iseq, int nseq, Graphics g) {
        Color color0 = g.getColor();
        g.setColor(style.color_);
        BarStyle barStyle = style.barStyle_;
        boolean cumul = style.cumulative_;
        Normalisation norm = style.norm_;
        Rectangle clip = surface.getPlotBounds();
        int xClipMin = clip.x - 64;
        int xClipMax = clip.x + clip.width + 64;
        int yClipMin = clip.y - 64;
        int yClipMax = clip.y + clip.height + 64;
        double[][] dataLimits = surface.getDataLimits();
        double dxMin = dataLimits[0][0];
        double dxMax = dataLimits[0][1];
        boolean[] flipFlags = surface.getFlipFlags();
        boolean xflip = flipFlags[0];
        boolean yflip = flipFlags[1];
        boolean ylog = surface.getLogFlags()[1];
        Point2D.Double p0 = new Point2D.Double();
        Point2D.Double p1 = new Point2D.Double();
        double[] dpos0 = new double[2];
        double[] dpos1 = new double[2];
        int lastGx1 = xflip ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int lastGy1 = 0;
        int commonGy0 = 0;
        Iterator<BinBag.Bin> binIt = binBag.binIterator(cumul, norm);
        while (binIt.hasNext()) {
            BinBag.Bin bin = binIt.next();
            double dxlo = bin.getXMin();
            double dxhi = bin.getXMax();
            double dy = bin.getY();
            if (!(dxlo <= dxMax) || !(dxhi >= dxMin) || dy == 0.0) continue;
            dpos0[0] = dxlo;
            dpos0[1] = ylog ? Double.MIN_VALUE : 0.0;
            dpos1[0] = dxhi;
            dpos1[1] = dy;
            if (!surface.dataToGraphics(dpos0, false, p0) || Double.isNaN(p0.x) || !surface.dataToGraphics(dpos1, false, p1) || Double.isNaN(p1.x)) continue;
            int gx0 = HistogramPlotter.clip((int)p0.x, xClipMin, xClipMax);
            int gx1 = HistogramPlotter.clip((int)p1.x, xClipMin, xClipMax);
            int gy0 = HistogramPlotter.clip((int)p0.y, yClipMin, yClipMax);
            int gy1 = HistogramPlotter.clip((int)p1.y, yClipMin, yClipMax);
            if (lastGx1 != gx0) {
                barStyle.drawEdge(g, lastGx1, lastGy1, gy0, iseq, nseq);
                lastGy1 = gy0;
            }
            barStyle.drawEdge(g, gx0, lastGy1, gy1, iseq, nseq);
            lastGx1 = gx1;
            lastGy1 = gy1;
            commonGy0 = gy0;
            int gxlo = xflip ? gx1 : gx0;
            int gxhi = xflip ? gx0 : gx1;
            this.drawGeneralBar(barStyle, g, gxlo, gxhi, gy0, gy1, iseq, nseq);
        }
        barStyle.drawEdge(g, lastGx1, lastGy1, commonGy0, iseq, nseq);
        g.setColor(color0);
    }

    private static int clip(int p, int lo, int hi) {
        return Math.max(Math.min(p, hi), lo);
    }

    private void drawGeneralBar(BarStyle barStyle, Graphics g, int xlo, int xhi, int y0, int y1, int iseq, int nseq) {
        if (y0 >= y1) {
            barStyle.drawBar(g, xlo, xhi, y1, y0, iseq, nseq);
        } else {
            Graphics2D g2 = (Graphics2D)g;
            AffineTransform trans0 = g2.getTransform();
            g2.translate(0, y0 + y1);
            g2.scale(1.0, -1.0);
            barStyle.drawBar(g, xlo, xhi, y0, y1, iseq, nseq);
            g2.setTransform(trans0);
        }
    }

    private static class HistoPlan {
        final BinBag binBag_;
        final DataSpec dataSpec_;

        HistoPlan(BinBag binBag, DataSpec dataSpec) {
            this.binBag_ = binBag;
            this.dataSpec_ = dataSpec;
        }

        boolean matches(boolean xlog, double binWidth, double binPhase, DataSpec dataSpec) {
            return this.binBag_.matches(xlog, binWidth, binPhase) && this.dataSpec_.equals(dataSpec);
        }
    }

    public static class HistoStyle
    implements Style {
        private final Color color_;
        private final BarStyle.Form barForm_;
        private final BarStyle.Placement placement_;
        private final boolean cumulative_;
        private final Normalisation norm_;
        private final int thick_;
        private final float[] dash_;
        private final BinSizer sizer_;
        private final double phase_;
        private final BarStyle barStyle_;

        public HistoStyle(Color color, BarStyle.Form barForm, BarStyle.Placement placement, boolean cumulative, Normalisation norm, int thick, float[] dash, BinSizer sizer, double phase) {
            this.color_ = color;
            this.barForm_ = barForm;
            this.placement_ = placement;
            this.cumulative_ = cumulative;
            this.norm_ = norm;
            this.thick_ = thick;
            this.dash_ = dash;
            this.sizer_ = sizer;
            this.phase_ = phase;
            this.barStyle_ = new BarStyle(color, barForm, placement);
            this.barStyle_.setLineWidth(thick);
            this.barStyle_.setDash(dash);
        }

        public BinSizer getBinSizer() {
            return this.sizer_;
        }

        public boolean isCumulative() {
            return this.cumulative_;
        }

        public Normalisation getNormalisation() {
            return this.norm_;
        }

        @Override
        public Icon getLegendIcon() {
            return this.barStyle_;
        }

        public int hashCode() {
            int code = 55012;
            code = 23 * code + this.color_.hashCode();
            code = 23 * code + this.barForm_.hashCode();
            code = 23 * code + this.placement_.hashCode();
            code = 23 * code + (this.cumulative_ ? 11 : 13);
            code = 23 * code + PlotUtil.hashCode(this.norm_);
            code = 23 * code + this.thick_;
            code = 23 * code + Arrays.hashCode(this.dash_);
            code = 23 * code + this.sizer_.hashCode();
            code = 23 * code + Float.floatToIntBits((float)this.phase_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof HistoStyle) {
                HistoStyle other = (HistoStyle)o;
                return this.color_.equals(other.color_) && this.barForm_.equals(other.barForm_) && this.placement_.equals(other.placement_) && this.cumulative_ == other.cumulative_ && PlotUtil.equals(this.norm_, other.norm_) && this.thick_ == other.thick_ && Arrays.equals(this.dash_, other.dash_) && this.sizer_.equals(other.sizer_) && this.phase_ == other.phase_;
            }
            return false;
        }
    }
}

