/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.Anchor;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.PointCloud;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.SubCloud;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.CaptionerKeySet;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.IntegerConfigKey;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.StringCoord;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotter;
import uk.ac.starlink.ttools.plot2.layer.BinPlan;
import uk.ac.starlink.ttools.plot2.layer.Binner;
import uk.ac.starlink.ttools.plot2.layer.GreyImage;
import uk.ac.starlink.ttools.plot2.layer.Gridder;
import uk.ac.starlink.ttools.plot2.layer.LabelStyle;
import uk.ac.starlink.ttools.plot2.layer.Pixers;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.ttools.plot2.paper.PaperType2D;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;

public class LabelPlotter
extends AbstractPlotter<LabelStyle> {
    private static final StringCoord LABEL_COORD = new StringCoord(new InputMeta("label", "Label").setShortDescription("Content of label").setXmlDescription(new String[]{"<p>Column or expression giving the text of the label", "to be written near the position being labelled.", "Label values may be of any type (string or numeric)", "</p>"}), true);
    private static final CoordGroup LABEL_CGRP = CoordGroup.createCoordGroup(1, new Coord[]{LABEL_COORD});
    private static final int MAX_CROWDLIMIT = 62;
    public static final ConfigKey<Integer> SPACING_KEY = IntegerConfigKey.createSliderKey(new ConfigMeta("spacing", "Spacing Threshold").setStringUsage("<pixels>").setShortDescription("Minimum size in pixels for label group").setXmlDescription(new String[]{"<p>Determines the closest that labels can be spaced.", "If a group of labels is closer to another group", "than the value of this parameter,", "they will not be drawn, to avoid the display becoming", "too cluttered.", "The effect is that you can see individual labels", "when you zoom in, but not when there are many labelled points", "plotted close together on the screen.", "Set the value higher for less cluttered labelling.", "</p>"}), 12, 0.5, 200.0, true);
    public static final ConfigKey<Integer> CROWDLIMIT_KEY = IntegerConfigKey.createSpinnerKey(new ConfigMeta("crowdlimit", "Crowding Limit").setStringUsage("<n>").setShortDescription("Maximum labels per group").setXmlDescription(new String[]{"<p>Sets the maximum number of labels in a label group.", "This many labels can appear closely spaced without being", "affected by the label spacing parameter.", "</p>", "<p>It is useful for instance if you are looking at", "pairs of points, which will always be close together;", "if you set this value to 2, an isolated pair of labels", "can be seen, but if it's 1 then they will only be plotted", "when they are distant from each other,", "which may only happen at very high magnifications.", "</p>"}), 2, 1, 62);
    public static final CaptionerKeySet CAPTIONER_KEYSET = new CaptionerKeySet();

    public LabelPlotter() {
        super("Label", ResourceIcon.PLOT_LABEL, LABEL_CGRP, false);
    }

    @Override
    public String getPlotterDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Draws a text label at each position.", "You can select the font,", "where the labels appear in relation to the point positions, and", "how crowded the points have to get before they are suppressed.", "</p>"});
    }

    @Override
    public ConfigKey[] getStyleKeys() {
        ArrayList<ConfigKey> list = new ArrayList<ConfigKey>();
        list.addAll(Arrays.asList(CAPTIONER_KEYSET.getKeys()));
        list.addAll(Arrays.asList(StyleKeys.ANCHOR, StyleKeys.COLOR, SPACING_KEY, CROWDLIMIT_KEY));
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public LabelStyle createStyle(ConfigMap config) throws ConfigException {
        int iclimit = config.get(CROWDLIMIT_KEY);
        if (iclimit < 1 || iclimit > 62) {
            throw new ConfigException(CROWDLIMIT_KEY, iclimit + " out of range " + 1 + ".." + 62);
        }
        byte crowdLimit = (byte)iclimit;
        assert (crowdLimit == iclimit);
        return new LabelStyle(CAPTIONER_KEYSET.createValue(config), config.get(StyleKeys.ANCHOR), config.get(StyleKeys.COLOR), config.get(SPACING_KEY), crowdLimit);
    }

    @Override
    public PlotLayer createLayer(final DataGeom geom, final DataSpec dataSpec, final LabelStyle style) {
        LayerOpt opt = new LayerOpt(style.getColor(), true);
        return new AbstractPlotLayer(this, geom, dataSpec, style, opt){

            @Override
            public Drawing createDrawing(Surface surface, Map<AuxScale, Range> auxRanges, PaperType paperType) {
                if (paperType instanceof PaperType2D) {
                    return new LabelDrawing2D(geom, dataSpec, style, surface, (PaperType2D)paperType);
                }
                if (paperType instanceof PaperType3D) {
                    return new LabelDrawing3D(geom, dataSpec, style, surface, (PaperType3D)paperType);
                }
                throw new IllegalArgumentException("paper type");
            }
        };
    }

    private static GridMask calculateGridMask(BinPlan binPlan, int spacing, byte crowdLimit, Surface surface) {
        if (spacing == 0) {
            return new GridMask(){

                @Override
                public boolean isFree(Point gp) {
                    return true;
                }
            };
        }
        final byte crowdLimit1 = (byte)(crowdLimit + 1);
        assert (crowdLimit1 < 63);
        final Gridder gridder = binPlan.getGridder();
        Binner binner = binPlan.getBinner();
        Rectangle plotBounds = surface.getPlotBounds();
        int count = gridder.getLength();
        int nx = gridder.getWidth();
        int ny = gridder.getHeight();
        byte[] mask0 = new byte[count];
        for (int i = 0; i < count; ++i) {
            mask0[i] = (byte)Math.min(binner.getCount(i), crowdLimit1);
        }
        byte[] mask1 = new byte[count];
        for (int ix = 0; ix < nx; ++ix) {
            int x1 = Math.max(0, ix - spacing);
            int x2 = Math.min(nx, ix + spacing);
            for (int iy = 0; iy < ny; ++iy) {
                int itarget = gridder.getIndex(ix, iy);
                for (int jx = x1; jx < x2 && mask1[itarget] < crowdLimit1; ++jx) {
                    int n = itarget;
                    mask1[n] = (byte)(mask1[n] + mask0[gridder.getIndex(jx, iy)]);
                }
            }
        }
        Arrays.fill(mask0, (byte)0);
        final byte[] mask2 = mask0;
        for (int iy = 0; iy < ny; ++iy) {
            int y1 = Math.max(0, iy - spacing);
            int y2 = Math.min(ny, iy + spacing);
            for (int ix = 0; ix < nx; ++ix) {
                int itarget = gridder.getIndex(ix, iy);
                for (int jy = y1; jy < y2 && mask2[itarget] < crowdLimit1; ++jy) {
                    int n = itarget;
                    mask2[n] = (byte)(mask2[n] + mask1[gridder.getIndex(ix, jy)]);
                }
            }
        }
        final int gx0 = plotBounds.x;
        final int gy0 = plotBounds.y;
        return new GridMask(){

            @Override
            public boolean isFree(Point gp) {
                return mask2[gridder.getIndex(gp.x - gx0, gp.y - gy0)] < crowdLimit1;
            }
        };
    }

    private static class LabelGlyph
    implements Glyph {
        private final String label_;
        private final LabelStyle style_;

        LabelGlyph(String label, LabelStyle style) {
            this.label_ = label;
            this.style_ = style;
        }

        @Override
        public void paintGlyph(Graphics g) {
            this.style_.drawLabel(g, this.label_);
        }

        @Override
        public Pixer createPixer(Rectangle clip) {
            Captioner captioner;
            Anchor anchor = this.style_.getAnchor();
            Rectangle labelBox = anchor.getCaptionBounds(this.label_, 0, 0, captioner = this.style_.getCaptioner());
            Rectangle drawBox = labelBox.intersection(clip);
            if (drawBox.isEmpty()) {
                return null;
            }
            GreyImage bitmap = GreyImage.createGreyImage(drawBox.width, drawBox.height);
            Graphics2D g = bitmap.getImage().createGraphics();
            anchor.drawCaption(this.label_, -labelBox.x, -labelBox.y, captioner, g);
            return Pixers.translate(bitmap.createPixer(), drawBox.x, drawBox.y);
        }
    }

    private static interface GridMask {
        public boolean isFree(Point var1);
    }

    private static class LabelPlan<T> {
        final DataGeom geom_;
        final DataSpec dataSpec_;
        final Surface surface_;
        final int spacing_;
        final byte crowdLimit_;
        final Map<Point, T> map_;
        final Class<T> clazz_;

        LabelPlan(DataGeom geom, DataSpec dataSpec, Surface surface, int spacing, byte crowdLimit, Map<Point, T> map, Class<T> clazz) {
            this.geom_ = geom;
            this.dataSpec_ = dataSpec;
            this.surface_ = surface;
            this.spacing_ = spacing;
            this.crowdLimit_ = crowdLimit;
            this.map_ = map;
            this.clazz_ = clazz;
        }

        boolean matches(DataGeom geom, DataSpec dataSpec, Surface surface, int spacing, byte crowdLimit, Class clazz) {
            return geom.equals(this.geom_) && dataSpec.equals(this.dataSpec_) && surface.equals(this.surface_) && spacing == this.spacing_ && crowdLimit == this.crowdLimit_ && clazz.equals(this.clazz_);
        }
    }

    private static class DepthString {
        final String label_;
        final float depth_;

        DepthString(String label, double depth) {
            this.label_ = label;
            this.depth_ = (float)depth;
        }
    }

    private static class LabelDrawing3D
    extends LabelDrawing<DepthString> {
        final PaperType3D paperType_;

        LabelDrawing3D(DataGeom geom, DataSpec dataSpec, LabelStyle style, Surface surface, PaperType3D paperType) {
            super(geom, dataSpec, style, surface, DepthString.class);
            this.paperType_ = paperType;
        }

        @Override
        Map<Point, DepthString> createMap(DataStore dataStore, GridMask gridMask) {
            LinkedHashMap<Point, DepthString> map = new LinkedHashMap<Point, DepthString>();
            double[] dpos = new double[this.surface_.getDataDimCount()];
            Point2D.Double gp = new Point2D.Double();
            Point gpi = new Point();
            double[] depthArr = new double[1];
            CubeSurface surf = (CubeSurface)this.surface_;
            TupleSequence tseq = dataStore.getTupleSequence(this.dataSpec_);
            while (tseq.next()) {
                String label;
                if (!this.geom_.readDataPos(tseq, this.icPos_, dpos) || !surf.dataToGraphicZ(dpos, true, gp, depthArr)) continue;
                PlotUtil.quantisePoint(gp, gpi);
                if (!gridMask.isFree(gpi) || (label = LABEL_COORD.readStringCoord(tseq, this.icLabel_)) == null || label.trim().length() <= 0) continue;
                double depth = depthArr[0];
                if (map.containsKey(gp) && !(depth < (double)((DepthString)map.get((Object)gpi)).depth_)) continue;
                map.put(new Point(gpi), new DepthString(label, depth));
            }
            return map;
        }

        @Override
        void paintMap(Map<Point, DepthString> map, Paper paper) {
            for (Map.Entry<Point, DepthString> entry : map.entrySet()) {
                Point gp = entry.getKey();
                DepthString value = entry.getValue();
                String label = value.label_;
                LabelGlyph glyph = new LabelGlyph(label, this.style_);
                double depth = value.depth_;
                this.paperType_.placeGlyph(paper, gp.x, gp.y, depth, glyph, this.style_.getColor());
            }
        }
    }

    private static class LabelDrawing2D
    extends LabelDrawing<String> {
        final PaperType2D paperType_;

        LabelDrawing2D(DataGeom geom, DataSpec dataSpec, LabelStyle style, Surface surface, PaperType2D paperType) {
            super(geom, dataSpec, style, surface, String.class);
            this.paperType_ = paperType;
        }

        @Override
        Map<Point, String> createMap(DataStore dataStore, GridMask gridMask) {
            LinkedHashMap<Point, String> map = new LinkedHashMap<Point, String>();
            double[] dpos = new double[this.surface_.getDataDimCount()];
            Point2D.Double gp = new Point2D.Double();
            Point gpi = new Point();
            TupleSequence tseq = dataStore.getTupleSequence(this.dataSpec_);
            while (tseq.next()) {
                String label;
                if (!this.geom_.readDataPos(tseq, this.icPos_, dpos) || !this.surface_.dataToGraphics(dpos, true, gp)) continue;
                PlotUtil.quantisePoint(gp, gpi);
                if (!gridMask.isFree(gpi) || (label = LABEL_COORD.readStringCoord(tseq, this.icLabel_)) == null || label.trim().length() <= 0) continue;
                map.put(new Point(gpi), label);
            }
            return map;
        }

        @Override
        void paintMap(Map<Point, String> map, Paper paper) {
            for (Map.Entry<Point, String> entry : map.entrySet()) {
                Point gp = entry.getKey();
                String label = entry.getValue();
                LabelGlyph glyph = new LabelGlyph(label, this.style_);
                this.paperType_.placeGlyph(paper, gp.x, gp.y, glyph, this.style_.getColor());
            }
        }
    }

    private static abstract class LabelDrawing<T>
    implements Drawing {
        final DataSpec dataSpec_;
        final LabelStyle style_;
        final Surface surface_;
        final Class<T> clazz_;
        final DataGeom geom_;
        final int icPos_;
        final int icLabel_;

        LabelDrawing(DataGeom geom, DataSpec dataSpec, LabelStyle style, Surface surface, Class<T> clazz) {
            this.geom_ = geom;
            this.dataSpec_ = dataSpec;
            this.style_ = style;
            this.surface_ = surface;
            this.clazz_ = clazz;
            this.icPos_ = LABEL_CGRP.getPosCoordIndex(0, geom);
            this.icLabel_ = LABEL_CGRP.getExtraCoordIndex(0, geom);
        }

        abstract Map<Point, T> createMap(DataStore var1, GridMask var2);

        abstract void paintMap(Map<Point, T> var1, Paper var2);

        @Override
        public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
            int spacing = this.style_.getSpacing();
            byte crowdLimit = this.style_.getCrowdLimit();
            for (int i = 0; i < knownPlans.length; ++i) {
                Object plan = knownPlans[i];
                if (!(plan instanceof LabelPlan) || !((LabelPlan)plan).matches(this.geom_, this.dataSpec_, this.surface_, spacing, crowdLimit, this.clazz_)) continue;
                return plan;
            }
            PointCloud cloud = new PointCloud(new SubCloud(this.geom_, this.dataSpec_, this.icPos_));
            BinPlan binPlan = BinPlan.calculatePointCloudPlan(cloud, this.surface_, dataStore, knownPlans);
            GridMask gridMask = LabelPlotter.calculateGridMask(binPlan, spacing, crowdLimit, this.surface_);
            Map<Point, T> map = this.createMap(dataStore, gridMask);
            return new LabelPlan<T>(this.geom_, this.dataSpec_, this.surface_, spacing, crowdLimit, map, this.clazz_);
        }

        @Override
        public void paintData(Object plan, Paper paper, DataStore dataStore) {
            LabelPlan labelPlan = (LabelPlan)plan;
            this.paintMap(labelPlan.map_, paper);
        }

        @Override
        public ReportMap getReport(Object plan) {
            return null;
        }
    }
}

