/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.Anchor;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Equality;

@Equality
public class LabelStyle
implements Style {
    private final Captioner captioner_;
    private final Anchor anchor_;
    private final Color color_;
    private final int spacing_;
    private final byte crowdLimit_;

    public LabelStyle(Captioner captioner, Anchor anchor, Color color, int spacing, byte crowdLimit) {
        this.captioner_ = captioner;
        this.anchor_ = anchor;
        this.color_ = color;
        this.spacing_ = spacing;
        this.crowdLimit_ = crowdLimit;
    }

    @Override
    public Icon getLegendIcon() {
        return new LabelStyleIcon();
    }

    public Captioner getCaptioner() {
        return this.captioner_;
    }

    public Anchor getAnchor() {
        return this.anchor_;
    }

    public Color getColor() {
        return this.color_;
    }

    public int getSpacing() {
        return this.spacing_;
    }

    public byte getCrowdLimit() {
        return this.crowdLimit_;
    }

    public void drawLabel(Graphics g, String label) {
        this.anchor_.drawCaption(label, 0, 0, this.captioner_, g);
    }

    public boolean equals(Object o) {
        if (o instanceof LabelStyle) {
            LabelStyle other = (LabelStyle)o;
            return this.captioner_.equals(other.captioner_) && this.anchor_.equals(other.anchor_) && this.color_.equals(other.color_) && this.spacing_ == other.spacing_ && this.crowdLimit_ == other.crowdLimit_;
        }
        return false;
    }

    public int hashCode() {
        int code = 773;
        code = 23 * code + this.captioner_.hashCode();
        code = 23 * code + this.anchor_.hashCode();
        code = 23 * code + this.color_.hashCode();
        code = 23 * code + this.spacing_;
        code = 23 * code + this.crowdLimit_;
        return code;
    }

    private class LabelStyleIcon
    implements Icon {
        private final int width_;
        private final int height_;
        private final int xoff_;
        private final int yoff_;
        private final String text_;

        LabelStyleIcon() {
            this.text_ = "a";
            Rectangle box0 = LabelStyle.this.anchor_.getCaptionBounds(this.text_, 0, 0, LabelStyle.this.captioner_);
            int w = Math.max(-box0.x, box0.x + box0.width);
            int h = Math.max(-box0.y, box0.y + box0.height);
            int size = Math.max(w, h);
            assert (size > 0);
            this.xoff_ = size / 2;
            this.yoff_ = size / 2;
            this.width_ = size;
            this.height_ = size;
        }

        @Override
        public int getIconWidth() {
            return this.width_;
        }

        @Override
        public int getIconHeight() {
            return this.height_;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color color0 = g.getColor();
            g.setColor(LabelStyle.this.color_);
            int gx = x + this.xoff_;
            int gy = y + this.yoff_;
            g.translate(x, y);
            LabelStyle.this.drawLabel(g, this.text_);
            g.translate(-x, -y);
            g.setColor(color0);
        }
    }
}

