/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.layer.LineStyle;
import uk.ac.starlink.ttools.plot2.layer.LineTracer;
import uk.ac.starlink.ttools.plot2.layer.SimpleDecalPlotter;
import uk.ac.starlink.ttools.plot2.paper.PaperType;

public class LinePlotter
extends SimpleDecalPlotter<LineStyle> {
    public LinePlotter() {
        super("Line", ResourceIcon.PLOT_LINE, CoordGroup.createSinglePositionCoordGroup(), false);
    }

    @Override
    public String getPlotterDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Plots a point-to-point line joining", "up the positions of data points.", "Note that for a large and unordered data set", "this can lead to a big scribble on the screen.", "</p>"});
    }

    @Override
    public ConfigKey[] getStyleKeys() {
        ArrayList<ConfigKey<Boolean>> list = new ArrayList<ConfigKey<Boolean>>();
        list.add(StyleKeys.COLOR);
        list.addAll(Arrays.asList(StyleKeys.getStrokeKeys()));
        list.add(StyleKeys.ANTIALIAS);
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public LineStyle createStyle(ConfigMap config) {
        Color color = config.get(StyleKeys.COLOR);
        Stroke stroke = StyleKeys.createStroke(config, 1, 1);
        boolean antialias = config.get(StyleKeys.ANTIALIAS);
        return new LineStyle(color, stroke, antialias);
    }

    @Override
    protected LayerOpt getLayerOpt(LineStyle style) {
        return new LayerOpt(style.getColor(), true);
    }

    @Override
    protected void paintData2D(Surface surface, DataStore dataStore, DataGeom geom, DataSpec dataSpec, LineStyle style, Graphics g, PaperType paperType) {
        LineTracer tracer = style.createLineTracer(g, surface.getPlotBounds(), 10240, paperType.isBitmap());
        int icPos = this.getCoordGroup().getPosCoordIndex(0, geom);
        double[] dpos = new double[surface.getDataDimCount()];
        Point2D.Double gp = new Point2D.Double();
        TupleSequence tseq = dataStore.getTupleSequence(dataSpec);
        while (tseq.next()) {
            if (!geom.readDataPos(tseq, icPos, dpos) || !surface.dataToGraphics(dpos, false, gp) || !PlotUtil.isPointReal(gp)) continue;
            tracer.addVertex(gp.x, gp.y);
        }
        tracer.flush();
    }
}

