/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.layer.LineTracer;

public class LineStyle
implements Style {
    private final Color color_;
    private final Stroke stroke_;
    private final boolean antialias_;
    private final Icon legendIcon_;

    public LineStyle(Color color, Stroke stroke, boolean antialias) {
        this.color_ = color;
        this.stroke_ = stroke;
        this.antialias_ = antialias;
        this.legendIcon_ = new Icon(){
            final int width = 20;
            final int height = 12;

            @Override
            public int getIconWidth() {
                return 20;
            }

            @Override
            public int getIconHeight() {
                return 12;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Color color0 = g2.getColor();
                Stroke stroke0 = g2.getStroke();
                g2.setColor(LineStyle.this.color_);
                g2.setStroke(LineStyle.this.stroke_);
                int y1 = y + 6;
                g2.drawLine(x, y1, x + 20, y1);
                g2.setColor(color0);
                g2.setStroke(stroke0);
            }
        };
    }

    public Color getColor() {
        return this.color_;
    }

    public Stroke getStroke() {
        return this.stroke_;
    }

    public boolean getAntialias() {
        return this.antialias_;
    }

    @Override
    public Icon getLegendIcon() {
        return this.legendIcon_;
    }

    public LineTracer createLineTracer(Graphics g, Rectangle bounds, int nwork, boolean isPixel) {
        return new LineTracer(g, bounds, this.color_, this.stroke_, this.antialias_, nwork, isPixel);
    }

    public boolean equals(Object o) {
        if (o instanceof LineStyle) {
            LineStyle other = (LineStyle)o;
            return this.color_.equals(other.color_) && this.stroke_.equals(other.stroke_) && this.antialias_ == other.antialias_;
        }
        return false;
    }

    public int hashCode() {
        int code = 90125;
        code = 23 * code + this.color_.hashCode();
        code = 23 * code + this.stroke_.hashCode();
        code = 23 * code + (this.antialias_ ? 11 : 13);
        return code;
    }
}

