/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import uk.ac.starlink.ttools.plot2.PlotUtil;

public class LineTracer {
    private final int xlo_;
    private final int xhi_;
    private final int ylo_;
    private final int yhi_;
    private final double xVeryLo_;
    private final double xVeryHi_;
    private final double yVeryLo_;
    private final double yVeryHi_;
    private final Graphics2D g2_;
    private final int nwork_;
    private final double[] xWork_;
    private final double[] yWork_;
    private int iLine_;
    private boolean lastInclude_;
    private VertexStore lastVertex_;
    private int lastRegionX_;
    private int lastRegionY_;

    public LineTracer(Graphics g, Rectangle bounds, Color color, Stroke stroke, boolean antialias, int nwork, boolean isPixel) {
        this.nwork_ = nwork;
        this.xlo_ = bounds.x;
        this.xhi_ = bounds.x + bounds.width;
        this.ylo_ = bounds.y;
        this.yhi_ = bounds.y + bounds.height;
        this.g2_ = (Graphics2D)g.create();
        this.g2_.clip(bounds);
        this.g2_.setColor(color);
        this.g2_.setStroke(stroke);
        this.g2_.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        int huge = Math.max(bounds.width, bounds.height) * 100;
        this.xVeryLo_ = this.xlo_ - huge;
        this.xVeryHi_ = this.xhi_ + huge;
        this.yVeryLo_ = this.ylo_ - huge;
        this.yVeryHi_ = this.yhi_ + huge;
        this.xWork_ = new double[this.nwork_];
        this.yWork_ = new double[this.nwork_];
        this.lastVertex_ = LineTracer.createVertexStore(isPixel);
        this.lastInclude_ = true;
    }

    public void addVertex(double dx, double dy) {
        if (!this.lastVertex_.equalsVertex(dx, dy)) {
            boolean include;
            int regionX = LineTracer.getRegion(dx, this.xlo_, this.xhi_);
            int regionY = LineTracer.getRegion(dy, this.ylo_, this.yhi_);
            boolean bl = include = regionX * this.lastRegionX_ != 1 && regionY * this.lastRegionY_ != 1;
            if (include) {
                if (!this.lastInclude_) {
                    this.addIncludedVertex(this.lastVertex_.getX(), this.lastVertex_.getY());
                }
                this.addIncludedVertex(dx, dy);
            } else {
                this.flush();
            }
            this.lastVertex_.setVertex(dx, dy);
            this.lastInclude_ = include;
            this.lastRegionX_ = regionX;
            this.lastRegionY_ = regionY;
        }
    }

    public void flush() {
        if (this.iLine_ > 1) {
            this.g2_.draw(LineTracer.createLineShape(this.xWork_, this.yWork_, this.iLine_));
        }
        this.iLine_ = 0;
    }

    private void addIncludedVertex(double x, double y) {
        if (this.iLine_ == this.nwork_) {
            double x0 = this.xWork_[this.iLine_ - 1];
            double y0 = this.yWork_[this.iLine_ - 1];
            this.flush();
            this.xWork_[0] = x0;
            this.yWork_[0] = y0;
            ++this.iLine_;
        }
        x = Math.max(this.xVeryLo_, Math.min(this.xVeryHi_, x));
        y = Math.max(this.yVeryLo_, Math.min(this.yVeryHi_, y));
        this.xWork_[this.iLine_] = x;
        this.yWork_[this.iLine_] = y;
        ++this.iLine_;
    }

    private static int getRegion(double point, int lo, int hi) {
        return point >= (double)lo ? (point < (double)hi ? 0 : 1) : -1;
    }

    private static Shape createLineShape(double[] xs, double[] ys, int np) {
        GeneralPath path = new GeneralPath(1, np);
        path.moveTo((float)xs[0], (float)ys[0]);
        for (int ip = 1; ip < np; ++ip) {
            path.lineTo((float)xs[ip], (float)ys[ip]);
        }
        return path;
    }

    private static VertexStore createVertexStore(boolean isPixel) {
        if (isPixel) {
            return new VertexStore(){
                private int gx_ = Integer.MIN_VALUE;
                private int gy_ = Integer.MIN_VALUE;

                @Override
                public double getX() {
                    return this.gx_;
                }

                @Override
                public double getY() {
                    return this.gy_;
                }

                @Override
                public void setVertex(double x, double y) {
                    this.gx_ = this.toInt(x);
                    this.gy_ = this.toInt(y);
                }

                @Override
                public boolean equalsVertex(double x, double y) {
                    return this.toInt(x) == this.gx_ && this.toInt(y) == this.gy_;
                }

                private int toInt(double d) {
                    return PlotUtil.ifloor(d);
                }
            };
        }
        return new VertexStore(){
            private double dx_ = Double.NaN;
            private double dy_ = Double.NaN;

            @Override
            public double getX() {
                return this.dx_;
            }

            @Override
            public double getY() {
                return this.dy_;
            }

            @Override
            public void setVertex(double x, double y) {
                this.dx_ = x;
                this.dy_ = y;
            }

            @Override
            public boolean equalsVertex(double x, double y) {
                return x == this.dx_ && y == this.dy_;
            }
        };
    }

    private static interface VertexStore {
        public double getX();

        public double getY();

        public void setVertex(double var1, double var3);

        public boolean equalsVertex(double var1, double var3);
    }
}

