/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurface;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotter;
import uk.ac.starlink.ttools.plot2.layer.LineStyle;
import uk.ac.starlink.ttools.plot2.layer.LineTracer;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;

public class LinearFitPlotter
extends AbstractPlotter<LineStyle> {
    public static final ReportKey<double[]> COEFFS_KEY = new ReportKey<double[]>(new ReportMeta("coeffs", "Coefficients"), double[].class, false){

        @Override
        public String toText(double[] value) {
            return Arrays.toString(value);
        }
    };
    public static final ReportKey<String> EQUATION_KEY = ReportKey.createStringKey(new ReportMeta("equation", "Equation"), true);
    public static final ReportKey<Double> CORRELATION_KEY = ReportKey.createDoubleKey(new ReportMeta("correlation", "Correlation"), true);
    private static final ReportKey<Double> C0_KEY = ReportKey.createDoubleKey(new ReportMeta("c", "c"), true);
    private static final ReportKey<Double> C1_KEY = ReportKey.createDoubleKey(new ReportMeta("m", "m"), true);
    private static final FloatingCoord WEIGHT_COORD = FloatingCoord.createCoord(new InputMeta("weight", "Weight").setShortDescription("Weight for line fitting").setXmlDescription(new String[]{"<p>The weight associated with each data point", "for fitting purposes.", "This is used for calculating the coefficients of", "the line of best fit, and the correlation coefficient.", "If no coordinate is supplied, all points are assumed to", "have equal weight (1).", "Otherwise, any point with a null weight value", "is assigned a weight of zero, i.e. ignored.", "</p>", "<p>Given certain assumptions about independence of samples,", "a suitable value for the weight may be", "<code>1/(err*err)</code>, if <code>err</code> is the", "measurement error for each Y value.", "</p>"}), false);

    public LinearFitPlotter(boolean hasWeights) {
        Coord[] coordArray;
        if (hasWeights) {
            Coord[] coordArray2 = new Coord[1];
            coordArray = coordArray2;
            coordArray2[0] = WEIGHT_COORD;
        } else {
            coordArray = new Coord[]{};
        }
        super("LinearFit", ResourceIcon.FORM_LINEARFIT, CoordGroup.createCoordGroup(1, coordArray), true);
    }

    @Override
    public String getPlotterDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Plots a line of best fit for the data points.", "</p>"});
    }

    @Override
    public ConfigKey[] getStyleKeys() {
        ArrayList<ConfigKey<Boolean>> list = new ArrayList<ConfigKey<Boolean>>();
        list.add(StyleKeys.COLOR);
        list.addAll(Arrays.asList(StyleKeys.getStrokeKeys()));
        list.add(StyleKeys.ANTIALIAS);
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public LineStyle createStyle(ConfigMap config) {
        Color color = config.get(StyleKeys.COLOR);
        Stroke stroke = StyleKeys.createStroke(config, 1, 1);
        boolean antialias = config.get(StyleKeys.ANTIALIAS);
        return new LineStyle(color, stroke, antialias);
    }

    @Override
    public PlotLayer createLayer(final DataGeom geom, final DataSpec dataSpec, final LineStyle style) {
        LayerOpt layerOpt = new LayerOpt(style.getColor(), true);
        final CoordGroup cgrp = this.getCoordGroup();
        return new AbstractPlotLayer(this, geom, dataSpec, style, layerOpt){

            @Override
            public Drawing createDrawing(Surface surface, Map<AuxScale, Range> auxRanges, PaperType paperType) {
                return new LinearFitDrawing((PlaneSurface)surface, geom, dataSpec, cgrp, style, paperType);
            }
        };
    }

    private static double log(double val) {
        return Math.log10(val);
    }

    private static double unlog(double val) {
        return Math.pow(10.0, val);
    }

    private static class WXYStats {
        private double sw_;
        private double swX_;
        private double swY_;
        private double swXX_;
        private double swYY_;
        private double swXY_;

        private WXYStats() {
        }

        public void addPoint(double x, double y, double w) {
            if (w > 0.0 && !Double.isInfinite(w)) {
                this.sw_ += w;
                this.swX_ += w * x;
                this.swY_ += w * y;
                this.swXX_ += w * x * x;
                this.swYY_ += w * y * y;
                this.swXY_ += w * x * y;
            }
        }

        public void addPoint(double x, double y) {
            this.sw_ += 1.0;
            this.swX_ += x;
            this.swY_ += y;
            this.swXX_ += x * x;
            this.swYY_ += y * y;
            this.swXY_ += x * y;
        }

        public double[] getLinearCoefficients() {
            double sw2x = this.sw_ * this.swXX_ - this.swX_ * this.swX_;
            double c = (this.swXX_ * this.swY_ - this.swX_ * this.swXY_) / sw2x;
            double m = (this.sw_ * this.swXY_ - this.swX_ * this.swY_) / sw2x;
            return new double[]{c, m};
        }

        public double getCorrelation() {
            double sw2x = this.sw_ * this.swXX_ - this.swX_ * this.swX_;
            double sw2y = this.sw_ * this.swYY_ - this.swY_ * this.swY_;
            return (this.sw_ * this.swXY_ - this.swX_ * this.swY_) / Math.sqrt(sw2x * sw2y);
        }
    }

    private static class LinearFitPlan {
        final WXYStats stats_;
        final DataSpec dataSpec_;
        final boolean[] logFlags_;

        LinearFitPlan(WXYStats stats, DataSpec dataSpec, boolean[] logFlags) {
            this.stats_ = stats;
            this.dataSpec_ = dataSpec;
            this.logFlags_ = logFlags;
        }

        boolean matches(DataSpec dataSpec, boolean[] logFlags) {
            return dataSpec.equals(this.dataSpec_) && Arrays.equals(logFlags, this.logFlags_);
        }

        void paintLine(Graphics g, PlaneSurface surface, LineStyle style) {
            Rectangle bounds = surface.getPlotBounds();
            int gy0 = bounds.y;
            int gx1 = bounds.x - 10;
            int gx2 = bounds.x + bounds.width + 10;
            double dx1 = surface.graphicsToData(new Point(gx1, gy0), null)[0];
            double dx2 = surface.graphicsToData(new Point(gx2, gy0), null)[0];
            double dy1 = this.yFunction(dx1);
            double dy2 = this.yFunction(dx2);
            Point2D.Double gp1 = new Point2D.Double();
            Point2D.Double gp2 = new Point2D.Double();
            if (surface.dataToGraphics(new double[]{dx1, dy1}, false, gp1) && PlotUtil.isPointFinite(gp1) && surface.dataToGraphics(new double[]{dx2, dy2}, false, gp2) && PlotUtil.isPointFinite(gp2)) {
                LineTracer tracer = style.createLineTracer(g, bounds, 2, false);
                tracer.addVertex(gp1.x, gp1.y);
                tracer.addVertex(gp2.x, gp2.y);
                tracer.flush();
            }
        }

        private double yFunction(double x) {
            double[] coeffs = this.stats_.getLinearCoefficients();
            double y = coeffs[0] + coeffs[1] * (this.logFlags_[0] ? LinearFitPlotter.log(x) : x);
            return this.logFlags_[1] ? LinearFitPlotter.unlog(y) : y;
        }

        public ReportMap getReport() {
            double[] coeffs = this.stats_.getLinearCoefficients();
            String equation = new StringBuffer().append(this.logFlags_[1] ? "log10(y)" : "y").append(" = ").append(C1_KEY.getMeta().getShortName()).append(" * ").append(this.logFlags_[0] ? "log10(x)" : "x").append(" + ").append(C0_KEY.getMeta().getShortName()).toString();
            ReportMap report = new ReportMap();
            report.put(EQUATION_KEY, equation);
            report.put(C0_KEY, coeffs[0]);
            report.put(C1_KEY, coeffs[1]);
            report.put(CORRELATION_KEY, this.stats_.getCorrelation());
            report.put(COEFFS_KEY, coeffs);
            return report;
        }
    }

    private static class LinearFitDrawing
    implements Drawing {
        private final PlaneSurface surface_;
        private final DataGeom geom_;
        private final DataSpec dataSpec_;
        private final CoordGroup cgrp_;
        private final LineStyle style_;
        private final PaperType paperType_;

        LinearFitDrawing(PlaneSurface surface, DataGeom geom, DataSpec dataSpec, CoordGroup cgrp, LineStyle style, PaperType paperType) {
            this.surface_ = surface;
            this.geom_ = geom;
            this.dataSpec_ = dataSpec;
            this.cgrp_ = cgrp;
            this.style_ = style;
            this.paperType_ = paperType;
        }

        @Override
        public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
            boolean hasWeight;
            int icWeight;
            boolean[] logFlags = this.surface_.getLogFlags();
            for (Object knownPlan : knownPlans) {
                if (!(knownPlan instanceof LinearFitPlan) || !((LinearFitPlan)knownPlan).matches(this.dataSpec_, logFlags)) continue;
                return knownPlan;
            }
            WXYStats stats = new WXYStats();
            Point2D.Double gp = new Point2D.Double();
            boolean visibleOnly = false;
            boolean xlog = logFlags[0];
            boolean ylog = logFlags[1];
            TupleSequence tseq = dataStore.getTupleSequence(this.dataSpec_);
            int icPos = this.cgrp_.getPosCoordIndex(0, this.geom_);
            if (this.cgrp_.getExtraCoords().length > 0) {
                icWeight = this.cgrp_.getExtraCoordIndex(0, this.geom_);
                hasWeight = !this.dataSpec_.isCoordBlank(icWeight);
            } else {
                icWeight = -1;
                hasWeight = false;
            }
            double[] dpos = new double[this.geom_.getDataDimCount()];
            while (tseq.next()) {
                double y;
                if (!this.geom_.readDataPos(tseq, icPos, dpos) || !this.surface_.dataToGraphics(dpos, visibleOnly, gp) || !PlotUtil.isPointFinite(gp)) continue;
                double x = xlog ? LinearFitPlotter.log(dpos[0]) : dpos[0];
                double d = y = ylog ? LinearFitPlotter.log(dpos[1]) : dpos[1];
                if (hasWeight) {
                    double w = tseq.getDoubleValue(icWeight);
                    stats.addPoint(x, y, w);
                    continue;
                }
                stats.addPoint(x, y);
            }
            return new LinearFitPlan(stats, this.dataSpec_, logFlags);
        }

        @Override
        public void paintData(final Object plan, Paper paper, DataStore dataStore) {
            this.paperType_.placeDecal(paper, new Decal(){

                @Override
                public void paintDecal(Graphics g) {
                    ((LinearFitPlan)plan).paintLine(g, LinearFitDrawing.this.surface_, LinearFitDrawing.this.style_);
                }

                @Override
                public boolean isOpaque() {
                    return !LinearFitDrawing.this.style_.getAntialias();
                }
            });
        }

        @Override
        public ReportMap getReport(Object plan) {
            return ((LinearFitPlan)plan).getReport();
        }
    }
}

